**********************************************************
*                                                        *
*                S Y N T H . L O A D E R                 *
*                                                        *
*            Michael J. Mahon - Sep 30, 2008             *
*                                                        *
*       Copyright (c) 1996, 2003, 2004, 2005, 2008       *
*                                                        *
*   SYNTH.LOADER uses BCAST to load CRATE.SYNTH and its  *
*   voices, allowing each voice to be sent only once.    *
*                                                        *
*   It is &BRUN on each oscillator with the oscillator's *
*   music pre-loaded and its voice list inserted just    *
*   after SYNTH.LOADER's entry point.                    *
*                                                        *
*  SYNTH.LOADER does the following steps:                *
*     1. Clear screen and sign on                        *
*     2. Receive BCAST SYNTH code                        *
*     3. Display the voice list on screen                *
*     4. Receive BCAST voices, fixing up 'voicetbl',     *
*        allocating memory, and marking them loaded      *
*     5. When all voices loaded, jump to SYNTH entry     *
*                                                        *
**********************************************************
*                                                        *
*                    Change History                      *
*                                                        *
*   10/06/08:                                            *
*                                                        *
*   First version, adapted from ROM boot code.           *
*                                                        *
**********************************************************
         pag
******************** Version setup ***********************

         org   $200       ; Load to page 2
master   equ   0          ; Non-master version
dos      equ   0          ; Non-DOS version
crate    equ   1          ; Crate version compatibiluty
mserve   equ   0          ; Non-Message Server version
ROMboot  equ   0          ; ROM boot version
enhboot  equ   0          ; Enhanced //e version

         put   NADACONST
         use   NADAMACS
loadpnt  equ   $B800      ; Crate start address
         put   nadauser
         pag
**********************************************************
*                                                        *
*                    SYNTH.LOADER                        *
*                                                        *
**********************************************************

* Definitions

nav      equ   $7F        ; Next avail page stash
nleft    equ   $80        ; Voices left and load pages

SYNTH    equ   $800       ; SYNTH load address
startsyn equ   SYNTH+$80  ; SYNTH entry point
voicetbl equ   SYNTH+$380 ; SYNTH voice table
synthend equ   SYNTH+$2000 ; Music start address
music    equ   $08        ; SYNTH music ptr

go       jmp   start      ; Jump around data

vpage    db    0*0        ; Next unused page
nvoices  db    0*0        ; Number of voices
vlist    ds    14         ; Voice list

start    ldy   #signon-msg ; Sign on.
         jsr   prntmsg
         ldx   nvoices    ; Set # of voices
         stx   nleft      ;  left to load
         lda   #0         ;    and mark
:vinit   sta   nleft,x    ;     all unloaded.
         dex
         bne   :vinit
:again   jsr   waitbcst   ; Serve until BCAST
         cmp   #t_SYNTH   ;  of SYNTH code.
         bne   :again
         mov16 #SYNTH     ;address ; Receive SYNTH code
         jsr   rcvlong
         bcs   :again     ; If NG, try again.
         ldy   #voices-msg ; Set up for voices.
         jsr   prntmsg
:vagain  jsr   waitbcst   ; Receive a voice...
         cmp   #t_VOICE
         bne   :vagain
         ldx   nvoices    ; Do we need this voice?
:search  lda   nleft,x    ; Valid?
         bne   :skip      ; -No, skip this entry.
         lda   nvoices,x  ; -Yes, is voice
         cmp   address    ;   a hit?
         beq   :load      ; -Yes, load this voice.
:skip    dex              ; Iterate over
         bne   :search    ;  whole voice table.
         beq   :vagain    ; Try again. (always)

:load    clc              ; Compute ending page
         lda   vpage
         adc   length+1
         sta   nav        ; Save next avail page
         cmp   nadapage   ; Compare to NadaNet
         bcc   :ok        ; -Less is OK
         ldy   #overflow-msg ; Memory overflow!
         jsr   prntmsg
         jmp   servelp    ; Stop & serve.

:ok      lda   #0         ; Set up receive
         sta   address    ;  address.
         lda   vpage
         sta   address+1
         jsr   rcvlong    ; Receive the voice.
         bcs   :vagain    ; -Err.  Try again.
         lda   #" "       ; Print loaded voice #
         jsr   COUT
         lda   rbuf+adr   ; Print in hex.
         jsr   PRBYTE
         ldx   nvoices    ; Scan voice list
:vloop   lda   nleft,x    ;  for matches.
         bne   :no        ; -Already loaded
         lda   nvoices,x  ; Check match
         cmp   rbuf+adr   ;  with loaded voice.
         bne   :no        ; -Nope, try next.
         lda   vpage      ; -Match:
         sta   nleft,x    ;   Mark loaded
         sta   voicetbl-1,x ; Fix SYNTH's voicetbl
         dec   nleft      ;   One less to load
:no      dex              ; Iterate over
         bne   :vloop     ;  whole voice table.
         lda   vpage      ; Set pointer to
         sta   address+1  ;  envelope page.
         lda   #0
         sta   address
         tay
         clc
:reloc   lda   (address),y ; Relocate envelope
         adc   address+1  ;   page pointers.
         sta   (address),y
         iny
         bne   :reloc
         lda   nav        ; Recover next avail page
         sta   vpage
         lda   nleft      ; All pages loaded?
         beq   :ready     ; -Yes.
         jmp   :vagain    ; -No, keep loading.

:ready   ldy   #ready-msg ; -Yes, announce "Ready"
         jsr   prntmsg
         mov16 #synthend  ;music ; Set music ptr
         jmp   startsyn   ;       and start SYNTH.

waitbcst jsr   serve      ; Serve requests...
         lda   rbuf+rqmd  ; Is it a BCAST?
         cmp   #r_BCAST+rm_REQ
         bne   waitbcst   ; -No, keep serving.
         inc   rbuf+rqmd  ; -Yes. (Just once!)
         lda   address+1  ; Load BCAST data tag
         rts              ;  and return.

* Message handling

prntmsg  lda   msg,y      ; Print message (Y)
         beq   :done      ; Null terminates.
         jsr   COUT
         iny
         bne   prntmsg    ; (always)

:done    rts              ; Return

msg      equ   *          ; Message table origin
signon   asc   "CrateSynth",8D,00
voices   asc   "Voices",00
ready    db    $8D
         asc   "Ready",8D,00
overflow db    $8D
         asc   "Memory overflow",8D,00

endcode  equ   *
         err   *-1/$3C0   ; Can't exceed $3C0
         end
