**********************************************************
*                                                        *
*               T E S T . N A D A B R U N                *
*                                                        *
*            Michael J. Mahon - Sep 27, 2008             *
*                                                        *
*       Copyright (c) 1996, 2003, 2004, 2005, 2008       *
*                                                        *
*   TEST.NADABRUN is used by TEST.NADANET to test &BRUN  *
*   and &BCAST.                                          *
*                                                        *
*   TEST.NADABRUN performs the following actions:        *
*     1. Sets flag @ $200 to "fail"                      *
*     2. Waits for a BCAST request                       *
*     3. If &BCAST received, sets flag to (address+1)    *
*     4. Returns to 'servelp'                            *
*                                                        *
**********************************************************
*                                                        *
*                    Change History                      *
*                                                        *
*   09/27/08:                                            *
*                                                        *
*   First version, adapted from CR.BPRUNNER code.        *
*                                                        *
**********************************************************
         pag
******************** Version setup ***********************

         org   $200       ; Load to page 2
master   equ   0          ; Non-master version
dos      equ   0          ; Non-DOS version
crate    equ   1          ; Crate version compatibiluty
mserve   equ   0          ; Non-Message Server version
ROMboot  equ   0          ; ROM boot version
enhboot  equ   0          ; Enhanced //e version

         put   NADACONST
         use   NADAMACS
loadpnt  equ   $B800      ; Crate start address
         put   nadauser
         pag
**********************************************************
*                                                        *
*                   TEST.NADABRUN                        *
*                                                        *
**********************************************************

wait     equ   500        ; Timeout in milliseconds

start    ldy   #0         ; Print the signon
:msglp   lda   wtmsg,y    ;  message.
         jsr   COUT
         iny
         cpy   #]wtlen
         bcc   :msglp
         lda   #0         ; Set flag to
         sta   start      ;  error state.
:restart lda   #wait/idletime ; Number of 20 ms
         sta   servecnt   ; iterations to timeout.
         jsr   serve      ; Serve request.
         lda   rbuf+rqmd
         cmp   #r_BCAST+rm_REQ ; BCAST request?
         bne   :restart   ; -No, start over.
         inc   rbuf+rqmd  ; -Yes. (Just once!)
         lda   address+1  ; Put hi byte of adr
         sta   start      ;  into result flag.
         rts              ;   and return.

wtmsg    asc   "Running TEST.NADABRUN",8D
]wtlen   equ   *-wtmsg    ; Length of msg.

endcode  equ   *
         err   */$300     ; Can't exceed $2FF
         end
