;
; APPLE depacker for executables packed with PRGPACK 
;

                processor 6502
MODEL = $FB60

PackedOrigin    = $4000                     ;Can be any other.

PackedLenght = End-depacker
               org PackedOrigin-4
               dc.b #<depacker
               dc.b #>depacker
               dc.b #<PackedLenght
               dc.b #>PackedLenght

DEPACKADR       = $0800     ;Same as the assembled program.

strlen          = $80       ;Zero page cells.
bitcode         = $81       ;They are used by BASIC, but BASIC is in
srcl            = $82       ;no use in this game.
srch            = $83
destl           = $84
desth           = $85

depacker        jsr MODEL            ;Show Apple ][ model.
                lda #<packeddata     ;Right after the depacker
                sta srcl             ;I place the packed data.
                lda #>packeddata
                sta srch
                lda #>DEPACKADR      ;DepackADR Hi
                sta desth
                lda #<DEPACKADR      ;DepackADR Lo
                sta destl            ;Change them for your executable.
                tax                  ;x and y registers must be zeroed,
                tay                  ;else it will crash on IIGS.
depackstart:    txa                  ;Time to get new bit-code?
                bne dp_nonew
                jsr dp_get
                sta bitcode
                ldx #$08                        ;Eight bits now...
dp_nonew:       dex                             ;Get one bit from the bitcode,
                lsr bitcode                     ;that tells whether the next
                bcs dp_string                   ;byte in the stream is an
                jsr dp_get                      ;unpacked byte or a string.
                jsr dp_put
                jmp depackstart
dp_string:      jsr dp_get                      ;If it's a string, take its
                sta dp_copystrpos+1             ;offset and length.
                jsr dp_get
                sta strlen
dp_copystring:  dec desth                       ;String copying loop.
dp_copystrpos:  ldy #$00
                lda (destl),y
                inc desth
                ldy #$00
                jsr dp_put
                dec strlen
                bne dp_copystring
                jmp depackstart

dp_get:         lda (srcl),y                    ;Get byte at source pointer.
                pha
                tya
                sta (srcl),y
                pla
                inc srcl
                bne dp_get2
                inc srch
dp_get2:        rts

start:          ;Everything is depacked. Start the depacked program.
                jmp $0800

dp_put:         sta (destl),y                   ;Put byte at destination
                inc destl                       ;pointer
                bne dp_put2
                inc desth
                pha
                lda desth
                cmp #$40          ;High end of the packed data.
                beq start
                pla
dp_put2:        rts 

packeddata:
         incbin MAZE.COMP ;No headers just raw data eg /r switch
End
