// WARNING: If you are looking for example of "good" code, this App source code is NOT it!  It was written in a
// hurry due to a contest deadline and should probably be rewritten from scratch. You have been warned...
//
// ConfigPVCC.cpp
// Simple dialog based windows Application to upload and download configuration data to the PVCC control board
// via RS232 serial link. This file contains the App init code and the second worker communication thread written in C.
//
//Copyright (c) 2003, Richard Dreher d/b/a R&D Automation
//All rights reserved.
//
//Redistribution and use in source and binary forms, with or without modification, are permitted provided
//that the following conditions are met:
//
// * Redistributions of source code must retain the above copyright notice, this list of conditions and
//   the following disclaimer.
// * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
//   the following disclaimer in the documentation and/or other materials provided with the distribution.
// * Neither the name of the R&D Automation/Richard Dreher nor the names of its contributors may be used
//   to endorse or promote products derived from this software without specific prior written permission.
//
//THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
//WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
//ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
//(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
//OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
//STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//
#include "stdafx.h"
#include "ConfigPVCC.h"
#include "ConfigPVCCDlg.h"
#include "ConfigPVCC_comm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*----------- Function Prototypes ------------*/
UINT CommThread(LPVOID pParam);
WORD CRC16(BYTE *DataBuffer, unsigned short Count);
WORD BinToBCD(WORD BinValue);

/*-------------- Global Variables -------------*/
HANDLE  hCommEvent;                     // Handle to event to signal comm thread to process request
HANDLE  hCommEndThreadEvent;            // Hangle to event to signal comm thread to end
HANDLE  hThreadEvents[2];               // Array of handles for 
BYTE    CommRequest;                    // Request instruction from main Dlg routine, based on user action.

REQUEST_BUFFER CommRequestBuffer;
BYTE CommResponseBuffer[256];
char NoiseBin[256];                         // Used because there is no function to flush the async read buffer of characters

CConfigPVCCDlg* pConfigPVCCDlg;							// Create a Setup dialog object pointer
extern HWND hConfigPVCCDlg;

/////////////////////////////////////////////////////////////////////////////
// CConfigPVCCApp

BEGIN_MESSAGE_MAP(CConfigPVCCApp, CWinApp)
	//{{AFX_MSG_MAP(CConfigPVCCApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigPVCCApp construction

CConfigPVCCApp::CConfigPVCCApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CConfigPVCCApp object

CConfigPVCCApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CConfigPVCCApp initialization

BOOL CConfigPVCCApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif


	//RWD: Create an Event Object to signal comm thread to process a request
	hCommEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	ASSERT(hCommEvent != NULL);

	//RWD: Create an Event Object to signal comm thread to end
	hCommEndThreadEvent = CreateEvent(NULL, FALSE, FALSE, NULL);
	ASSERT(hCommEndThreadEvent != NULL);

  hThreadEvents[0] = hCommEvent;
  hThreadEvents[1] = hCommEndThreadEvent;

	//RWD: Start a second worker thread
	CommRequest = 0;
	CWinThread *pCommThread = AfxBeginThread((AFX_THREADPROC)CommThread, 0, THREAD_PRIORITY_NORMAL, 0, 0);
  ASSERT(pCommThread != NULL);
  

	CConfigPVCCDlg dlg;

  pConfigPVCCDlg = &dlg;    
  m_pMainWnd = &dlg;

	int nResponse = dlg.DoModal();

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

//------------------------------------------------------------------------------------------
// Function: UINT CommThread(LPVOID pParam) - Comm Portion
//------------------------------------------------------------------------------------------ 

UINT CommThread(LPVOID pParam)
{

  PVCC_CONFIG_DATA* pResponseConfigData = (PVCC_CONFIG_DATA*)&CommResponseBuffer;
  WORD  ReqPacketLength = 0;
  WORD  RspPacketLength = 0;
  unsigned char CommState = STATE_IDLE;
	unsigned char CommRetryCount;
	unsigned short	crc;
	LPARAM LastCommError;
  BOOL	  fEndCommThread = FALSE;    // Boolean flag to signal worker thread to close port and exit normally

	DWORD CommBytesWritten;
	DWORD CommBytesRead;
	DWORD LastCOMAPIError;
	DWORD EventCause;
	BOOL rc;
  DCB PortDCB;
	COMMTIMEOUTS CommTimeouts;
	HANDLE hCommPort = NULL;
  BYTE* pCommRequestBuffer = (BYTE *)&CommRequestBuffer;
  unsigned short ComPort;
	CommRequest = 0;
  CString strCOMPort;
  int n=0, len=0;

	do
	{
		switch(CommState)
		{
			case STATE_IDLE:
      	if(hCommPort)       // Each time a transaction completes, close the serial port
        {
          CloseHandle(hCommPort);
        }
    		// Wait for the user to request the Thread to activate or to end.
				EventCause = WaitForMultipleObjects(2, &hThreadEvents[0], FALSE, INFINITE);

        if (EventCause == WAIT_OBJECT_0)
				{
					if(CommRequest > 0)
					{
						LastCommError = COMM_NO_ERROR;
						CommRetryCount = 0;
						CommState = STATE_OPEN_PORT;
					}
				}
        else
        {
        	fEndCommThread = TRUE;
        }
				break;

      case STATE_OPEN_PORT:
        ComPort = pConfigPVCCDlg->m_ConfigComPort + 1;
        if(ComPort < 1 || ComPort > 4)
        {
          LastCommError = COMM_INVALID_COM_PORT;
  				PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
					CommState = STATE_IDLE;
					CommRequest = 0;
          break;
        }

        // Open the serial port.for each transaction. This keeps the serial port resource free when nothing is happening.
        strCOMPort.Format("COM%d", ComPort);
        hCommPort = CreateFile((char *)(LPCTSTR)strCOMPort,                // Pointer to the name of the port
                           GENERIC_READ | GENERIC_WRITE,	// Access (read/write) mode
                           0,                             // Share mode
                           NULL,                          // Pointer to the security attribute
                           OPEN_EXISTING,                 // How to open the serial port
                           NULL,                          // Port attributes
                           NULL);                         // Handle to port with attribute to copy
        
			  if(hCommPort == INVALID_HANDLE_VALUE) 
				{
          LastCommError = COMM_OPEN_FAILED;
  				PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
					CommState = STATE_IDLE;
					CommRequest = 0;
          break;
        }
        
			  PortDCB.DCBlength = sizeof(DCB);     
      	
        // Get the default port setting information.
        GetCommState(hCommPort, &PortDCB);
        
        // Change the DCB structure settings.
        PortDCB.BaudRate          = COMM_BAUD;      // Current baud 
        PortDCB.fBinary           = TRUE;           // Binary mode; no EOF check 
        PortDCB.fParity           = FALSE;          // Disable parity checking. 
        PortDCB.fOutxCtsFlow      = FALSE;          // No CTS output flow control 
        PortDCB.fOutxDsrFlow      = FALSE;          // No DSR output flow control 
        PortDCB.fDtrControl       = FALSE;          // DTR flow control type 
        PortDCB.fDsrSensitivity   = FALSE;          // DSR sensitivity 
        PortDCB.fTXContinueOnXoff = FALSE;          // XOFF continues Tx 
        PortDCB.fOutX             = FALSE;          // No XON/XOFF out flow control 
        PortDCB.fInX              = FALSE;          // No XON/XOFF in flow control 
        PortDCB.fErrorChar        = FALSE;          // Disable error replacement. 
        PortDCB.fNull             = FALSE;          // Disable null stripping. 
        PortDCB.fRtsControl       = FALSE;          // RTS flow control 
        PortDCB.fAbortOnError     = FALSE;          // Do not abort reads/writes on error.
        PortDCB.ByteSize          = 8;              // Number of bits/bytes, 4-8 
        PortDCB.Parity            = NOPARITY;       // 0-4=no,odd,even,mark,space 
        
        // Use 2 stop bits.
        // The PVCC unit's UART is software based and need the extra delay given by 2 stop bit to work properly.
        PortDCB.StopBits          = TWOSTOPBITS;     // 0,1,2 = 1, 1.5, 2
        
        // Configure the port according to the specifications of the DCB structure.
        if (!SetCommState(hCommPort, &PortDCB))
        {
          // Could not configure the serial port.
			  	LastCommError = COMM_CONFIG_FAILED;
  				PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
					CommState = STATE_IDLE;
					CommRequest = 0;
          break;
        }
			  // Retrieve the time-out parameters for all read and write operations on the port. 
      	GetCommTimeouts (hCommPort, &CommTimeouts);
        
        // Change the COMMTIMEOUTS structure settings.
        CommTimeouts.ReadIntervalTimeout = 0;  
        CommTimeouts.ReadTotalTimeoutMultiplier = 1;  
        CommTimeouts.ReadTotalTimeoutConstant = COMM_RESPONSE_DELAY;    
        CommTimeouts.WriteTotalTimeoutMultiplier = 10;  
        CommTimeouts.WriteTotalTimeoutConstant = 1000;    
        
        // Set the time-out parameters for all read and write operations on the port. 
        if (!SetCommTimeouts(hCommPort, &CommTimeouts))
        {
          // Could not set the time-out parameters.
			  	LastCommError = COMM_SET_TIMEOUT_FAILED;
  				PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
					CommState = STATE_IDLE;
					CommRequest = 0;
          break;
        }

        CommState = STATE_PROCESS_REQUEST;
        break;
      
      
      case STATE_PROCESS_REQUEST:

				switch(CommRequest)
				{
					case CMD_GET_CONFIG:
						CommRequestBuffer.Instruction = CMD_GET_CONFIG;
            ReqPacketLength = CMD_GET_CONFIG_REQ_LEN;
            RspPacketLength = CMD_GET_CONFIG_RSP_LEN;
  					break;

					case CMD_SEND_CONFIG:
						CommRequestBuffer.Instruction     = CMD_SEND_CONFIG;
            CommRequestBuffer.CRC16           = 0;
            CommRequestBuffer.ConfigVersion   = PVCC_CONFIG_DATA_VERSION; 
            CommRequestBuffer.UpdatePeriod    = pConfigPVCCDlg->m_ConfigUpdatePeriodSeconds;

            n = pConfigPVCCDlg->m_ConfigMaxVolts.Find('.');
            len = pConfigPVCCDlg->m_ConfigMaxVolts.GetLength();
            if (n==-1)
            {
              CommRequestBuffer.MaxChargeVolts  = pConfigPVCCDlg->ShortSwap(atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigMaxVolts));
            }
            else
            {
              CommRequestBuffer.MaxChargeVolts = atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigMaxVolts.Left(n)) << 8;
              CommRequestBuffer.MaxChargeVolts |= (0x0019 * atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigMaxVolts.Mid(n + 1, 1)));
              //Swap the byte order
              CommRequestBuffer.MaxChargeVolts = pConfigPVCCDlg->ShortSwap(CommRequestBuffer.MaxChargeVolts);
            }
            
            n = pConfigPVCCDlg->m_ConfigMinVolts.Find('.');
            len = pConfigPVCCDlg->m_ConfigMinVolts.GetLength();
            if (n==-1)
            {
              CommRequestBuffer.MinChargeVolts  = pConfigPVCCDlg->ShortSwap(atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigMinVolts));
            }
            else
            {
              CommRequestBuffer.MinChargeVolts = atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigMinVolts.Left(n)) << 8;
              CommRequestBuffer.MinChargeVolts |= (0x0019 * atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigMinVolts.Mid(n + 1, 1)));
              CommRequestBuffer.MinChargeVolts = pConfigPVCCDlg->ShortSwap(CommRequestBuffer.MinChargeVolts);
            }              

            n = pConfigPVCCDlg->m_ConfigLVD.Find('.');
            len = pConfigPVCCDlg->m_ConfigLVD.GetLength();
            if (n==-1)
            {
              CommRequestBuffer.DisconnectVolts  = pConfigPVCCDlg->ShortSwap(atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigLVD));
            }
            else
            {
              CommRequestBuffer.DisconnectVolts = atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigLVD.Left(n)) << 8;
              CommRequestBuffer.DisconnectVolts |= (0x0019 * atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigLVD.Mid(n + 1, 1)));
              CommRequestBuffer.DisconnectVolts = pConfigPVCCDlg->ShortSwap(CommRequestBuffer.DisconnectVolts);
            }              

            n = pConfigPVCCDlg->m_ConfigLVDReconnect.Find('.');
            len = pConfigPVCCDlg->m_ConfigLVDReconnect.GetLength();
            if (n==-1)
            {
              CommRequestBuffer.ReconnectVolts  = pConfigPVCCDlg->ShortSwap(atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigLVDReconnect));
            }
            else
            {
              CommRequestBuffer.ReconnectVolts = atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigLVDReconnect.Left(n)) << 8;
              CommRequestBuffer.ReconnectVolts |= (0x0019 * atoi((char *)(LPCTSTR)pConfigPVCCDlg->m_ConfigLVDReconnect.Mid(n + 1, 1)));
              CommRequestBuffer.ReconnectVolts = pConfigPVCCDlg->ShortSwap(CommRequestBuffer.ReconnectVolts);
            }              

            CommRequestBuffer.MaxChargeTemp   = pConfigPVCCDlg->ShortSwap(pConfigPVCCDlg->m_ConfigMaxTemp);
            
            CommRequestBuffer.MaxOffLightLevel = pConfigPVCCDlg->m_ConfigLightOffLevel;
            CommRequestBuffer.MinOnLightLevel = pConfigPVCCDlg->m_ConfigLightOnLevel;
            CommRequestBuffer.EnableLVD       = pConfigPVCCDlg->m_ConfigEnableLVD;
            CommRequestBuffer.EnableLoadControl = pConfigPVCCDlg->m_ConfigEnableLoadCtrl;

            CommRequestBuffer.EnableCharging  = pConfigPVCCDlg->m_ConfigEnableCharge;
            CommRequestBuffer.UseTempSensor   = pConfigPVCCDlg->m_ConfigUseTempSensor;
            CommRequestBuffer.EnableOSD       = pConfigPVCCDlg->m_ConfigEnableOSD;
            CommRequestBuffer.DisplayAtBottom = pConfigPVCCDlg->m_ConfigOSDRadio;
            CommRequestBuffer.EnableCallsign  = pConfigPVCCDlg->m_ConfigEnableCallSign;
            ZeroMemory((PVOID)CommRequestBuffer.CallsignText, strlen(CommRequestBuffer.CallsignText));
            strcpy(CommRequestBuffer.CallsignText, pConfigPVCCDlg->m_ConfigCallSign);


            ReqPacketLength = CMD_SEND_CONFIG_REQ_LEN;
            RspPacketLength = CMD_SEND_CONFIG_RSP_LEN;

    				CommRequestBuffer.CRC16 = pConfigPVCCDlg->ShortSwap(CRC16((BYTE *)&(CommRequestBuffer.ConfigVersion), ReqPacketLength - sizeof(CommRequestBuffer.CRC16) - sizeof(CommRequestBuffer.Instruction)));
  					break;

					default:
            // An unsupported command was requested from the dialog window/User, so return an error
            // Post a message to the dialog if its handle is valid.
						if(hConfigPVCCDlg)
						{
							PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)CommRequest, (LPARAM)COMM_INVALID_REQUEST);
						}
						CommState = STATE_IDLE;
						CommRequest = 0;
	  				break;

				}
        CommState = STATE_SEND_REQUEST;
		  	break;

			case STATE_SEND_REQUEST:
				rc = WriteFile(hCommPort,(LPCVOID)&CommRequestBuffer, ReqPacketLength, &CommBytesWritten, NULL);

				if (!rc || (CommBytesWritten != ReqPacketLength))
				{
          LastCommError = COMM_WRITE_FAILED;
          PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
					CommState = STATE_IDLE;
					CommRequest = 0;
				}
        CommState = STATE_WAIT_FOR_RESPONSE;
  			break;
			
			case STATE_WAIT_FOR_RESPONSE:
        
        // All data sent out serial port will be echoed back to serial port by remote end. So read echoed bytes and dump them.
        rc = ReadFile(hCommPort, (LPVOID)&NoiseBin, ReqPacketLength, &CommBytesRead, NULL);
        // Read response data. Wait for up to 1s before timing-out.
        rc = ReadFile(hCommPort, (LPVOID)&CommResponseBuffer, RspPacketLength, &CommBytesRead, NULL);
				if(rc && (CommBytesRead >= RspPacketLength))
				{
					CommState = STATE_CHECK_RESPONSE;
				}
				else
				{
          LastCOMAPIError = GetLastError();
          LastCommError = COMM_RECEIVED_NO_VALID_RESPONSE;
					CommState = STATE_RETRY;
				}
  			break;

			case STATE_RETRY:
				Sleep(RETRY_DELAY);
				CommRetryCount++;
				if(CommRetryCount > COMM_MAX_RETRIES)
				{
					CommState = STATE_IDLE;					//Give up
					if(hConfigPVCCDlg)
					{
  					//Send back a message to the GUI thread that the transaction failed.
            // Note: Leave LastCommError set to whatever caused the problem. Don't set here.
						PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
					}
					CommRequest = 0;      // release GUI thread to issue new command.
				}
				else
				{
					CommState = STATE_SEND_REQUEST;

          // Turn off read timeouts to read any gibberish data from port
          GetCommTimeouts (hCommPort, &CommTimeouts);
          CommTimeouts.ReadIntervalTimeout = 0;  
          CommTimeouts.ReadTotalTimeoutMultiplier = 0;  
          CommTimeouts.ReadTotalTimeoutConstant = 1;    
          if (!SetCommTimeouts(hCommPort, &CommTimeouts))
          {
            LastCommError = COMM_SET_TIMEOUT_FAILED;
						PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
  					CommState = STATE_IDLE;
	  				CommRequest = 0;
          }

          //Read any gibberish or unexpected data from the port
          ReadFile(hCommPort, (LPVOID)&NoiseBin, sizeof(NoiseBin), &CommBytesRead, NULL);

          // Set timeouts back to normal
          GetCommTimeouts (hCommPort, &CommTimeouts);
          CommTimeouts.ReadIntervalTimeout = 0;  
          CommTimeouts.ReadTotalTimeoutMultiplier = 1;  
          CommTimeouts.ReadTotalTimeoutConstant = COMM_RESPONSE_DELAY;    
          CommTimeouts.WriteTotalTimeoutMultiplier = 10;  
          CommTimeouts.WriteTotalTimeoutConstant = 1000;    
          if (!SetCommTimeouts(hCommPort, &CommTimeouts))
          {
            LastCommError = COMM_SET_TIMEOUT_FAILED;
            PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
  					CommState = STATE_IDLE;
	  				CommRequest = 0;
          }
				}
	  		break;

			case STATE_CHECK_RESPONSE:
				CommState = STATE_PROCESS_RESPONSE;

				switch(CommRequest)
				{
					case CMD_GET_CONFIG:
            crc = CRC16((BYTE *)&(pResponseConfigData->ConfigVersion), RspPacketLength - sizeof(WORD));
            // Check the message CRC against locally calculated CRC
      			if(pResponseConfigData->CRC16 != pConfigPVCCDlg->ShortSwap(crc))
	  	    	{
		  		    LastCommError = COMM_RECEIVED_BAD_CRC;
      				CommState = STATE_RETRY;
	    			}
		  			break;

					case CMD_SEND_CONFIG:
            if(CommResponseBuffer[0] == RSP_ID_BYTE && CommResponseBuffer[1] == RSP_BAD_CRC)
            {
		  		    LastCommError = COMM_PVCC_REPORTED_BAD_CRC;
      				CommState = STATE_RETRY;
            }

            if(CommResponseBuffer[0] != RSP_ID_BYTE)
            {
		  		    LastCommError = COMM_RECEIVED_INVALID_RESPONSE;
      				CommState = STATE_RETRY;
            }
			  		break;

				}
  			break;	

			case STATE_PROCESS_RESPONSE:
				if(hConfigPVCCDlg)
				{
					PostMessage(hConfigPVCCDlg, COMM_RESPONSE_RECEIVED, (WPARAM)CommRequestBuffer.Instruction, 0);
				}
				CommRequest = 0;
				CommState = STATE_IDLE;
  			break;
		}
	} while(!fEndCommThread);
	return 0;		// End of thread
}

WORD CRC16(BYTE *DataBuffer, WORD Count)
{
  WORD crc;
  
  crc = 0xFFFF;
  while(Count--)
  {
    crc = (crc<<8) ^ CRCTable[(crc>>8) ^ *DataBuffer++];
  }
  return(crc);
}    


//Convert a binary number to a BCD number
WORD BinToBCD(WORD BinValue)
{
  BYTE Thousands = 0;
  BYTE Hundreds  = 0;
  BYTE Tens      = 0;
  WORD BCDResult;

  while(BinValue >= 1000)
  {
    BinValue -= 1000;
    Thousands++;
  }
  while(BinValue >= 100)
  {
    BinValue -= 100;
    Hundreds++;
  }
  while(BinValue >= 10)
  {
    BinValue -= 10;
    Tens++;
  }

  BCDResult = (Thousands << 12) | (Hundreds << 8) | (Tens << 4) | BinValue;

  return BCDResult;
}
