// ConfigPVCCDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ConfigPVCC.h"
#include "ConfigPVCCDlg.h"
#include "ConfigPVCC_comm.h"
#include "SelectCommDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigPVCCDlg dialog

CConfigPVCCDlg::CConfigPVCCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigPVCCDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigPVCCDlg)
	m_ConfigVersion = 0;
	m_ConfigMaxVolts = _T("00.0");
	m_ConfigMinVolts = _T("00.0");
	m_ConfigCallSign = _T("");
	m_ConfigEnableCallSign = TRUE;
	m_ConfigEnableOSD = TRUE;
	m_ConfigOSDRadio = 1;
	m_ConfigUpdatePeriodSeconds = 10;
	m_ConfigEnableCharge = TRUE;
	m_ConfigUseTempSensor = TRUE;
	m_ConfigMaxTemp = 0;
	m_ConfigLVD = _T("00.0");
	m_ConfigLVDReconnect = _T("00.0");
	m_ConfigEnableLVD = TRUE;
	m_ConfigEnableLoadCtrl = TRUE;
	m_ConfigLightOffLevel = 0;
	m_ConfigLightOnLevel = 0;
	//}}AFX_DATA_INIT
  m_ConfigComPort = 0;  // Default to COM1 for now: 0 = first radio button in list

  // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CConfigPVCCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigPVCCDlg)
	DDX_Text(pDX, IDC_CONFIG_VERSION, m_ConfigVersion);
	DDV_MinMaxByte(pDX, m_ConfigVersion, 0, 255);
	DDX_Text(pDX, IDC_CONFIG_MAX_VOLTS, m_ConfigMaxVolts);
	DDV_MaxChars(pDX, m_ConfigMaxVolts, 4);
	DDX_Text(pDX, IDC_CONFIG_MIN_VOLTS, m_ConfigMinVolts);
	DDV_MaxChars(pDX, m_ConfigMinVolts, 4);
	DDX_Text(pDX, IDC_CONFIG_CALLSIGN, m_ConfigCallSign);
	DDV_MaxChars(pDX, m_ConfigCallSign, 9);
	DDX_Check(pDX, IDC_CONFIG_ENABLE_CALLSIGN, m_ConfigEnableCallSign);
	DDX_Check(pDX, IDC_CONFIG_ENABLE_OSD, m_ConfigEnableOSD);
	DDX_Radio(pDX, IDC_CONFIG_OSD_TOP, m_ConfigOSDRadio);
	DDX_Text(pDX, IDC_CONFIG_UPDATE_PERIOD, m_ConfigUpdatePeriodSeconds);
	DDV_MinMaxByte(pDX, m_ConfigUpdatePeriodSeconds, 4, 255);
	DDX_Check(pDX, IDC_CONFIG_ENABLE_CHARGE, m_ConfigEnableCharge);
	DDX_Check(pDX, IDC_CONFIG_USE_TEMP_SENSOR, m_ConfigUseTempSensor);
	DDX_Text(pDX, IDC_CONFIG_MAX_TEMP, m_ConfigMaxTemp);
	DDV_MinMaxInt(pDX, m_ConfigMaxTemp, 0, 255);
	DDX_Text(pDX, IDC_CONFIG_LVD, m_ConfigLVD);
	DDV_MaxChars(pDX, m_ConfigLVD, 4);
	DDX_Text(pDX, IDC_CONFIG_LVD_RECON, m_ConfigLVDReconnect);
	DDV_MaxChars(pDX, m_ConfigLVDReconnect, 4);
	DDX_Check(pDX, IDC_CONFIG_ENABLE_LVD, m_ConfigEnableLVD);
	DDX_Check(pDX, IDC_ENABLE_LOAD_CTRL, m_ConfigEnableLoadCtrl);
	DDX_Text(pDX, IDC_CONFIG_LIGHT_OFF_LEVEL, m_ConfigLightOffLevel);
	DDV_MinMaxByte(pDX, m_ConfigLightOffLevel, 0, 255);
	DDX_Text(pDX, IDC_CONFIG_LIGHT_ON_LEVEL, m_ConfigLightOnLevel);
	DDV_MinMaxByte(pDX, m_ConfigLightOnLevel, 0, 255);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CConfigPVCCDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigPVCCDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_GET_CONFIG, OnGetConfig)
	ON_BN_CLICKED(IDC_SEND_CONFIG, OnSendConfig)
	ON_COMMAND(ID_ABOUT, OnAbout)
	ON_COMMAND(ID_FILE_EXIT, OnFileExit)
	ON_WM_CLOSE()
	ON_COMMAND(ID_FILE_SERIALPORT, OnFileSerialport)
	ON_BN_CLICKED(IDC_CONFIG_ENABLE_OSD, OnConfigEnableOsd)
	ON_BN_CLICKED(IDC_CONFIG_ENABLE_CALLSIGN, OnConfigEnableCallsign)
	ON_BN_CLICKED(IDC_CONFIG_ENABLE_CHARGE, OnConfigEnableCharge)
	ON_BN_CLICKED(IDC_CONFIG_USE_TEMP_SENSOR, OnConfigUseTempSensor)
	ON_BN_CLICKED(IDC_CONFIG_ENABLE_LVD, OnEnableLvd)
	ON_BN_CLICKED(IDC_ENABLE_LOAD_CTRL, OnEnableLoadCtrl)
	//}}AFX_MSG_MAP
  ON_THREAD_MESSAGE(COMM_RESPONSE_RECEIVED, OnCommResponseReceived)
  ON_THREAD_MESSAGE(COMM_RESPONSE_FAILED, OnResponseFailed)
//  ON_THREAD_MESSAGE(COMM_RESPONSE_FAILED, OnCommResponseFailed)
END_MESSAGE_MAP()


HWND hConfigPVCCDlg;

extern HANDLE hCommEvent;
extern HANDLE hCommEndThreadEvent;
extern BYTE CommRequest;
extern BYTE CommResponseBuffer[256];
/////////////////////////////////////////////////////////////////////////////
// CConfigPVCCDlg message handlers

BOOL CConfigPVCCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

  hConfigPVCCDlg = GetSafeHwnd();


  // Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

  // Update the state of the dialog items. Active or Grayed
  OnConfigEnableOsd();
  OnConfigEnableCallsign();
  OnConfigEnableCharge();
  
  return TRUE;  // return TRUE  unless you set the focus to a control
}



// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CConfigPVCCDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CConfigPVCCDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CConfigPVCCDlg::OnGetConfig() 
{
  if(CommRequest == 0)            // Check if any previous request is still active. If so, ignore this one.
  {
    CommRequest = CMD_GET_CONFIG;
    SetEvent(hCommEvent);             // Signal Comm thread to process user's request
    DisableButtons();
  }
}


void CConfigPVCCDlg::OnSendConfig() 
{
	// TODO: Add your control notification handler code here
  UpdateData(TRUE);  //Get Data from Dialog entries
  if(CommRequest == 0)            // Check if any previous request is still active. If so, ignore this one.
  {
    CommRequest = CMD_SEND_CONFIG;
    SetEvent(hCommEvent);             // Signal Comm thread to process user request
    DisableButtons();
  }
}

void CConfigPVCCDlg::DisableButtons()
{
// Disable the "Get Config Data" button
  CWnd* pW = GetDlgItem(IDC_GET_CONFIG);
  pW->EnableWindow(FALSE);

// Disable the "Send Config Data" button
  pW = GetDlgItem(IDC_SEND_CONFIG);
  pW->EnableWindow(FALSE);

// Disable the "Sample rate" entry box
  pW = GetDlgItem(IDC_CONFIG_UPDATE_PERIOD);
  pW->EnableWindow(FALSE);

// Disable the "Max Volts" entry box
  pW = GetDlgItem(IDC_CONFIG_MAX_VOLTS);
  pW->EnableWindow(FALSE);

// Disable the "Reconnect Set point" entry box
  pW = GetDlgItem(IDC_CONFIG_MIN_VOLTS);
  pW->EnableWindow(FALSE);
                   
// Disable the "Enable charging" check box
  pW = GetDlgItem(IDC_CONFIG_ENABLE_CHARGE);
  pW->EnableWindow(FALSE);

// Disable the "Disable Use temperature Sensor" check box
  pW = GetDlgItem(IDC_CONFIG_USE_TEMP_SENSOR);
  pW->EnableWindow(FALSE);

// Disable the "Inhibit charging when temp is above" entry box
  pW = GetDlgItem(IDC_CONFIG_MAX_TEMP);
  pW->EnableWindow(FALSE);

// Disable the "Enable LVD" button
  pW = GetDlgItem(IDC_CONFIG_ENABLE_LVD);
  pW->EnableWindow(FALSE);

// Disable the LVD entry box
  pW = GetDlgItem(IDC_CONFIG_LVD);
  pW->EnableWindow(FALSE);

// Disable the LV reconnect entry box
  pW = GetDlgItem(IDC_CONFIG_LVD_RECON);
  pW->EnableWindow(FALSE);

// Disable the "Enable Load Control" button
  pW = GetDlgItem(IDC_ENABLE_LOAD_CTRL);
  pW->EnableWindow(FALSE);

// Disable the Light Level max off setting
  pW = GetDlgItem(IDC_CONFIG_LIGHT_OFF_LEVEL);
  pW->EnableWindow(FALSE);

// Disable the Light Level min on setting
  pW = GetDlgItem(IDC_CONFIG_LIGHT_ON_LEVEL);
  pW->EnableWindow(FALSE);

                  

  pW = GetDlgItem(IDC_CONFIG_ENABLE_OSD);
  pW->EnableWindow(FALSE);

  pW = GetDlgItem(IDC_CONFIG_OSD_TOP);
  pW->EnableWindow(FALSE);

  pW = GetDlgItem(IDC_CONFIG_OSD_BOTTOM);
  pW->EnableWindow(FALSE);

  pW = GetDlgItem(IDC_CONFIG_ENABLE_CALLSIGN);
  pW->EnableWindow(FALSE);

  pW = GetDlgItem(IDC_CONFIG_CALLSIGN);
  pW->EnableWindow(FALSE);
}

void CConfigPVCCDlg::EnableButtons()
{
// Enable the "Get Config Data" button
  CWnd* pW = GetDlgItem(IDC_GET_CONFIG);
  pW->EnableWindow(TRUE);

// Enable the "Send Config Data" button
  pW = GetDlgItem(IDC_SEND_CONFIG);
  pW->EnableWindow(TRUE);

// Enable the "Sample rate" entry box
  pW = GetDlgItem(IDC_CONFIG_UPDATE_PERIOD);
  pW->EnableWindow(TRUE);

// Enable the "Max Voltage Set point" entry box
  pW = GetDlgItem(IDC_CONFIG_MAX_VOLTS);
  pW->EnableWindow(TRUE);

// Enable the "Reconnect Set point" entry box
  pW = GetDlgItem(IDC_CONFIG_MIN_VOLTS);
  pW->EnableWindow(TRUE);

// Enable the "Enable charging" check box
  pW = GetDlgItem(IDC_CONFIG_ENABLE_CHARGE);
  pW->EnableWindow(TRUE);

// Enable the "Disable Ignore temperature at all times" check box
  pW = GetDlgItem(IDC_CONFIG_USE_TEMP_SENSOR);
  pW->EnableWindow(TRUE);

// Enable the "Inhibit charging when temp is above" entry box
  pW = GetDlgItem(IDC_CONFIG_MAX_TEMP);
  pW->EnableWindow(TRUE);

// Enable the "Enable LVD" button
  pW = GetDlgItem(IDC_CONFIG_ENABLE_LVD);
  pW->EnableWindow(TRUE);

// Enable the LVD entry box
  pW = GetDlgItem(IDC_CONFIG_LVD);
  pW->EnableWindow(TRUE);

// Enable the LV reconnect entry box
  pW = GetDlgItem(IDC_CONFIG_LVD_RECON);
  pW->EnableWindow(TRUE);

// Enable the "Enable Load Control" button
  pW = GetDlgItem(IDC_ENABLE_LOAD_CTRL);
  pW->EnableWindow(TRUE);

// Enable the Light Level max off setting
  pW = GetDlgItem(IDC_CONFIG_LIGHT_OFF_LEVEL);
  pW->EnableWindow(TRUE);

// Enable the Light Level min on setting
  pW = GetDlgItem(IDC_CONFIG_LIGHT_ON_LEVEL);
  pW->EnableWindow(TRUE);

                      
  
  pW = GetDlgItem(IDC_CONFIG_ENABLE_OSD);
  pW->EnableWindow(TRUE);

  OnConfigEnableOsd();
}

void CConfigPVCCDlg::OnCommResponseReceived(WPARAM w, LPARAM l)
{
  WORD temp;
  PVCC_CONFIG_DATA *pConfigData = (PVCC_CONFIG_DATA*)&CommResponseBuffer;
            
  switch(w)
  {
    case CMD_GET_CONFIG:

      UpdateData(TRUE);         // Read data from Dialog items, just to force initialization of CString items.

      // Get the data received from the remote unit out of the comm buffer and place it in dlg class variables.
      // Voltages need to be converted from BCD.
      m_ConfigVersion = pConfigData->ConfigVersion;

      m_ConfigUpdatePeriodSeconds = pConfigData->UpdatePeriod;

      temp = ShortSwap(pConfigData->MinChargeVolts); 
      m_ConfigMinVolts.Format("%d.%d", (temp & 0xFF00) >> 8, (temp & 0xFF) / 0x19);
      
			temp = ShortSwap(pConfigData->MaxChargeVolts); 
      m_ConfigMaxVolts.Format("%d.%d", (temp & 0xFF00) >> 8, (temp & 0xFF) / 0x19);

      temp = ShortSwap(pConfigData->DisconnectVolts); 
      m_ConfigLVD.Format("%d.%d", (temp & 0xFF00) >> 8, (temp & 0xFF) / 0x19);
      
			temp = ShortSwap(pConfigData->ReconnectVolts); 
      m_ConfigLVDReconnect.Format("%d.%d", (temp & 0xFF00) >> 8, (temp & 0xFF) / 0x19);


			temp = ShortSwap(pConfigData->MaxChargeTemp); 
      if(temp > 255)
      {
        temp = 255;
      }
      m_ConfigMaxTemp = (BYTE)temp;

      m_ConfigLightOffLevel = pConfigData->MaxOffLightLevel;
      m_ConfigLightOnLevel  = pConfigData->MinOnLightLevel;

			m_ConfigEnableCharge = pConfigData->EnableCharging;
			m_ConfigUseTempSensor = pConfigData->UseTempSensor;
      m_ConfigEnableLVD = pConfigData->EnableLVD;
      m_ConfigEnableLoadCtrl = pConfigData->EnableLoadControl;

      m_ConfigEnableOSD = pConfigData->EnableOSD;
      if(pConfigData->DisplayAtBottom)
      {
        m_ConfigOSDRadio = 1;
      }
      else
      {
        m_ConfigOSDRadio = 0;
      }

      m_ConfigEnableCallSign = pConfigData->EnableCallsign;
      m_ConfigCallSign = pConfigData->CallsignText;
      OSDUpdateButtonGrey();  // Update the OSD Display Setup panel gray status                          
    break;

  }    
  UpdateData(FALSE);  //Send new data to dialog
  EnableButtons();
}
//**************************************************************************************************************
// This function processes the message: COMM_RESPONSE_FAILED typically sent from the communications thread
// when the message transaction fails. This is done via the following function:
// PostMessage(hConfigPVCCDlg, COMM_RESPONSE_FAILED, (WPARAM)ComPort, LastCommError);
// ComPort was the com port that was selected by the user. 0 = no selection.
// LastCommError is the cause of the failure.. see ConfigPVCC_comm.h
//

void CConfigPVCCDlg::OnResponseFailed(WPARAM w, LPARAM l)
{
  
  switch(l)
  {
    case COMM_RECEIVED_NO_VALID_RESPONSE:
      MessageBox(COMM_RECEIVED_NO_VALID_RESPONSE_TEXT, COMM_LOCAL_TITLE, MB_ICONERROR | MB_OK);
    break;

    case COMM_PVCC_REPORTED_BAD_CRC:
      MessageBox(COMM_PVCC_REPORTED_BAD_CRC_TEXT, COMM_PVCC_TITLE, MB_ICONERROR | MB_OK);
    break;

    case COMM_INVALID_COM_PORT:
      MessageBox(COMM_INVALID_COM_PORT_TEXT, COMM_LOCAL_TITLE, MB_ICONERROR | MB_OK);
    break;

    case COMM_OPEN_FAILED:
      MessageBox(COMM_INVALID_COM_PORT_TEXT, COMM_LOCAL_TITLE, MB_ICONERROR | MB_OK);
    break;

    case COMM_CONFIG_FAILED:
      MessageBox(COMM_CONFIG_FAILED_TEXT, COMM_LOCAL_TITLE, MB_ICONERROR | MB_OK);
    break;

    case COMM_WRITE_FAILED:
      MessageBox(COMM_WRITE_FAILED_TEXT, COMM_LOCAL_TITLE, MB_ICONERROR | MB_OK);
    break;

    case COMM_SET_TIMEOUT_FAILED:
      MessageBox(COMM_SET_TIMEOUT_FAILED_TEXT, COMM_LOCAL_TITLE, MB_ICONERROR | MB_OK);
    break;

    default:
      MessageBox(COMM_UNKNOWN_ERROR_TEXT, "Unknown Error!", MB_ICONERROR | MB_OK);
  }
	
//  UpdateData(FALSE);  //Send new data to dialog
  EnableButtons();
}


WORD CConfigPVCCDlg::ShortSwap(WORD x)
{
  return ((x<<8) + (x>>8));
}


void CConfigPVCCDlg::OnOK()
{
  // Override OnOK() so that pressing Enter doesn't close the dialog box
}


void CConfigPVCCDlg::OnCancel()
{
  // Override OnCancel() so that pressing ESC doesn't close the dialog box
}

void CConfigPVCCDlg::OnClose() 
{
  SetEvent(hCommEndThreadEvent);             // Signal Comm thread to die
	CDialog::OnOK();
}

void CConfigPVCCDlg::OnAbout() 
{

	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

void CConfigPVCCDlg::OnFileExit() 
{
  SetEvent(hCommEndThreadEvent);             // Signal Comm thread to die
  CDialog::OnOK();
}


void CConfigPVCCDlg::OnFileSerialport() 
{
	// TODO: Add your command handler code here
  CSelectCommDlg dlgSelectBox;
  dlgSelectBox.m_Com1Radio = m_ConfigComPort;
  if(dlgSelectBox.DoModal() == IDOK)
  {
    m_ConfigComPort = dlgSelectBox.m_Com1Radio;
  }
}


void CConfigPVCCDlg::OnConfigEnableOsd() 
{
	// TODO: Add your control notification handler code here

  UpdateData(TRUE);         // Read data from Dialog items.
  OSDUpdateButtonGrey();
}



void CConfigPVCCDlg::OnConfigEnableCallsign() 
{
  UpdateData(TRUE);         // Read data from Dialog items.
  CWnd* pW;

  if(!m_ConfigEnableCallSign)
  {
    pW = GetDlgItem(IDC_CONFIG_CALLSIGN);
    pW->EnableWindow(FALSE);
  }
  else
  {
    pW = GetDlgItem(IDC_CONFIG_CALLSIGN);
    pW->EnableWindow(TRUE);
  }
}

void CConfigPVCCDlg::OSDUpdateButtonGrey()
{
  CWnd* pW;

  if(!m_ConfigEnableOSD)
  {
    pW = GetDlgItem(IDC_CONFIG_OSD_TOP);
    pW->EnableWindow(FALSE);

    pW = GetDlgItem(IDC_CONFIG_OSD_BOTTOM);
    pW->EnableWindow(FALSE);

    pW = GetDlgItem(IDC_CONFIG_ENABLE_CALLSIGN);
    pW->EnableWindow(FALSE);

    pW = GetDlgItem(IDC_CONFIG_CALLSIGN);
    pW->EnableWindow(FALSE);
  }
  else
  {
    pW = GetDlgItem(IDC_CONFIG_OSD_TOP);
    pW->EnableWindow(TRUE);

    pW = GetDlgItem(IDC_CONFIG_OSD_BOTTOM);
    pW->EnableWindow(TRUE);

    pW = GetDlgItem(IDC_CONFIG_ENABLE_CALLSIGN);
    pW->EnableWindow(TRUE);

    if(m_ConfigEnableCallSign)
    {
      pW = GetDlgItem(IDC_CONFIG_CALLSIGN);
      pW->EnableWindow(TRUE);
    }
  }



}

void CConfigPVCCDlg::OnConfigEnableCharge() 
{
  UpdateData(TRUE);         // Read data from Dialog items.
  CWnd* pW1;
  CWnd* pW2;
  CWnd* pW3;
  CWnd* pW4;
  CWnd* pW5;

  pW1 = GetDlgItem(IDC_CONFIG_UPDATE_PERIOD);
  pW2 = GetDlgItem(IDC_CONFIG_MAX_VOLTS);
  pW3 = GetDlgItem(IDC_CONFIG_MIN_VOLTS);
  pW4 = GetDlgItem(IDC_CONFIG_USE_TEMP_SENSOR);
  pW5 = GetDlgItem(IDC_CONFIG_MAX_TEMP);

  if(!m_ConfigEnableCharge)
  {
    pW1->EnableWindow(FALSE);
    pW2->EnableWindow(FALSE);
    pW3->EnableWindow(FALSE);
    pW4->EnableWindow(FALSE);
    pW5->EnableWindow(FALSE);
  }
  else
  {
    pW1->EnableWindow(TRUE);
    pW2->EnableWindow(TRUE);
    pW3->EnableWindow(TRUE);
    pW4->EnableWindow(TRUE);
    if(!m_ConfigUseTempSensor)
    {
      pW5->EnableWindow(FALSE);
    }
    else
    {
      pW5->EnableWindow(TRUE);
    }
  }
	
}

void CConfigPVCCDlg::OnConfigUseTempSensor() 
{
	// TODO: Add your control notification handler code here
  UpdateData(TRUE);         // Read data from Dialog items.
  CWnd* pW1;

  pW1 = GetDlgItem(IDC_CONFIG_MAX_TEMP);

  if(!m_ConfigUseTempSensor)
  {
    pW1->EnableWindow(FALSE);
  }
  else
  {
    pW1->EnableWindow(TRUE);
  }
	
	
}

void CConfigPVCCDlg::OnEnableLvd() 
{
	// TODO: Add your control notification handler code here
  UpdateData(TRUE);         // Read data from Dialog items.
  CWnd* pW1;
  CWnd* pW2;

  pW1 = GetDlgItem(IDC_CONFIG_LVD);
  pW2 = GetDlgItem(IDC_CONFIG_LVD_RECON);

  if(!m_ConfigEnableLVD)
  {
    pW1->EnableWindow(FALSE);
    pW2->EnableWindow(FALSE);
  }
  else
  {
    pW1->EnableWindow(TRUE);
    pW2->EnableWindow(TRUE);
  }
	
	
}

void CConfigPVCCDlg::OnEnableLoadCtrl() 
{
  UpdateData(TRUE);         // Read data from Dialog items.
  CWnd* pW1;
  CWnd* pW2;

  pW1 = GetDlgItem(IDC_CONFIG_LIGHT_OFF_LEVEL);
  pW2 = GetDlgItem(IDC_CONFIG_LIGHT_ON_LEVEL);

  if(!m_ConfigEnableLoadCtrl)
  {
    pW1->EnableWindow(FALSE);
    pW2->EnableWindow(FALSE);
  }
  else
  {
    pW1->EnableWindow(TRUE);
    pW2->EnableWindow(TRUE);
  }
	
	
	
}
