/*

Caveats:

	o This code sort of assumes 32 bit ints in a couple places, like when 
		dealing with 24-bit integers.
		

	o printf("%.2x", 3) should print "03"
	
	o the help info has little correlation to actual usage (:-)
		-o and -f should work, the rest are up in the air.


Bugs:


	brl wrong? - nope, coff is wrong!
	
	mvp/mvn - wrong order for args???? ( don't switch? )

	brl xxx	
	lda <$0d
	asl a  (hex = $0a)
	ldx #1234
	is disassembled as lda <$0a/ ldx #1234
	
	<- this is a problem w/ Windows95/CW.  gcc & linux work fine.
	
	change xce?
	
To Do:
	o GNO user tool set
	o Names for more memory addresses
	o add OMF support

 */

#include "comp.h"

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <unistd.h>
 #ifndef NO_STAT
 #include <sys/stat.h>
 #endif
#include <stdarg.h>
#include <string.h>
#include <errno.h>


union l_b
{
     unsigned long l;
     unsigned char b[4];
};

union w_b
{
  unsigned int w;
  unsigned short s[2];
  unsigned char b[4];
};


/* macros for byte-order independence */

#if BYTE_ORDER == 0
#error -> BYTE_ORDER is undefined!
#endif

#if BYTE_ORDER == LITTLE_ENDIAN
#define b0(x) x.b[0]
#define b1(x) x.b[1]
#define b2(x) x.b[2]
#define s0(x) x.s[0]
#define s1(x) x.s[1]
#elif BYTE_ORDER == BIG_ENDIAN
#define b0(x) x.b[3]
#define b1(x) x.b[2]
#define b2(x) x.b[1]
#define s0(x) x.s[1]
#define s1(x) x.s[0]
#else 
#error: Error -> unknown byte order!
#endif


void dump1(long, int);
void dump2(long, int, int);
void dump3(long, int, int, int);
void help(void);

const char *tool_call(int call, int set);
const char *user_tool_call(int call, int set);
const char *gsos_call (int level, int call);
const char *p8_call (int num);
void angie0 (int opcode, long PC);
void angie1 (int opcode, union w_b arg, long PC);
void angie2 (int opcode, union w_b arg, long PC);
void angie3 (int opcode, union w_b arg, long PC);
char *describe(union w_b arg);


int extract (const char *);
void dis816 (unsigned char *, long, long);



static int m;
static int e;
static int x;
static int Tools;
static int GSOS;
static int PRODOS;
static int Merlin;

int  main (int argc, char **argv)
{
	char * mem;
	int org = 0;
	int k;
	int offset = 0;
	char *filename;
	long dlength = 0;
	
	
#ifdef NO_STAT
     FILE *tmp;
#else
     struct stat st;
#endif
	int fd;
	long length; 
	int i;


	m = 0;
	x = 0;
	e = 0;
	Tools = 1;
	GSOS = 1;
	PRODOS = 1;
	Merlin = 0;

	for (i= 1; i <argc; i++)
	{
	     if (*argv[i] == '-')
		  switch (argv[i][1])
		  {
		       
		  case 'T': /* enable/disable Tool call interception */
		       if (argv[i][2] == '0') Tools = 0;
		       else if (argv[i][2] == '1') Tools = 1;
		       else if ( (argv[i][2] = (char)0) && (i <argc)) /* -T n format */
			    Tools = (argv[++i][0] != 0);
		       break;
		       
		  case 'G':	/* enable/disable GSOS call recognition */
		       if (argv[i][2] == '0') GSOS = 0;
                       else if (argv[i][2] == '1') GSOS = 1;
                       else if ( (argv[i][2] = (char)0) && (i <argc)) /* -G n format */
                            GSOS = (argv[++i][0] != 0);
                       break;
		       

                  case 'P':     /* enable/disable P8 call recognition */
                       if (argv[i][2] == '0') PRODOS = 0;
                       else if (argv[i][2] == '1') PRODOS = 1;
                       else if ( (argv[i][2] = (char)0) && (i <argc)) /* -P n format */
                            PRODOS = (argv[++i][0] != 0);
                       break;

		  case 'M':
                       if (argv[i][2] == '0') Merlin = 0;
                       else if (argv[i][2] == '1') Merlin = 1;
                       else if ( (argv[i][2] = (char)0) && (i <argc)) 

                            Merlin = (argv[++i][0] != 0);
                       break;		   
    
		  case 'o':		/* set the origin */
		       if (i < argc)
			    org = extract (argv[++i]);
		       else
		       {
			    help();
			    exit(1);
		       }
		       break;
		       
		  case 'f':
		       if (i < argc)
			    offset = extract (argv[++i]);
		       else
		       {
			    help();
			    exit(1);
		       }
		       break;
		       
		  case 'l': /* Only disassemble for xx bytes */
		       if (i < argc)
			    dlength = extract (argv[++i]);
		       else
		       {
			    help();
			    exit(1);
		       }
		       break;
		       
		  case 'x':
		  case 'X':
		       x=1;
		       break;
		       
		  case 'e':
		  case 'E':
		       e=1;
		       break;
		       
		  case 'm':
		       m=1;
		       break;
		  }
	     else break;
	}
	
	
	if (i >= argc)
	{
		help();
		exit(1);
	}

#ifdef NO_STAT
     tmp = fopen (argv[i], "r");
     fseek(tmp, 0, SEEK_END);
     length =  ftell (tmp);
     fclose (tmp);
#endif

	fd = open (argv[i], O_RDONLY);
	if (fd == -1)
	{
		fprintf(stderr, "Could not open file %s\n", argv[i]);
		exit(1);
	}

#ifndef NO_STAT
	fstat (fd, &st);
	length = st.st_size;
#endif

	if (length == 0)
	{
		fprintf(stderr, "Warning - file %s is empty\n", argv[i]);	
		exit(1);	
	}

	if ((dlength) && (dlength > length))
	{
	     fprintf(stderr, "Warning - specified disassembly length greater than file length\n");
	     exit(1);
	}

	if (length < offset)
	{
		fprintf(stderr, "Warning - offset too great\n");
		exit(1);
	}

	if (offset)
	{	
		lseek (fd, offset, SEEK_SET);
		length -= offset;
	}
	
	if ((dlength) && (dlength > length))
	{
	     fprintf(stderr, "Warning - length + offset > file length\n");
	     exit (1);
	}

	if (dlength) length = dlength;

	mem = (char *) malloc (length);
	if (read (fd, mem, length) != length)
	{
		fprintf(stderr, "An error occurred while reading the file %s\n", argv[i]);
		free (mem);
		close (fd);
		exit(1);

	
	}
	close (fd);
     

	dis816 ((unsigned char *)mem, org, length);

     free (mem);
     return 0;
}


#define	SEC 0x38
#define	CLC 0x18



void dis816 (unsigned char * start, long start_PC, long length)
{
     long i = 0;
     long PC;

     union w_b arg;	
	

     int opcode = 0xea;
     int old_op;
     const char *cp;	/* name of the opcode */


     if ( length == 0 ) return;

     PC = start_PC;
     i = 0;
	
     while (i < length)
     {     
	  PC = start_PC + i;
	  old_op = opcode;
	  arg.w = 0;		/* clear extraneous bits */
	  opcode = start[i++];	/* get the instruction */
	  switch (opcode)		/* fetch any needed data... */
	  {

	       /* 
		* these take no arguments 
		*/
	  case 0xea:
	  case 0x0a:
	  case 0x18:
	  case 0xd8:
	  case 0x58:
	  case 0xb8:
	  case 0x3a:
	  case 0xca:
	  case 0x88:
	  case 0x1a:
	  case 0xe8:
	  case 0xc8:
	  case 0x4a:
	  case 0x48:
	  case 0x8b:
	  case 0x0b:
	  case 0x4b:
	  case 0x08:
	  case 0xda:
	  case 0x5a:
	  case 0x6a:
	  case 0x68:
	  case 0xab:
	  case 0x2b:
	  case 0x28:
	  case 0xfa:
	  case 0x7a:
	  case 0x2a:
	  case 0x40:
	  case 0x6b:
	  case 0x60:
	  case 0x38:
	  case 0xf8:
	  case 0x78:
	  case 0xdb:
	  case 0xaa:
	  case 0xa8:
	  case 0x5b:
	  case 0x1b:
	  case 0x7b:
	  case 0x3b:
	  case 0xba:
	  case 0x8a:
	  case 0x9a:
	  case 0x9b:
	  case 0x98:
	  case 0xbb:
	  case 0xcb:
	  case 0xeb:
	  case 0xfb:
	       break;
	       /* 
		* these take 1 byte 
		*/

	  case 0xa5:
	  case 0x02:
	  case 0x65:
	  case 0x66:
	  case 0x76:
	  case 0x67:
	  case 0x72:
	  case 0x75:
	  case 0x61:
	  case 0x71:
	  case 0x77:
	  case 0x63:
	  case 0x73:
	  case 0x25:
	  case 0x32:
	  case 0x27:
	  case 0x35:
	  case 0x21:
	  case 0x31:
	  case 0x37:
	  case 0x23:
	  case 0x33:
	  case 0x06:
	  case 0x16:
	  case 0x90:
	  case 0xb0:
	  case 0xf0:
	  case 0x24:
	  case 0x34:
	  case 0x30:
	  case 0xd0:
	  case 0x10:
	  case 0x80:
	  case 0x50:
	  case 0x70:
	  case 0xc5:
	  case 0xd2:
	  case 0xc7:
	  case 0xd5:
	  case 0xc1:
	  case 0xd1:
	  case 0xd7:
	  case 0xc3:
	  case 0xd3:
	  case 0xe4:
	  case 0xc4:
	  case 0xc6:
	  case 0xd6:
	  case 0x45:
	  case 0x52:
	  case 0x47:
	  case 0x55:
	  case 0x41:
	  case 0x51:
	  case 0x57:
	  case 0x43:
	  case 0x53:
	  case 0xe6:
	  case 0xf6:
	  case 0xdc:

	  case 0xb2:
	  case 0xa7:
	  case 0xb5:
	  case 0xa1:
	  case 0xb1:
	  case 0xb7:
	  case 0xa3:
	  case 0xb3:
	  case 0xa6:
	  case 0xb6:
	  case 0xa4:
	  case 0xb4:
	  case 0x46:
	  case 0x56:
	  case 0x05:
	  case 0x12:
	  case 0x07:
	  case 0x15:
	  case 0x01:
	  case 0x11:
	  case 0x17:
	  case 0x03:
	  case 0x13:
	  case 0xd4:
	  case 0xc2:
	  case 0x26:
	  case 0x36:
	  case 0xe5:
	  case 0xf2:
	  case 0xe7:
	  case 0xf5:
	  case 0xe1:
	  case 0xf1:
	  case 0xf7:
	  case 0xe3:
	  case 0xf3:
	  case 0xe2:
	  case 0x85:
	  case 0x92:
	  case 0x87:
	  case 0x95:
	  case 0x81:
	  case 0x91:
	  case 0x97:
	  case 0x83:
	  case 0x93:
	  case 0x86:
	  case 0x96:
	  case 0x84:
	  case 0x94:
	  case 0x64:
	  case 0x74:
	  case 0x14:
	  case 0x04:
	  case 0x42: /* wdm */
	  {
	  get_byte: /* entry point */
	       if ( i < length)
		    arg.w = start[i++];
	       else
	       {
		    dump1(PC, opcode);
		    return;
	       }
	       break;
	  }			
			
				
	  /* 
	   * this depends on the e bit 
	   */
	  case 0x00:
	       if (e) break;
	       else goto get_byte;  				

	       /* 
		* these depend on the state of e or m 
		*/
                	
	  case 0x69:
	  case 0x29:
	  case 0x89:
	  case 0xc9:
	  case 0x49:
	  case 0xa9:
	  case 0x09:
	  case 0xe9:
	       if (e || m) goto get_byte;
	       else goto get_word;

	       /* 
		* these depend on the size of x 
		*/

	  case 0xe0:
	  case 0xc0:
	  case 0xa2:
	  case 0xa0:
	       if (e || x) goto get_byte;
	       else goto get_word;
				
			
	       /* 
		* these take a 16-bit argument 
		*/
 
	  case 0x6d:
	  case 0x7d:
	  case 0x79:
	  case 0x2d:
	  case 0x3d:
	  case 0x39:
	  case 0x0e:
	  case 0x1e:
	  case 0x2c:
	  case 0x3c:
	  case 0x82:
	  case 0xcd:
	  case 0xdd:
	  case 0xd9:
	  case 0xec:
	  case 0xcc:
	  case 0xce:
	  case 0xde:
	  case 0x4d:
	  case 0x5d:
	  case 0x59:
	  case 0xee:
	  case 0xfe:
	  case 0x4c:
	  case 0x6c:
	  case 0x7c:
	  case 0x20:
	  case 0xfc:
	  case 0xad:
	  case 0xbd:
	  case 0xb9:
	  case 0xae:
	  case 0xbe:
	  case 0xac:
	  case 0xbc:
	  case 0x4e:
	  case 0x5e:
	  case 0x44:
	  case 0x54:
	  case 0x0d:
	  case 0x1d:
	  case 0x19:
	  case 0xf4:
	  case 0x62:
	  case 0x2e:
	  case 0x3e:
	  case 0xed:
	  case 0xfd:
	  case 0xf9:
	  case 0x8d:
	  case 0x9d:
	  case 0x99:
	  case 0x8e:
	  case 0x8c:
	  case 0x9c:
	  case 0x9e:
	  case 0x1c:
	  case 0x0c:
	  case 0x6e:
	  case 0x7e:
	  {
	  get_word: /* entry */
	       if (i + 1 < length)
	       {

		    b0(arg) = start[i++];
		    b1(arg) = start[i++];
	       }
	       else if ( i <length)
	       {
		    dump2 (PC, opcode, start[i++]);
		    return;
	       }	
	       else 
	       {
		    dump1 (PC, opcode);
		    return;
	       }
	  }
	  break;
                   
	  /* 
	   * these take a 24-bit argument 
	   */

	  case 0x6f:
	  case 0x7f:
	  case 0x2f:
	  case 0x3f:
	  case 0xcf:
	  case 0xdf:
	  case 0x4f:
	  case 0x5f:
	  case 0x22:
	  case 0x5c:
	  case 0xaf:
	  case 0xbf:
	  case 0x0f:
	  case 0x1f:
	  case 0xef:
	  case 0xff:		
	  case 0x8f:
	  case 0x9f:
		
	       if (i+2<length)
	       {	       
		    b0(arg) = start[i++];
		    b1(arg) = start[i++];
		    b2(arg) = start[i++];

	       }
	       else if (i + 1 < length)
	       {
		    dump3 (PC, opcode, start[i++], start[i++]);
		    return;
	       }
	       else if (i < length)
	       {
		    dump2 (PC, opcode, start[i++]);
		    return;
	       }
	       else
	       {
		    dump1 (PC, opcode);
		    return;
	       }
	       break;
/* this can never happen, though, cause all possibilities are used */		
	  default: fprintf (stderr, "Unrecognized opcode %x\n",opcode);
	  }
		
	  /* now _display the code... */
		
	switch (opcode)
	{
		case 0x00:	/* brk */
			cp = "brk";
			if (e)
				goto print_0_byte;
			{
				print_1_byte:	/* entry */
					
				printf ("\t%s $%.2x\t\t\t; ", cp, arg.w);
				angie1 (opcode, arg, PC);
			}
			break;

	case 0x65: cp = "adc"; goto print_1_byte;
	  case 0x25: cp = "and"; goto print_1_byte;
	  case 0x06: cp = "asl"; goto print_1_byte;
	  case 0x24: cp = "bit"; goto print_1_byte;
	  case 0x02: cp = "cop"; goto print_1_byte;
	  case 0xc5: cp = "cmp"; goto print_1_byte;
	  case 0xe4: cp = "cpx"; goto print_1_byte;
	  case 0xc4: cp = "cpy"; goto print_1_byte;
	  case 0xc6: cp = "dec"; goto print_1_byte;
	  case 0x45: cp = "eor"; goto print_1_byte;
	  case 0xa5: cp = "lda"; goto print_1_byte;
	  case 0xa6: cp = "ldx"; goto print_1_byte;
	  case 0xa4: cp = "ldy"; goto print_1_byte;
	  case 0x46: cp = "lsr"; goto print_1_byte;
	  case 0xe6: cp = "inc"; goto print_1_byte;
	  case 0x05: cp = "ora"; goto print_1_byte;
	  case 0x26: cp = "rol"; goto print_1_byte;
	  case 0x66: cp = "ror"; goto print_1_byte;
	  case 0xe5: cp = "sbc"; goto print_1_byte;

	  case 0x85: cp = "sta"; goto print_1_byte;
	  case 0x86: cp = "stx"; goto print_1_byte;
	  case 0x84: cp = "sty"; goto print_1_byte;
	  case 0x64: cp = "stz"; goto print_1_byte;
	  case 0x14: cp = "trb"; goto print_1_byte;
	  case 0x04: cp = "tsb"; goto print_1_byte;
	  case 0x42: cp = "wdm"; goto print_1_byte;

	  case 0x6d: cp = "adc"; goto print_2_byte;
	  case 0x2d: cp = "and"; goto print_2_byte;
	  case 0x0e: cp = "asl"; goto print_2_byte;
	  case 0x2c: cp = "bit"; goto print_2_byte;
	  case 0xcd: cp = "cmp"; goto print_2_byte;
	  case 0xec: cp = "cpx"; goto print_2_byte;
	  case 0xcc: cp = "cpy"; goto print_2_byte;
	  case 0xce: cp = "dec"; goto print_2_byte;
	  case 0x4d: cp = "eor"; goto print_2_byte;
	  case 0xee: cp = "inc"; goto print_2_byte;
	  case 0x4c: cp = "jmp"; goto print_2_byte;
	case 0x20:
		cp = NULL;
		/* check if it's a prodos 8 call? */
		if (PRODOS && e && arg.w == 0xbf00 && i + 2 <= length)	
			cp = p8_call (start[i]);		

		if (cp && strlen (cp))
		{
			b0 (arg) = start[i+1];
			b1 (arg) = start[i+2];
			printf("\t%s $%.4x\t;\t\t\t%x\n", cp, arg, PC);
			i += 3;		
		} 

		else { cp = "jsr"; goto print_2_byte;}
		break;
		
	  case 0xad: cp = "lda"; goto print_2_byte_abs;
	  case 0xae: cp = "ldx"; goto print_2_byte_abs;
		case 0xac:
			cp = "ldy";
			{
				print_2_byte_abs:	/* Entry point */
				
				if (b1 (arg))
					printf ("\t%s $%.4x\t\t; ", cp, arg);				
				else
					printf ("\t%s |$%.4x\t\t; ", cp, arg);
	
				angie2 (opcode, arg, PC);				
			}
			break;
			

	case 0x4e: cp = "lsr"; goto print_2_byte_abs;
	  case 0x0d: cp = "ora"; goto print_2_byte_abs;
	  case 0xf4: cp = "pea"; goto print_2_byte;
	  case 0x62: cp = "per"; goto print_2_byte; /* other code? */
	  case 0x2e: cp = "rol"; goto print_2_byte_abs;
	  case 0x6e: cp = "ror"; goto print_2_byte_abs;
	  case 0xed: cp = "sbc"; goto print_2_byte_abs;
	  case 0x8d: cp = "sta"; goto print_2_byte_abs;
	  case 0x8e: cp = "stx"; goto print_2_byte_abs;
	  case 0x8c: cp = "sty"; goto print_2_byte_abs;			
	  case 0x9c: cp = "stz"; goto print_2_byte_abs;
	  case 0x1c: cp = "trb"; goto print_2_byte_abs;
	  case 0x54: cp = "mvn"; goto print_2_byte;
	  case 0x44: cp = "mvp"; goto print_2_byte;

		case 0x0c:
			cp = "tsb";
			{
				print_2_byte:	/* Entry point */
				
				printf ("\t%s $%.4x\t\t; ", cp, arg);				
				angie2 (opcode, arg, PC);				
			}
			break;
	  

	
	case 0xc2:	/* rep */
		if ( arg.w & 0x20)
		{
			m = 0;
			printf("\tlonga on\n");
		}
				
		if ( arg.w & 0x10 )
		{
			x = 0;
			printf("\tlongi on\n");
		}
		cp = "rep";
				
		{
			print_1_byte_imm:	/* entry */
					
			printf ("\t%s #$%.2x\t\t; ", cp, arg);
			angie1 (opcode, arg, PC);
		}
		break;
					

				
	  case 0xe2:	/* sep */
	       if (arg.w & 0x20)
	       {
		    m++;
		    printf ("\tlonga off\n");
	       }
				
	       if (arg.w & 0x10)
	       {
		    x++;
		    printf ("\tlongi off\n");
	       }
	       cp = "sep";
	       goto print_1_byte_imm;
			
	       /* 
		* these take no arguments 
		*/
			 	
	  case 0xea:
	       cp = "nop";
	       {
	       print_0_byte: /* entry */
		    printf("\t%s\t\t\t; ",cp);
			angie0 (opcode, PC);
	       }
	       break;
					
			
	  case 0x0a: cp = "asl"; goto print_0_byte;
	  case 0x18: cp = "clc"; goto print_0_byte;
	  case 0xd8: cp = "cld"; goto print_0_byte;
	  case 0x58: cp = "cli"; goto print_0_byte;
	  case 0xb8: cp = "cld"; goto print_0_byte;
	  case 0x3a: cp = "dec"; goto print_0_byte;
	  case 0xca: cp = "dex"; goto print_0_byte;
	  case 0x88: cp = "dey"; goto print_0_byte;
	  case 0x1a: cp = "inc"; goto print_0_byte;
	  case 0xe8: cp = "inx"; goto print_0_byte;
	  case 0xc8: cp = "iny"; goto print_0_byte;
	  case 0x4a: cp = "lsr"; goto print_0_byte;
	  case 0x48: cp = "pha"; goto print_0_byte;
	  case 0x8b: cp = "phb"; goto print_0_byte;
	  case 0x0b: cp = "phd"; goto print_0_byte;
	  case 0x4b: cp = "phk"; goto print_0_byte;
	  case 0x08: cp = "php"; goto print_0_byte;
	  case 0xda: cp = "phx"; goto print_0_byte;
	  case 0x5a: cp = "phy"; goto print_0_byte;
	  case 0x6a: cp = "ror"; goto print_0_byte;
	  case 0x68: cp = "pla"; goto print_0_byte;
	  case 0xab: cp = "plb"; goto print_0_byte;
	  case 0x2b: cp = "pld"; goto print_0_byte;
	  case 0x28: cp = "plp"; goto print_0_byte;
	  case 0xfa: cp = "plx"; goto print_0_byte;
	  case 0x7a: cp = "ply"; goto print_0_byte;
	  case 0x2a: cp = "rol"; goto print_0_byte;
	  case 0x40: cp = "rti"; goto print_0_byte;
	  case 0x6b: cp = "rtl"; goto print_0_byte;
	  case 0x60: cp = "rts"; goto print_0_byte;
	  case 0x38: cp = "sec"; goto print_0_byte;
	  case 0xf8: cp = "sed"; goto print_0_byte;
	  case 0x78: cp = "sei"; goto print_0_byte;
	  case 0xdb: cp = "stp"; goto print_0_byte;
	  case 0xaa: cp = "tax"; goto print_0_byte;
	  case 0xa8: cp = "tay"; goto print_0_byte;
	  case 0x5b: cp = "tcd"; goto print_0_byte;
	  case 0x1b: cp = "tcs"; goto print_0_byte;
	  case 0x7b: cp = "tdc"; goto print_0_byte;
	  case 0x3b: cp = "tsc"; goto print_0_byte;
	  case 0xba: cp = "tsx"; goto print_0_byte;
	  case 0x8a: cp = "txa"; goto print_0_byte;
	  case 0x9a: cp = "txs"; goto print_0_byte;
	  case 0x9b: cp = "txy"; goto print_0_byte;
	  case 0x98: cp = "tya"; goto print_0_byte;
	  case 0xbb: cp = "tyx"; goto print_0_byte;
	  case 0xcb: cp = "wai"; goto print_0_byte;
	  case 0xeb: cp = "xba"; goto print_0_byte;
	  case 0xfb: 
	       if (old_op == SEC)
	       {
	       		e++;
	       		printf("\tlonga off\n");
	       		printf("\tlongi off\n");
	       	}
	       else if (old_op == CLC)
	       {
	       		e = 0;
	       		if (m)
	       			printf("\tlonga off\n");
	       		else
	       			printf("\tlonga on");
	       		
	       		if (x)
	       			printf("\tlongi off\n");
	       		else
	       			printf("\tlongi on\n");
	       	}
	    
	       cp = "xce"; 
	       goto print_0_byte;
					
		
		
	       /* 
		* these take a 24-bit argument 
		*/

	  case 0x6f: cp = "adc"; goto print_3_byte;
	  case 0x7f: cp = "adc"; goto print_3_byte_x;
	  case 0x2f: cp = "and"; goto print_3_byte;
	  case 0x3f: cp = "and"; goto print_3_byte_x;
	  case 0xcf: cp = "cmp"; goto print_3_byte;
	  case 0xdf: cp = "cmp"; goto print_3_byte_x;
	  case 0x4f: cp = "eor"; goto print_3_byte;
	  case 0x5f: cp = "eor"; goto print_3_byte_x;
		case 0x22: 
			cp = NULL;
/* check if it's a GSOS inline call */

			if (GSOS 
			  && arg.w == 0xe100a8 
			  && i + 5 <= length)
				cp = gsos_call (start[i+1], start[i]);
		
			if (cp && strlen (cp))	  
			{
				b0 (arg) = start[i + 3];
				b1 (arg) = start[i + 4];
				b2 (arg) = start[i + 5];
				printf ("\t%s $%.6x\t;\t\t\t%x\n", cp, arg, PC);
				i += 6;
			}
			else { cp = "jsl"; goto print_3_byte2; }
			break;
		
		case 0x5c:
			cp = "jml"; 
			{
				char *add;
				
				print_3_byte2:

				
				add = describe(arg);
				
				if (add)
					printf ("\t%s >%s\t; ", cp, add);
				else
					printf("\t%s $%.6x\t\t; ", cp, arg.w);
				
				angie3 (opcode, arg, PC);
			}
			break;
			
		case 0xaf: cp = "lda"; goto print_3_byte;
		case 0xbf: cp = "lda"; goto print_3_byte_x;
		case 0x0f: cp = "ora"; goto print_3_byte;
		case 0x1f: cp = "ora"; goto print_3_byte_x;
		case 0xef: cp = "sbc"; goto print_3_byte;
		case 0xff: cp = "sbc"; goto print_3_byte_x;		
		case 0x8f: 
			cp = "sta"; 
			{
				print_3_byte:	/* entry */

				if (b2(arg))
					printf("\t%s $%.6x\t\t; ", cp, arg.w);
				else
					printf("\t%s >$%.6x\t\t; ", cp, arg.w);
					
				angie3 (opcode, arg, PC);
			}
			break;
				
		case 0x9f: 
			cp = "sta";
			{
				print_3_byte_x:	/* entry */

				if (b2(arg))
					printf("\t%s $%.6x,x\t\t; ", cp, arg.w);
				else
					printf("\t%s >$%.6x,x\t\t; ", cp, arg.w);
					
				angie3 (opcode, arg, PC);
			}
			break;
				
	  case 0x7d: cp = "adc"; goto print_2_byte_x;
	  case 0x3d: cp = "and"; goto print_2_byte_x;
	  case 0x1e: cp = "asl"; goto print_2_byte_x;
	  case 0x3c: cp = "bit"; goto print_2_byte_x;
	  case 0xdd: cp = "cmp"; goto print_2_byte_x;
	  case 0xde: cp = "dec"; goto print_2_byte_x;
	  case 0x5d: cp = "eor"; goto print_2_byte_x;
	  case 0xfe: cp = "inc"; goto print_2_byte_x;
	  case 0xbd: cp = "lda"; goto print_2_byte_x;
	  case 0xbc: cp = "ldy"; goto print_2_byte_x;
	  case 0x5e: cp = "lsr"; goto print_2_byte_x;
	  case 0x1d: cp = "ora"; goto print_2_byte_x;
	  case 0x3e: cp = "rol"; goto print_2_byte_x;
	  case 0x7e: cp = "ror"; goto print_2_byte_x;
	  case 0xfd: cp = "sbc"; goto print_2_byte_x;
	  case 0x9d: cp = "sta"; goto print_2_byte_x;
	case 0x9e:
		cp = "stz";
		{
			print_2_byte_x:	/* entry */
			
			if (b1(arg))			
				printf ("\t%s $%.4x,x\t\t; ", cp, arg);
			else
				printf ("\t%s |$%.4x,x\t\t; ", cp, arg);

			angie2 (opcode, arg, PC);
		}
		break;
			
	  case 0x79: cp = "adc"; goto print_2_byte_y;
	  case 0x39: cp = "and"; goto print_2_byte_y;
	  case 0xd9: cp = "cmp"; goto print_2_byte_y;
	  case 0x59: cp = "eor"; goto print_2_byte_y;
	  case 0xb9: cp = "lda"; goto print_2_byte_y;
	  case 0xbe: cp = "ldx"; goto print_2_byte_y;
	  case 0x19: cp = "ora"; goto print_2_byte_y;
	  case 0xf9: cp = "sbc"; goto print_2_byte_y;
	  case 0x99: cp = "sta"; 
	  {
	  print_2_byte_y:	/*entry */
					

			printf ("\t%s $%.4x,y\t\t; ", cp, arg);
			angie2 (opcode, arg, PC);					
	  }
	  break;
				
	  case 0xe0:
	       cp = "cpx"; 
	       if (e || x) goto print_1_byte_imm; 
	       else goto print_2_byte_imm;
	case 0xc0:
	     cp = "cpy"; 
	     if (e || x) goto print_1_byte_imm;
	     else goto print_2_byte_imm;
	     
	case 0xa2:
	     cp = "ldx"; 
	     if (e || x) goto print_1_byte_imm;
	     
	     cp = NULL;
	     /* this could be a tool call, which would look like */
	     /* ldx #$xxxx jsl $e10000 */
	     
	     
		     if ( Tools
			  && (i + 3 <= length) 
			  && (start[i] == 0x22) 
			  && (start[i+1] == 0x00) 
			  && (start[i+2] == 0x00) 
			  && (start[i+3] == 0xe1))
			  cp = tool_call( b1 (arg), b0 (arg));
		     if (cp && strlen (cp))
		     {
			  printf("\t%s\t\t;\t\t\t%lx\n", cp, PC);
			  i += 4;
		     }
		     else { cp = "ldx"; goto print_2_byte_imm; } 
		     break;

	  case 0xa0:
	       cp = "ldy"; 
	       if (e || x) goto print_1_byte_imm;
	       else goto print_2_byte_imm;
				
			
	       /* these depend on the state of the e or m bits */
	  case 0x69:
	       cp = "adc";
	       if (e || m) goto print_1_byte_imm;
	       else goto print_2_byte_imm;
	  case 0x29:
	       cp = "and";
	       if (e || m) goto print_1_byte_imm;
	       else goto print_2_byte_imm;
	  case 0x89:
	       cp = "bit";
	       if (e || m) goto print_1_byte_imm;
	       else goto print_2_byte_imm;
	  case 0xc9:
	       cp = "cmp";
	       if (e || m) goto print_1_byte_imm;
	       else goto print_2_byte_imm;
	  case 0x49:
	       cp = "eor";
	       if (e || m) goto print_1_byte_imm;
	       else goto print_2_byte_imm;
	  case 0xa9:
	       cp = "lda";
	       if (e || m) goto print_1_byte_imm;
	       else goto print_2_byte_imm;
	  case 0x09:
	       cp = "ora";
	       if (e || m) goto print_1_byte_imm;
	       else goto print_2_byte_imm;
	  case 0xe9:
	       cp = "sbc";
	       if (e || m) goto print_1_byte_imm;
	       {
	       print_2_byte_imm: /* entry */
			       
			printf ("\t%s #$%.4x\t\t; ", cp, arg.w);
			angie2 (opcode, arg, PC);
	       }
	       break;

	  case 0x72: cp = "adc"; goto print_1_byte_ind;
	  case 0x32: cp = "and"; goto print_1_byte_ind;
	  case 0xd2: cp = "and"; goto print_1_byte_ind;
	  case 0x52: cp = "eor"; goto print_1_byte_ind;
	  case 0xb2: cp = "lda"; goto print_1_byte_ind;
	  case 0x12: cp = "ora"; goto print_1_byte_ind; 
	  case 0xd4: cp = "pei"; goto print_1_byte_ind;
	  case 0xf2: cp = "sbc"; goto print_1_byte_ind;
	  case 0x92: 
	       cp = "sta"; 
	       {
	       print_1_byte_ind: /* entry */
			printf("\t%s ($%.2x)\t\t; ", cp, b0 (arg));
			angie1 (opcode, arg, PC);	     
	       }
	       break;

	  case 0x71: cp = "adc"; goto print_1_byte_ind_y;
	  case 0x31: cp = "and"; goto print_1_byte_ind_y;
	  case 0xd1: cp = "cmp"; goto print_1_byte_ind_y;
	  case 0x51: cp = "eor"; goto print_1_byte_ind_y;
	  case 0xb1: cp = "lda"; goto print_1_byte_ind_y;
	  case 0x11: cp = "ora"; goto print_1_byte_ind_y;
	  case 0xf1: cp = "sbc"; goto print_1_byte_ind_y;
	  case 0x91: 
	       cp = "sta";
	       {
	       print_1_byte_ind_y:
			printf ("\t%s ($%.2x),y\t\t; ", cp, b0 (arg));
			angie1 (opcode, arg, PC);
	       }
	       break;
	       
	  case 0x75: cp = "adc"; goto print_1_byte_dp_x;
	  case 0x35: cp = "and"; goto print_1_byte_dp_x;
	  case 0x16: cp = "asl"; goto print_1_byte_dp_x;
	  case 0x34: cp = "bit"; goto print_1_byte_dp_x;
	  case 0xd5: cp = "cmp"; goto print_1_byte_dp_x;
	  case 0xd6: cp = "dec"; goto print_1_byte_dp_x;
	  case 0x55: cp = "eor"; goto print_1_byte_dp_x;
	  case 0xf6: cp = "inc"; goto print_1_byte_dp_x;
	  case 0xb5: cp = "lda"; goto print_1_byte_dp_x;
	  case 0xb4: cp = "ldy"; goto print_1_byte_dp_x;
	  case 0x56: cp = "lsr"; goto print_1_byte_dp_x;
	  case 0x15: cp = "ora"; goto print_1_byte_dp_x;
	  case 0x36: cp = "rol"; goto print_1_byte_dp_x;
	  case 0x76: cp = "ror"; goto print_1_byte_dp_x;
	  case 0xf5: cp = "sbc"; goto print_1_byte_dp_x;
	  case 0x95: cp = "sta"; goto print_1_byte_dp_x;
	  case 0x94: cp = "sty"; goto print_1_byte_dp_x;
		case 0x74: 
			cp = "stz";
			{ 
				print_1_byte_dp_x:	/* entry */
				printf("\t%s $%.2x,x\t\t; ", cp, b0 (arg));
				angie1 (opcode, arg, PC);	
			}
			break;

		case 0x96: cp = "stx"; goto print_dp_y;
		case 0xb6: cp = "ldx";
			{
				print_dp_y:		/* Entry */
				printf ("\t%s $%.2x,y\t\t; ", cp, b0 (arg));
				angie1 (opcode, arg, PC);
			}
			break;

	case 0x6c:
		printf ("\tjmp ($%.4x)\t\t; ", arg.w); 
		angie2 (opcode, arg, PC);	       
		break;
	    
		case 0x7c: cp = "jmp"; goto print_2_byte_ind_x;
		case 0xfc: cp = "jsr"; 
		{
			print_2_byte_ind_x:	/* Entry point */
	      
			printf ("\t%s ($%.4x,X)\t\t; ", cp, arg.w);
			angie2 (opcode, arg, PC);
		}
		break;


	case 0x61: cp = "adc"; goto print_1_byte_ind_x;
	case 0x21: cp = "and"; goto print_1_byte_ind_x;
	case 0xc1: cp = "cmp"; goto print_1_byte_ind_x;
	case 0x41: cp = "eor"; goto print_1_byte_ind_x;
	case 0xa1: cp = "lda"; goto print_1_byte_ind_x;
	case 0x01: cp = "ora"; goto print_1_byte_ind_x;
	case 0xe1: cp = "sbc"; goto print_1_byte_ind_x;
	case 0x81: 
		cp = "sta"; 
		{
			print_1_byte_ind_x: /* Entry */

			printf ("\t%s ($%.2x,x)\t\t; ", cp, b0 (arg));
			angie1 (opcode, arg, PC);
		}
		break;

	  case 0x63: cp = "adc"; goto print_1_byte_s;
	  case 0x23: cp = "and"; goto print_1_byte_s;
	  case 0xc3: cp = "cmp"; goto print_1_byte_s;
	  case 0x43: cp = "eor"; goto print_1_byte_s;
	  case 0xa3: cp = "lda"; goto print_1_byte_s;
	  case 0x03: cp = "ora"; goto print_1_byte_s;
	  case 0xe3: cp = "sbc"; goto print_1_byte_s;
	  
		case 0x83: 
			cp = "sta"; 
			{
				print_1_byte_s:	/* entry */
				printf ("\t%s $%.2x,S\t\t; ", cp, b0 (arg));
				angie1 (opcode, arg, PC);	
			}
			break;

	  case 0x73: cp = "adc"; goto print_1_byte_s_y;
	  case 0x33: cp = "and"; goto print_1_byte_s_y;
	  case 0xd3: cp = "cmp"; goto print_1_byte_s_y;
	  case 0x53: cp = "eor"; goto print_1_byte_s_y;
	  case 0xb3: cp = "lda"; goto print_1_byte_s_y;
	  case 0x13: cp = "ora"; goto print_1_byte_s_y;
	  case 0xf3: cp = "sbc"; goto print_1_byte_s_y;
	  case 0x93: 
		cp = "sta"; 
		{
			print_1_byte_s_y: /* Entry */
		   
			printf("\t%s ($%.2x,S),y\t\t; ", cp, b0 (arg));
			angie1 (opcode, arg, PC);
		}
		break;
	       

	  case 0x67: cp = "adc"; goto print_1_byte_l_ind;
	  case 0x27: cp = "and"; goto print_1_byte_l_ind;
	  case 0xc7: cp = "cmp"; goto print_1_byte_l_ind;
	  case 0x47: cp = "eor"; goto print_1_byte_l_ind;
	  case 0xdc: cp = "jml"; goto print_1_byte_l_ind;
	  case 0xa7: cp = "lda"; goto print_1_byte_l_ind;
	  case 0x07: cp = "ora"; goto print_1_byte_l_ind;
	  case 0xe7: cp = "sbc"; goto print_1_byte_l_ind;	    
	  case 0x87: cp = "sta"; 
	{
		print_1_byte_l_ind:	/* Entry */

		printf ("\t%s [$%.2x]\t\t; ", cp, b0 (arg));
		angie1 (opcode, arg, PC);
	}
	break;

	  case 0x77: cp = "adc"; goto print_1_byte_l_ind_y;
	  case 0x37: cp = "and"; goto print_1_byte_l_ind_y;
	  case 0xd7: cp = "cmp"; goto print_1_byte_l_ind_y;
	  case 0x57: cp = "eor"; goto print_1_byte_l_ind_y;
	  case 0xb7: cp = "lda"; goto print_1_byte_l_ind_y;
	  case 0x17: cp = "ora"; goto print_1_byte_l_ind_y;
	  case 0xf7: cp = "sbc"; goto print_1_byte_l_ind_y;
		case 0x97: 
			cp = "sta"; 
			{
				print_1_byte_l_ind_y: /* Entry */

				printf("\t%s [$%.2x],y\t\t; ", cp, b0 (arg));
				angie1 (opcode, arg, PC);
			}
			break;

		case 0x82:
			cp = "brl";
			/* check for inline procedure names */
			if ((arg.w < 0x8000) /* forward */
				&& (i + 3 <= length)
				&& (start[i] == 0x71)
				&& (start[i+1] == 0x77)
				&& (i + 3 + start[i+2] <= length))
			{	/* yep ... inline name! */
				int tmp;
				int j;
				tmp = start[i+2]; /* pstring - length = 1st byte */
					
				printf("\tname '");
				for (j=0; j < tmp; j++)
					putchar (start[i+3+j]);
				printf("';\t\t\t\t%x\n", PC);
				
				i += 3 + tmp;
			}
			else
			{
				print_rel_word:	/* Entry */
	       	    
				if (arg.w < 0x8000)
				{
					printf ("\t%s $%x \t; ", cp, (arg.w + PC + 3) & 0xffff);	
					printf ("*+$%.4x\t  ", arg.w + 3);
				}
				else
				{
					printf ("\t%s $%x\t\t; ", cp, (PC - 0xfffd + arg.w) & 0xffff);
					printf ("*-$%.4x\t  ", 0xfffd - arg.w);
				}
				angie2 (opcode, arg, PC);
			}
			break;
	   	   
	
	  case 0x10: cp = "bpl"; goto print_rel_byte;
	  case 0x30: cp = "bmi"; goto print_rel_byte;
	  case 0x50: cp = "bvc"; goto print_rel_byte;
	  case 0x70: cp = "bvs"; goto print_rel_byte;
	  case 0x80: cp = "bra"; goto print_rel_byte;
	  case 0x90: cp = "bcc"; goto print_rel_byte;
	  case 0xb0: cp = "bcs"; goto print_rel_byte;
	  case 0xd0: cp = "bne"; goto print_rel_byte;
	  case 0xf0: cp = "beq"; 
	  {
	  print_rel_byte:	/* Entry */
	      
	        
		  	      
		if (arg.w < 128)
		{
			printf ("\t%s $%x \t; ", cp, (arg.w + PC + 2) & 0xffff);	
			printf ("*+$%.2x\t  ", arg.w + 2);
		}
		else
		{
			printf ("\t%s $%x\t\t; ", cp, (PC - 254 + arg.w) & 0xffff);
			printf ("*-$%.2x\t  ", 254 - arg.w);
	      
		}
		angie1 (opcode, arg, PC);
	}
	break;


	  default: printf("\nUnrecognized opcode: %x\n", opcode);
		
	  }				
		

     }
     return;
}


void dump1(long PC, int arg1)
{
	printf ("\tdc i1'$%.2x'\t\t; ", arg1);
	printf ("%.2x\t\t'", arg1);
	putchar (isprint(arg1)? arg1 : '.');
	printf("'\t%4lx\n",PC);
}

void dump2(long PC, int arg1, int arg2)
{
     printf ("\tdc i2'$%.4x'\t\t; ", arg1 + (arg2 << 8));
     printf ("%.2x ", arg1);
     printf ("%.2x\t\t'", arg2);
     putchar (isprint(arg1)? arg1 : '.');
     putchar (isprint(arg2)? arg2 : '.');
     printf ("'\t%4lx\n",PC);
}

/* dc i3'...'?  no thanks */
void dump3(long PC, int arg1, int arg2 , int arg3)
{
     dump1 (PC, arg1);
     dump2 (PC + 1,arg2, arg3);
}


static char *tool_1[] =
{
     "",			/* 0x0001 */
     "_TLBootInit",
     "_TLStartUp",
     "_TLShutDown",
     "_TLVersion",
     "_TLReset",
     "_TLStatus",
     "",
     "",
     "_GetTSPtr",
     "_SetTSPtr",
     "_GetFuncPtr",
     "_GetWAP",
     "_SetWAP",
     "_LoadTools",
     "_LoadOneTool",
     "_UnloadOneTool",		/* 0x1001 */
     "_TLMountVolume",
     "_TLTextMountVolume",
     "_SaveTextState",
     "_RestoreTextState",
     "_MessageCenter",
     "_SetDefaultTPT",
     "_MessageByName",
     "_StartUpTools",
     "_ShutDowntools",
     "_GetMsgHandle",
     "_AcceptRequests",
     "_SendRequest",
     NULL
};

static char *tool_2[] = 
{
     "",			/* 0x0002 */
     "_MMBootInit",
     "_MMStartUp",
     "_MMShutDown",
     "_MMVersion",
     "_MMReset",
     "_MMStatus",
     "",
     "",
     "_NewHandle",
     "_ReAllocHandle",
     "_RestoreHandle",
     "_AddToOOMQueue",
     "_RemoveFromOOMQueue",
     "",
     "",
     "_DisposeHandle",		/* 0x1002 */
     "_DisposeAll",
     "_PurgeHandle",
     "_PurgeAll",
     "",
     "",
     "",
     "",
     "_GetHandleSize",
     "_SetHandleSize",
     "_FindHandle",
     "_FreeMem",
     "_MaxBlock",
     "_TotalMem",
     "_CheckHandle",
     "_CompactMem",
     "_Hlock",			/* 0x2002 */
     "_HlockAll",
     "_HUnlock",
     "_HUnlockAll",
     "_SetPurge",
     "_SetPurgeAll",
     "",
     "",
     "_PtrToHand",
     "_HandToPtr",
     "_HandToHand",
     "_BlockMove",
     "",
     "",
     "",
     "_RealfreeMem",
     "_SetHandleID",		/* 0x3002 */
     NULL
};


static char *tool_3[] =
{
     "",
     "_MTBootInit",
     "_MTStartUp",
     "_MTShutDown",
     "_MTVersion",
     "_MTReset",
     "_MTStatus",
     "",
     "",
     "_WriteBRam",
     "_ReadBRam",
     "_WriteBParam",
     "_ReadBParam",
     "_ReadTimeHex",
     "_WriteTimeHex",
     "_ReadAsciiTime",
     "_SetVector",		/* 1003 */
     "_GetVector",
     "_SetHeartBeat",
     "_DelHeartBeat",
     "_ClrHeartBeat",
     "_SysFailMgr",
     "_GetAddr",
     "_ReadMouse",
     "_InitMouse",
     "_SetMouse",
     "_HomeMouse",
     "_ClearMouse",
     "_ClampMouse",
     "_GetMouseClamp",
     "_PosMouse",
     "_ServeMouse",
     "_GetNewID",		/* 2003 */
     "_DeleteID",
     "_StatusID",
     "_IntSource",
     "_FWEntry",
     "_GetTick",
     "_PackBytes",
     "_UnPackBytes",
     "_Munger",
     "_GetIRQEnable",
     "_SetAbsClamp",
     "_GetAbsClamp",
     "_SysBeep",
     "",
     "_AddToQueue",
     "_DeletFromQueue",
     "_SetInterruptState",	/* 3003 */
     "_GetInterruptState",
     "_GetIntStateRecSize",
     "_ReadMouse2",
     "_GetCodeResConverter",
     "_GetRomResource",
     "_ReleaseRomResource",
     "_ConvSeconds",
     "_SysBeep2",
     "_VersionString",
     "_WaitUntil",
     "_StringToText",
     "_ShowBootInfo",
     "_ScanDevices",
     "_AlertMessage",
     "_DoSysPrefs",
     NULL

};


static char *tool_4[] =
{
	"",	/* 0x0004 */
	"_QDBootInit",
	"_QDStartUp",
	"_QDShutDown",
	"_QDVersion",
	"_QDReset",
	"_QDStatus",
	"",
	"",
	"_GetAddress",
	"_GrafOn",
	"_GrafOff",
	"_GetStandardSCB",
	"_InitColorTable",
	"_SetColorTable",
	"_GetColorTable",
	"_SetColorEntry",
	"_GetColorEntry",
	"_SetSCB",
	"_GetSCB",
	"_SetAllSCBs",
	"_ClearScreen",
	"_SetMasterSCB",
	"_GetMasterSCB",
	"_OpenPort",
	"_InitPort",
	"_ClosePort",
	"_SetPort",
	"_GetPort",
	"_SetPortLoc",
	"_GetPortLoc",
	"_SetPortRect",
	"_GetPortRect",	/* 0x2004 */
	"_SetPortSize",
	"_MovePortTo",
	"_SetOrigin",
	"_SetClip",
	"_GetClip",
	"_ClipRect",
	"_HidePen",
	"_ShowPen",
	"_GetPen",
	"_SetPenState",
	"_GetPenState",
	"_SetPenSize",
	"_GetPenSize",
	"_SetPenMode",
	"_GetPenMode",
	"_SetPenPat",	/* 0x3004 */
	"_GetPenPat",
	"_SetPenMask",
	"_GetPenMask",
	"_SetBackPat",
	"_GetBackPat",
	"_PenNormal",
	"_SetSolidPenPat",
	"_SetSolidBackPat",
	"_SolidPattern",
	"_MoveTo",
	"_Move",
	"_LineTo",
	"_Line",
	"_SetPicSave",
	"_GetPicSave",
	"_SetRgnSave",		/* 0x4004 */
	"_GetRgnSave",
	"_SetPolySave",
	"_GetPolySave",
	"_SetGrafProcs",
	"_GetGrafProcs",
	"_SetUserField",
	"_GetUserField",
	"_SetSysField",
	"_GetSysField",
	"_SetRect",
	"_OffsetRect",
	"_InsetRect",
	"_SectRect",
	"_UnionRect",
	"_PtInRect",
	"_Pt2Rect",		/* 0x5004 */
	"_EqualRect",
	"_NotEmptyRect",
	"_FrameRect",
	"_PaintRect",
	"_EraseRect",
	"_InvertRect",
	"_FillRect",
	"_FrameOval",
	"_PaintOval",
	"_EraseOval",
	"_InvertOval",
	"_FillOval",
	"_FrameRRect",
	"_PaintRRect",
	"_EraseRRect",
	"_InvertRRect",	/* 0x6004 */
	"_FillRRect",
	"_FrameArc",
	"_PaintArc",
	"_EraseArc",
	"_InvertArc",
	"_FillArc",
	"_NewRgn",
	"_DisposeRgn",
	"_CopyRgn",
	"_SetEmptyRgn",
	"_SetRectRgn",
	"_RectRgn",
	"_OpenRgn",
	"_CloseRgn",
	"_OffsetRgn",
	"_InsetRgn",		/* 0x7004 */
	"_SectRgn",
	"_UnionRgn",
	"_DiffRgn",
	"_XorRgn",
	"_PtInRgn",
	"_RectInRgn",
	"_EqualRgn",
	"_EmptyRgn",
	"_FrameRgn",
	"_PaintRgn",
	"_EraseRgn",
	"_InvertRgn",
	"_FillRgn",
	"_ScrollRect",
	"_PaintPixels",
	"_AddPt",	/* 0x8004 */
	"_SubPt",
	"_SetPt",
	"_EqualPt",
	"_LocalToGlobal",
	"_GlobalToLocal",
	"_Random",
	"_SetRandSeed",
	"_GetPixel",
	"_ScalePt",
	"_MapPt",
	"_MapRect",
	"_MapRgn",
	"_SetStdProcs",
	"_SetCursor",
	"_GetCursorAdr",
	"_HideCursor",		/* 0x9004 */
	"_ShowCursor",
	"_ObscureCursor",
	"_SetMouseLoc",
	"_SetFont",
	"_GetFont",
	"_GetFontInfo",
	"_GetFontGlobals",
	"_SetFontFlags",
	"_GetFontFlags",
	"_SetTextFace",
	"_GetTextFace",
	"_SetTextMode",
	"_GetTextMode",
	"_SetSpaceExtra",
	"_GetSpaceExtra",
	"_SetForeColor",		/* 0xa004 */
	"_GetForeColor",
	"_SetBackColor",
	"_GetBackColor",
	"_DrawChar",
	"_DrawString",
	"_DrawCString",
	"_DrawText",
	"_CharWidth",
	"_StringWidth",
	"_CStringWidth",
	"_TextWidth",
	"_CharBounds",
	"_StringBounds",
	"_CStringBounds",
	"_TextBounds",
	"_SetArcRot",		/* 0xb004 */
	"_GetArcRot",
	"_SetSysFont",
	"_GetSysFont",
	"_SetVisRgn",
	"_GetVisRgn",
	"_SetIntUse",
	"_OpenPicture",
	"_PicComment",
	"_ClosePicture",
	"_DrawPicture",
	"_KillPicture",
	"_FramePoly",
	"_PaintPoly",
	"_ErasePoly",
	"_InvertPoly",
	"_FillPoly",		/* 0xc004 */
	"_OpenPoly",
	"_ClosePoly",
	"_KillPoly",
	"_OffsetPoly",
	"_MapPoly",
	"_SetClipHandle",
	"_GetClipHandle",
	"_SetVisHandle",
	"_GetVisHandle",
	"_InitCursor",
	"_SetBufDims",
	"_ForceBufDims",
	"_SaveBufDims",
	"_RestoreBufDims",
	"_GetFGSize",
	"_SetFontID",		/* 0xd004 */
	"_GetFontID",
	"_SetTextSize",
	"_GetTextSize",
	"_SetCharExtra",
	"_GetCharExtra",
	"_PPToPort",
	"_InflateTextBuffer",
	"_GetRomFont",
	"_GetFontLore",
	"_Get640Colors",
	"_Set640Color",
	NULL
};


static char *tool_5[] =
{

	"",
	"_DeskBootInit",
	"_DeskStartUp",
	"_DeskShutDown",
	"_DeskVersion",
	"_DeskReset",
	"_DeskStatus",
	"",
	"",
	"_SaveScrn",
	"_RestScrn",
	"_SaveAll",
	"_RestAll",
	"",
	"_InstallNDA",
	"_InstallCDA",
	"",					/* 1005 */
	"_ChooseCDA",
	"",
	"_SetDAStrPtr",
	"_GetDAStrPtr",
	"_OpenNDA",
	"_CloseNDA",
	"_SystemClick",
	"_SystemEdit",
	"_SystemTask",
	"_SystemEvent",
	"_GetNumNDAs",
	"_CloseNDAByWinPtr",
	"_CloseAllNDAs",
	"_FixAppleMenu",
	"_AddToRunQ",
	"_RemoveFromRunQ",	/* 2005 */
	"_RemoveCDA",
	"_RemoveNDA",
	"_GetDeskAccInfo",
	"_CallDeskAcc",
	"_GetDeskGlobal",
	NULL,
};


static char *tool_6[] =
{
	"",
	"_EMBootInit",
	"_EMStartUp",
	"_EMShutDown",
	"_EMVersion",
	"_EMReset",
	"_EMStatus",
	"",
	"",
	"_DoWindows",
	"_GetNextEvent",
	"_EventAvail",
	"_GetMouse",
	"_Button",
	"_StillDown",
	"_WaitMouseUp",
	"_TickCount",
	"_GetDblTime",
	"_GetCaretTime",
	"_SetSwitch",
	"_PostEvent",
	"_FlushEvents",
	"_GetOSEvent",
	"_OSEventAvail",
	"_SetEventMask",
	"_FakeMouse",
	"_SetAutoKeyLimit",
	"_GetKeyTranslation",
	"_SetKeyTranslation",
	NULL
};


static char *tool_7[] = 
{
	"",
	"_SchBootInit",
	"_SchStartUp",
	"_SchShutDown",
	"_SchVersion",
	"_SchReset",
	"_SchStatus",
	"",
	"",
	"_SchAddTask",
	"_SchFlush",
	NULL
};

char *tool_8[] =
{
	"",
	"_SoundBootInit",
	"_SoundStartUp",
	"_SoundShutDown",
	"_SoundVersion",
	"_SoundReset",
	"_SoundToolStatus",
	"",
	"",
	"_WriteRamBlock",
	"_ReadRamBlock",
	"_GetTableAddress",
	"_GetSoundVolume",
	"_SetSoundVolume",
	"_FFStartSound",
	"_FFStopSound",
	"_FFSoundStatus",
	"_FFGeneratorStatus",
	"_SetSoundMIRQV",
	"_SetUserSoundIRQV",
	"_FFSoundDoneStatus",
	"_FFSetUpSound",
	"_FFStartPlaying",
	"_SetDocReg",
	"_ReadDocReg",
	NULL
};

char *tool_9[] =
{
	"",				/* 0x0009 */
	"_ADBBootInit",
	"_ADBStartUp",
	"_ADBShutDown",
	"_ADBVersion",
	"_ADBReset",
	"_ADBStatus",
	"",
	"",
	"_SendInfo",
	"_ReadKeyMicroData",
	"_ReadKeyMicroMemory",
	"",
	"_AsyncADBRecieve",
	"_SyncADBRecieve",
	"_AbsOn",
	"_AbsOff",	/* 0x1009 */
	"_ReadAbs",
	"_SetAbsScale",
	"_GetAbsScale",
	"_SRQPoll",
	"_SRQRemove",
	"_ClearSRQTable",
	NULL
};


char *tool_a[] = 
{
	"",
	"_SANEBootInit"
	"_SANEStartUp",
	"_SANEShutDown",
	"_SANEVersion",
	"_SANEReset",
	"_SANEStatus",
	"",
	"",
	"_FPNum",
	"_DecStrNum",
	"_ElemNum",
	NULL,
};

static char *tool_b[] =
{
	"",		/* 0x000b */
	"_IMBootInit",
	"_IMStartUp",
	"_IMShutDown",
	"_IMVersion",
	"_IMReset",
	"_IMStatus",
	"",
	"",
	"_Multiply",
	"_SDivide",
	"_UDivide",
	"_LongMul",
	"_LongDivide",
	"_FixRatio",
	"_FixMul",
	"_FracMul",			/* 0x100b */
	"_FixDiv",
	"_FracDiv",
	"_FixRound",
	"_FracSqrt",
	"_FracCos",
	"_FracSin",
	"_FixATan2",
	"_HiWord",
	"_LoWord",
	"_Long2Fix",
	"_Fix2Long",
	"_Fix2Frac",
	"_Frac2Fix",
	"_Fix2X",
	"_Frac2X",
	"_X2Fix",				/* 0x200b */
	"_X2Frac",
	"_Int2Hex",
	"_Long2Hex",
	"_Hex2Int",
	"_Hex2Long",
	"_Int2Dec",
	"_Long2Dec",
	"_Dec2Int",
	"_Dec2Long",
	"_HexIt",
	NULL
};


static char *tool_c[] =
{
     "",			/* 0x000C */
     "_TextBootInit",
     "_TextStartUp",
     "_TextShutDown",
     "_TextVersion",
     "_TextReset",
     "_TextStatus",
     "",
     "",
     "_SetInGlobals",
     "_SetOutGlobals",
     "_SetErrGlobals",
     "_GetInGlobals",
     "_GetOutGlobals",
     "_GetErrGlobals",
     "_SetInputDevice",
     "_SetOutputDevice",	/* 0x100C */
     "_SetErrorDevice",
     "_GetInputDevice",
     "_GetOutputDevice",
     "_GetErrorDevice",
     "_InitTextDevice",
     "_CtlTextDev",
     "_StatusTextDev",
     "_WriteChar",
     "_ErrWriteChar",
     "_WriteLine",
     "_ErrWriteLine",
     "_WriteString",
     "_ErrWriteString",
     "_TextWriteBlock",
     "_ErrWriteBlock",
     "_WriteCString",		/* 0x200C */
     "_ErrWriteCString",
     "_ReadChar",
     "_TextReadBlock",
     "_ReadLine",
     NULL
};

char *tool_e[] =
{
	"",
	"_WindBootInit",
	"_WindStartUp",
	"_WindShutDown",
	"_WindVersion",
	"_WindReset",
	"_WindStatus",
	"",
	"",
	"_NewWindow",
	"_CheckUpdate",
	"_CloseWindow",
	"_Desktop",
	"_SetWTitle",
	"_GetWTitle",
	"_SetFrameColor",
	"_GetFrameColor",		/* 0x100e */
	"_SelectWindow",
	"_HideWindow",
	"_ShowWindow",
	"_SendBehind",
	"_FrontWindow",
	"_SetInfoDraw",
	"_FindWindow",
	"_TrackGoAway",
	"_MoveWindow",
	"_DragWindow",
	"_GrowWindow",
	"_SizeWindow",
	"_TaskMaster",
	"_BeginUpdate",
	"_EndUpdate",
	"_GetWMgrPort",		/* 200e */
	"_PinRect",
	"_HiliteWindow",
	"_ShowHide",
	"_BringToFront",
	"_WindNewRes",
	"_TrackZoom",
	"_ZoomWindow",
	"_SetWRefCon",
	"_GetWRefCon",
	"_GetNextWindow",
	"_GetWKind",
	"_GetWFrame",
	"_SetWFrame",
	"_GetStructRgn",
	"_GetContentRgn",
	"_GetUpdateRgn",	/* 300e */
	"_GetDefProc",
	"_SetDefProc",
	"_GetWControls",
	"_SetOriginMask",
	"_GetInfoRefCon",
	"_SetInfoRefCon",
	"_GetZoomRect",
	"_SetZoomRect",
	"_RefreshDesktop",
	"_InvalRect",
	"_InvalRgn",
	"_ValidRect",
	"_ValidRgn",
	"_GetContentOrigin",
	"_SetContentOrigin",
	"_GetDataSize",		/* 0x400e */
	"_SetDataSize",
	"_GetMaxGrow",
	"_SetMaxGrow",
	"_GetScroll",
	"_SetScroll",
	"_GetPage",
	"_SetPage",
	"_GetContentDraw",
	"_SetContentDraw",
	"_GetInfoDraw",
	"_SetSysWindow",
	"_GetSysWFlag",
	"_StartDrawing",
	"_SetWindowIcons",
	"_GetRectInfo",
	"_StartInfoDrawing",		/* 0x500e */
	"_EndInfoDrawing",
	"_GetFirstWindow",
	"_WindDragRect",
	"_GetDragRectPtr", /* private 1 */
	"_DrawInfoBar",
	"_WindowGlobal",
	"_SetContentOrigin2",
	"_GetWindowMgrGlobals",
	"_AlertWindow",
	"_StartFrameDrawing",
	"_EndFrameDrawing",
	"_ResizeWindow",
	"_TaskMasterContent",
	"_TaskMasterKey",
	"_TaskMasterDA",
	"_CompileText",		/* 0x600e */
	"_NewWindow2",
	"_ErrorWindow",
	"_GetAuxWindInfo",
	"_DoModalWindow",
	"_MWGetCtlPart",
	"_MWSetMenuProc",
	"_MWStdDrawProc",
	"_MWSetUpEditMenu",
	"_FindCursorCtl",
	"_ResizeInfoBar",
	"_HandleDiskInsert",
	"_UpdateWindow",
	NULL
};

static char *tool_f[] =
{
	"",
	"_MenuBootInit",
	"_MenuStartUp",
	"_MenuShutDown",
	"_MenuVersion",
	"_MenuReset",
	"_MenuStatus",
	"",
	"",
	"_MenuKey",
	"_GetMenuBar",
	"_MenuRefresh",
	"_FlashMenuBar",
	"_InsertMenu",
	"_DeleteMenu",
	"_InsertMItem",
	"_DeleteMItem",
	"_GetSysBar",
	"_SetSysBar",
	"_FixMenuBar",
	"_CountMItems",
	"_NewMenuBar",
	"_GetMHandle",
	"_SetBarColors",
	"_GetBarColors",
	"_SetMTitleStart",
	"_GetMTitleStart",
	"_GetMenuMgrPort",
	"_CalcMenuSize",
	"_SetMTitleWidth",
	"_GetMTitleWidth",
	"_SetMenuFlag",
	"_GetMenuFlag",
	"_SetMenuTitle",
	"_GetMenuTitle",
	"_MenuGlobal",
	"_SetMItem",
	"_GetMItem",
	"_SetMItemFlag",
	"_GetMItemFlag",
	"_SetMItemBlink",
	"_MenuNewRes",
	"_DrawMenuBar",
	"_MenuSelect",
	"_HiliteMenu",
	"_NewMenu",
	"_DisposeMenu",
	"_InitPalette",
	"_EnableMItem",
	"_DisableMItem",
	"_CheckMItem",
	"_SetMItemMark",
	"_GetMItemMark",
	"_SetMItemStyle",
	"_GetMItemStyle",
	"_SetMenuID",
	"_SetMItemID",
	"_SetMenuBar",
	"_SetMItemName",
	"_GetPopUpDefProc",
	"_PopUpMenuSelect",
	"_DrawPopUp",	/* [?] */
	"_NewMenu2",
	"_InsertMItem2",
	"_SetMenuTitle2",
	"_SetMItem2",
	"_SetMItemName2",
	"_NewMenuBar2",
	"_HideMenuBar",
	"_ShowMenuBar",
	"_SetMItemIcon",
	"_GetMItemIcon",
	"_SetMItemStruct",
	"_GetMItemStruct",
	"_RemoveMItemStruct",
	"_GetMItemFlag2",
	"_SetMItemFlag2",
	"_GetMItemBlink",
	"_InsertPathMItems",
	NULL,
};

char *tool_10[] = 
{
	"",		/* 0x0010 */
	"_CtlBootInit",
	"_CtlStartUp",
	"_CtlShutDown",
	"_CtlVersion",
	"_CtlReset",
	"_CtlStatus",
	"",
	"",
	"_NewControl",
	"_DisposeControl",
	"_KillControls",
	"_SetCtlTitle",
	"_GetCtlTitle",
	"_HideControl",
	"_ShowControl",
	"_DrawControls",	/* 0x1010 */
	"_HiliteControl",
	"_CtlNewRes",
	"_FindControl",
	"_TestControl",
	"_TrackControl",
	"_MoveControl",
	"_DragControl",
	"_SetCtlIcons",
	"_SetCtlValue",
	"_GetCtlValue",
	"_SetCtlParams",
	"_GetCtlParams",
	"_DragRect",
	"_GrowSize",
	"_GetCtldDpage",
	"_SetCtlAction",	/* 0x2010 */
	"_GetCtlAction",
	"_SetCtlRefCon",
	"_GetCtlRefCon",
	"_EraseControl",
	"_DrawOneCtl",
	"_FindTargetCtl",
	"_MakeNextCtlTarget",
	"_MakeThisCtlTarget",
	"_SendEventToCtl",
	"_GetCtlID",
	"_SetCtlID",
	"_CallCtlDefProc",
	"_NotifyCtls",
	"_GetCtlMoreFlags",
	"_SetCtlMoreFlags",
	"_GetCtlHandleFromID",		/* 0x3010 */
	"_NewControl2",
	"_CMLoadResource",
	"_CMReleaseResource",
	"_SetCtlParamPtr",
	"_GetCtlParamPtr",
	"",
	"_InvalCtls",
	"",
	"_FindRadioButton",
	"_SetLETextByID",
	"_GetLETextByID",
	"_SetCtlValueByID",
	"_GetCtlValueByID",
	"_InvalOneCtlByID",
	"_HiliteCtlByID",
	NULL
};

char *tool_11[] =
{
     "",			/* 0x0011 */
     "_LoaderInitialization",
     "_LoaderStartUp",
     "_LoaderShutDown",
     "_LoaderVersion",
     "_LoaderReset",
     "_LoaderStatus",
     "",
     "",
     "_InitialLoad",
     "_Restart",
     "_LoadSegNum",
     "_UnloadSegNum",
     "_LoadSegName",
     "_UnLoadSeg",
     "_GetLoadSegInfo",
     "_GetUserID",		/* 0x1011 */
     "_LGetPathname",
     "_UserShutDown",
     "_RenamePathname",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
     "_InitialLoad2",			/* 0x2011 */
     "_GetUserID2",
     "_LGetPathname2",
     NULL
};

char *tool_12[] =
{
	"",		/* 0x0012 */
	"_QDAuxBootInit",
	"_QDAuxStartUp",
	"_QDAuxShutDown",
	"_QDAuxVersion",
	"_QDAuxReset",
	"_QDAuxStatus",
	"",
	"",
	"_CopyPixels",
	"_WaitCursor",
	"_DrawIcon"
	"_SpecialRect",
	"_SeedFill",
	"_CalcMask",
	"_GetSysIcon",
	"_PixelMap2Rgn",		/* 0x1012 */
	"",
	"",
	"_IBeamCursor",
	"_WhooshRect",
	"_DrawStringWidth",
	"_UseColorTable",
	"_RestoreColorTable",
	NULL
};


static char *tool_13[] = 
{
	"",
	"_PMBootInit",
	"_PMStartUp",
	"_PMShutDown",
	"_PMVersion",
	"_PMReset",
	"_PMStatus",
	"",
	"",
	"_PrDefault",
	"_PrValidate",
	"_PrStlDialog",
	"_PrJobDialog",
	"_PrPixelMap",
	"_PrOpenDoc",
	"_PrCloseDoc",
	"_PrOpenPage",
	"_PrClosePage",
	"_PrPicFile",
	"_PrControl",
	"_PrError",
	"_PrSetError",
	"_PrChoosePrinter",
	"",
	"_PrGetPrinterSpecs",
	"_PrDevPrChanged",
	"_PrDevStartup",
	"_PrDevShutDown",
	"_PrDevOpen",
	"_PrDevRead",
	"_PrDevWrite",
	"_PrDevClose",
	"_PrDevStatus",
	"_PrDevAsyncRead",
	"_PrDevWriteBackground",
	"_PrDriverVer",
	"_PrPortVer",
	"_PrGetZoneName",
	"",
	"",
	"_PrGetPrinterDvrName",
	"_PrGetPortDvrName",
	"_PrGetUserName",
	"_PrGetNetworkName",
	"",
	"",
	"",
	"",
	"_PrDevIsItSafe",
	"_GetZoneList",
	"_GetMyZone",
	"_GetPrinterList",
	"_PMUnloadDriver",
	"_PMLoadDriver",
	"_PrGetDocName",
	"_PrSetDocName",
	"_PrGetPgOrientation",
	NULL
};

static char *tool_14[] =
{
	"",
	"_LEBootInit",
	"_LEStartUp",
	"_LEShutDown",
	"_LEVersion",
	"_LEReset",
	"_LEStatus",
	"",
	"",
	"_LENew",
	"_LEDispose",
	"_LESetText",
	"_LEIdle",
	"_LEClick",
	"_LESetSelect",
	"_LEActivate",
	"_LEDeactivate",
	"_LEKey",
	"_LECut",
	"_LECopy",
	"_LEPaste",
	"_LEDelete",
	"_LEInsert",
	"_LEUpdate",
	"_LETextBox",
	"_LEFromScrap",
	"_LEToScrap",
	"_LEScrapHandle",
	"_LEGetScrapLen",
	"_LESetScrapLen",
	"_LESetHilite",
	"_LESetCaret",
	"_LETextBox2",
	"_LESetJust",
	"_LEGetTextHand",
	"_LEGetTextLen",
	"_GetLEDefProc",
	"_LEClassifyKey",
	NULL,
};
	
	
static char *tool_15[] =
{
	"",
	"_DialogBootInit",
	"_DialogStartUp",
	"_DialogShutDown",
	"_DialogVersion",
	"_DialogReset",
	"_DialogStatus",
	"",
	"",
	"_ErrorSound",
	"_NewModalDialog",
	"_NewModelessDialog",
	"_CloseDialog",
	"_NewDItem",
	"_RemoveDItem",
	"_ModalDialog",
	"_IsDialogEvent",
	"_DialogSelect",
	"_DlgCut",
	"_DlgCopy",
	"_DlgPaste",
	"_DlgDelete",
	"_DrawDialog",
	"_Alert",
	"_StopAlert",
	"_NoteAlert",
	"_CautionAlert",
	"_ParamText",
	"_SetDAFont",
	"",
	"_GetControlDItem",
	"_GetIText",
	"_SetIText",		/* 0x2015 */
	"_SelectIText",
	"_HideDItem",
	"_ShowDItem",
	"_FindDItem",
	"_UpdateDialog",
	"_GetDItemType",
	"_SetDItemType",
	"_GetDItemBox",
	"_SetDItemBox",
	"_GetFirstDItem",
	"_GetNextDItem",
	"_ModalDialog2",
	"",
	"_GetDItemValue",
	"_SetDItemValue",
	"",
	"",
	"_GetNewModalDialog",
	"_GetNewDItem",
	"_GetAlertStage",
	"_ResetAlertStage",
	"_DefaultFilter",
	"_GetDefButton",
	"_SetDefButton",
	"_DisableDItem",
	"_EnableDItem",
	NULL
};	
	
	
	
	
char *tool_16[] = 
{
     "",			/* 0x0016 */
     "_ScrapBootInit",
     "_ScrapStartUp",
     "_ScrapShutDown",
     "_ScrapVersion",
     "_ScrapReset",
     "_ScrapStatus",
     "",
     "",
     "_UnloadScrap",
     "_LoadScrap",
     "_ZeroScrap",
     "_PutScrap",
     "_GetScrap",
     "_GetScrapHandle",
     "_GetScrapSize",
     "_GetScrapPath",		/* 0x1016 */
     "_SetScrapPath",
     "_SetScrapCount",
     "_GetScrapState",
     "_GetIndScrap",
     "_ShowClipboard",
     NULL
};

char *tool_17[] =
{
	"",		/* 0x0017 */
	"_SFBootInit",
	"_SFStartUp",
	"_SFShutDown",
	"_SFVersion",
	"_SFReset",
	"_SFStatus",
	"",
	"",
	"_SFGetFile",
	"_SFPutFile",
	"_SFPGetFile",
	"_SFPPutFile",
	"_SFAllCaps",
	"_SFGetFile2",
	"_SFPutFile2",
	"_SFPGetFile2",		/* 0x1017 */
	"_SFPPutFile2",
	"_SFShowInvisible",
	"_SFReScan",
	"_SFMultiGet2",
	"_SFPMultiGet2",
	NULL
};

char *tool_19[] =
{
	"",
	"_NSBootInit",
	"_NSStartUp",
	"_NSShutDown",
	"_NSVersion",
	"_NSReset",
	"_NSStatus",
	"",
	"",
	"_AllocGen",
	"_DeallocGen",
	"_NoteOn",
	"_NoteOff",
	"_AllNotesOff",
	"_NSSetUpdateRate",
	"_NSSetUserUpdateRtn",
	NULL,
};

static char *tool_1a[] =
{
	"",	
	"_SeqBootInit",
	"_SeqStartUp",
	"_SeqShutDown",
	"_SeqVersion",
	"_SeqReset",
	"_SeqStatus",
	"",
	"",
	"_SetIncr",
	"_ClearIncr",
	"_GetTimer",
	"_GetLoc",
	"_SeqAllNotesOff",
	"_SetTrkInfo",
	"_StartSeq",
	"_StepSeq",
	"_StopSeq",
	"_SetInstTable",
	"_StartInts",
	"_StopInts",
	"_StartSeqRel",
	NULL
};

static char *tool_1b[] =
{
	"",
	"_FMBootInit",
	"_FMStartUp",
	"_FMShutDown",
	"_FMVersion",
	"_FMReset",
	"_FMStatus",
	"",
	"",
	"_CountFamilies",
	"_FindFamily",
	"_GetFamInfo",
	"_GetFamNum",
	"_AddFamily",
	"_InstallFont",
	"_SetPurgeStat",
	"_CountFonts",
	"_FindFontStats",
	"_LoadFont",
	"_LoadSysFont",
	"_AddFontVar",
	"_FixFontMenu",
	"_ChooseFont",
	"_ItemID2FamNum",
	"_FMSetSysFont",
	"_FMGetSysFID",
	"_FMGetCurFID",
	"_FamNum2ItemID",
	"_InstallWithStats",
	NULL
};

static char *tool_1c[] = {
	"",
	"_ListBootInit",
	"_ListStartUp",
	"_ListShutDown",
	"_ListVersion",
	"_ListReset",
	"_ListStatus",
	"",
	"",
	"_CreateList",
	"_SortList",
	"_NextMember",
	"_DrawMember",
	"_SelectMember",
	"_GetListDefProc",
	"_ResetMember",
	"_NewList",
	"_DrawMember2",
	"_NextMember2",
	"_ResetMember2",
	"_SelectMember2",
	"_SortList2",
	"_NewList2",
	"_ListKey",
	"_CompareStrings",
	NULL	
};



char *tool_1d[] = 
{
     "",					/* 0x001d */
     "_ACEBootInit",
     "_ACEStartUp",
     "_ACEShutDown",
     "_ACEVersion",
     "_ACEReset",
     "_ACEStatus",
     "_ACEInfo",
     "",
     "_ACECompress",
     "_ACEExpand",
     "_ACECompBegin",
     "_ACEExpBegin",
     "_GetACEExpState",
     "_SetACEExpState",
     NULL	
};	


char *tool_1e[] = 
{
	"",
	"_ResourceBootInit",
	"_ResourceStartUp",
	"_ResourceShutDown",
	"_ResourceVersion",
	"_ResourceReset",
	"_ResourceStatus",
	"",
	"",
	"_CreateResourceFile",
	"_OpenResourceFile",
	"_CloseResourceFile",
	"_AddResource",
	"_UpdateResourcefile",
	"_LoadResource",
	"_RemoveResource",
	"_MarkResourceChange",
	"_SetCurResourceFile",
	"_GetCurResourceFile",
	"_SetCurResourceApp",
	"_GetCurResourceApp",
	"_HomeResourceFile",
	"_WriteResource",
	"_ReleaseResource",
	"_DetachResource",
	"_UniqueResourceID",
	"_SetResourceID",
	"_GetResourceAttr",
	"_SetResourceAttr",
	"_GetResourceSize",
	"_MatchResourceHandle",
	"_GetOpenFileRefNum",
	"_CountTypes",
	"_GetIndType",
	"_CountResources",
	"_GetIndResource",
	"_SetResourceLoad",
	"_SetResourceFileDepth",
	"_GetMapHandle",
	"_LoadAbsResource",
	"_ResourceConverter",
	"_LoadResource2",
	"_RMFindNamedResource",
	"_RMGetResourceName",
	"_RMLoadNamedResource",
	"_RMSetResourceName",
	"_OpenResourceFileByID",
	"_CompactResourceFile",
	NULL
};

static char *tool_20[] = 
{
	"",
	"_MidiBootInit",
	"_MidiStartUp",
	"_MidiShutDown",
	"_MidiVersion",
	"_MidiReset",
	"_MidiStatus",
	"",
	"",
	"_MidiControl",
	"_MidiDevice",
	"_MidiClock",
	"_MidiInfo",
	"_MidiReadPacket",
	"_MidiWritePacket",
	NULL
};

static char *tool_21[] = 
{
	"",
	"_VDBootInit",
	"_VDStartUp",
	"_VDShutDown",
	"_VDVersion",
	"_VDReset",
	"_VDStatus",
	"",
	"",
	"_VDInStatus",
	"_VDInSetStd",
	"_VDInGetStd",
	"_VDInConvAdj",
	"_VDKeyControl",
	"_VDKeyStatus",
	"_VDKeySetKCol",
	"_VDKeyGetKRCol",
	"_VDKeyGetKGCol",
	"_VDKeyGetKBCol",
	"_VDKeySetKDiss",
	"_VDKeyGetKDiss",
	"_VDKeySetNKDiss",
	"_VDKeyGetNKDiss",
	"_VDOutSetStd",
	"_VDOutGetStd",
	"_VDOutControl",
	"_VDOutStatus",
	"_VDGetFeatures",
	"_VDInControl",
	"_VDGGControl",
	"_VDGGStatus",
	NULL
};

static char *tool_22[] =
{
	"",
	"_TEBootInit",
	"_TEStartUp",
	"_TEShutDown",
	"_TEVersion",
	"_TEReset",
	"_TEStatus",
	"",
	"",
	"_TENew",
	"_TEKill",
	"_TESetText",
	"_TEGetText",
	"_TEGetTextInfo",
	"_TEIdle",
	"_TEActivate",
	"_TEDeactivate",
	"_TEClick",
	"_TEUpdate",
	"_TEPaintText",
	"_TEKey",
	"",
	"_TECut",
	"_TECopy",
	"_TEPaste",
	"_TEClear",
	"_TEInsert",
	"_TEReplace",
	"_TEGetSelection",
	"_TESetSelection",
	"_TEGetSelectionStyle",
	"_TEStyleChange",
	"_TEOffsetToPoint",
	"_TEPointToOffset",
	"_TEGetDefProc",
	"_TEGetRuler",
	"_TESetRuler",
	"_TEScroll",
	"_TEGetInternalProc",
	"_TEGetLastError",
	"_TECompactRecord",
	NULL
};


static char *tool_23[] = 
{
	"",
	"_MSBootInit",
	"_MSStartUp",
	"_MSShutDown",
	"_MSVersion",
	"_MSReset",
	"_MSStatus",
	"",
	"",
	"_SetBasicChannel",
	"_SetMIDIMode",
	"_PlayNote",
	"_StopNote",
	"_KillAllNotes",
	"_SetRecTrack",
	"_SetPlayTrack",
	"_TrackToChannel",
	"_Locate",
	"_SetVelComp",
	"_SetMIDIPort",
	"_SetInstrument",
	"_SeqPlayer",
	"_SetTempo",
	"_SetCallBack",
	"_SysExOut",
	"_SetBeat",
	"_MIDIMessage",
	"_LocateEnd",
	"_Merge",
	"_DeleteTrack",
	"_SetMetro",
	"_GetMSData",
	"_ConvertToTime",
	"_ConvertToMeasure",
	"_MSSuspend",
	"_MSResume",
	"_SetTuningTable",
	"_GetTuningTable",
	"_SetTrackOut",
	"_InitMIDIDriver",
	"_RemoveMIDIDriver",
	NULL
};

static char *tool_26[] = 
{
	"",
	"_MCBootInit",
	"_MCStartUp",
	"_MCShutDown",
	"_MCVersion",
	"_MCReset",
	"_MCStatus",
	"",
	"",
	"_MCGetErrorMsg",
	"_MCLoadDriver",
	"_MCUnLoadDriver",
	"_MCTimeToBin",
	"_MCBinToTime",
	"_MCGetTrackTitle",
	"_MCSetTrackTitle",
	"_MCGetProgram",
	"_MCSetProgram",
	"_MCGetDiscTitle",
	"_MCSetDiscTitle",
	"_MCDStartUp",
	"_MCDShutDown",
	"_MCGetFeatures",
	"_MCPlay",
	"_MCPause",
	"_MCSendRawData",
	"_MCGetStatus",
	"_MCControl",
	"_MCScan",
	"_MCGetSpeeds",
	"_MCSpeed",
	"_MCStopAt",
	"_MCJog",
	"_MCSearchTo",
	"_MCSearchDone",
	"_MCSearchWait",
	"_MCGetPosition",
	"_MCSetAudio",
	"_MCGetTimes",
	"_MCGetDiscTOC",
	"_MCGetDiscID",
	"_MCGetNoTracks",
	"_MCRecord",
	"_MCStop",
	"_MCWaitRawData",
	"_MCGetName",
	"_MCSetVolume",
	NULL
};

static char *tool_32[] =
{
	"",
	"_MaleBootInit",
	"_MaleStartUp",
	"_MaleShutDown",
	"_MaleVersion",
	"_MaleReset",
	"_MaleStatus",
	"",
	"",
	"_MaleSpeak",
	NULL
};

static char *tool_33[] = 
{
	"",
	"_FemaleBootInit",
	"_FemaleStartUp",
	"_FemaleShutDown",
	"_FemaleVersion",
	"_FemaleReset",
	"_FemaleStatus",
	"",
	"",
	"_FemaleSpeak",
	NULL
};

static char *tool_34[] =
{
	"",
	"_SpeechBootInit",
	"_SpeechStartUp",
	"_SpeechShutDown",
	"_SpeechVersion",
	"_SpeechReset",
	"_SpeechStatus",
	"",
	"",
	"_Parse",
	"_DictInsert",
	"_DictDelete",
	"_DictDump",
	"_SetSayGlobals",
	"_DictInit",
	"_Say",
	"_Activate", /* ? */
	NULL
};

static char *tool_ff[] =
{
	"",
	"",
	"",
	"",
	"_DebugVersion",
	"",
	"_DebugStatus",
	"",
	"",
	"_DebugStr",
	"_SetMileStone",
	"_DebugSetHook",
	"_DebugGetInfo",
	"_DebugControl",
	"_DebugQuery",
	NULL
};
const char *tool_call(int call, int set)
{
     
     switch (set)
     {
     case 0x01:
	  if (call < (sizeof (tool_1) / sizeof (char **))) 
	       return tool_1[call];
	  break;
	  
     case 0x02:
	  if (call < (sizeof (tool_2) / sizeof (char **))) 
	       return tool_2[call];
	  break;

     case 0x03:
	  if (call < (sizeof (tool_3) / sizeof (char **))) 
	       return tool_3[call];
	  break;

	case 0x04:
		if (call < (sizeof (tool_4) / sizeof (char **))) 
			return tool_4[call];
		break;

	case 0x05:
	  if (call < (sizeof (tool_5) / sizeof (char **))) 
	       return tool_5[call];
	  break;
	  
	case 0x06:
		if (call < (sizeof (tool_6) / sizeof (char **)))
			return tool_6[call];	

	case 0x07:
		if (call < (sizeof (tool_7) / sizeof (char **)))
			return tool_7[call];	

	case 0x08:
	  if (call < (sizeof (tool_8) / sizeof (char **))) 
	       return tool_8[call];
	  break;

	case 0x09:
	  if (call < (sizeof (tool_9) / sizeof (char **))) 
	       return tool_9[call];
	  break;

	case 0x0a:
	  if (call < (sizeof (tool_a) / sizeof (char **))) 
	       return tool_a[call];
	  break;
	  
     case 0x0b:
	  if (call < (sizeof (tool_b) / sizeof (char **))) 
	       return tool_b[call];
	  break;
	  
     case 0x0c:
	  if (call < (sizeof (tool_c) / sizeof (char **))) 
	       return tool_c[call];
	  break;
/* 0x0d: no such tool */
	case 0x0e:
		if (call < (sizeof (tool_e) / sizeof (char **)))
			return tool_e[call];
		break;
		
	case 0x0f:
		if (call < (sizeof (tool_f) / sizeof (char **)))
			return tool_f[call];
		break;
		
	case 0x10:
		if (call < (sizeof (tool_10) / sizeof (char **))) 
			return tool_10[call];
		break;

	case 0x11:
		if (call < (sizeof (tool_11) / sizeof (char **))) 
			return tool_11[call];
		break;

	case 0x12:
		if (call < (sizeof (tool_12) / sizeof (char **))) 
			return tool_12[call];
		break;
		
	case 0x13:
		if (call < (sizeof (tool_13) / sizeof (char **))) 
			return tool_13[call];
		break;
		
		
	case 0x14:
		if (call < (sizeof (tool_14) / sizeof (char **))) 
			return tool_14[call];
		break;
		
	case 0x15:
		if (call < (sizeof (tool_15) / sizeof (char **))) 
			return tool_15[call];
		break;
		
	case 0x16:
		if (call < (sizeof (tool_16)/ sizeof (char **)))
			return tool_16[call];
		break;

	case 0x17:
		if (call < (sizeof (tool_17)/ sizeof (char **)))
			return tool_17[call];
		break;
		
/* tool 0x18: no such beast */
	case 0x19:
		if (call < (sizeof (tool_19) /sizeof (char **)))
			return tool_19[call];
		break;

	case 0x1a:
		if (call < (sizeof (tool_1a) /sizeof (char **)))
			return tool_1a[call];
		break;

	case 0x1b:
		if (call < (sizeof (tool_1b) /sizeof (char **)))
			return tool_1b[call];
		break;

	case 0x1c:
		if (call < (sizeof (tool_1c)/ sizeof (char **)))
	       return tool_1c[call];
	  break;

	case 0x1d:
		if (call < (sizeof (tool_1d)/ sizeof (char **)))
	       return tool_1d[call];
	  break;

	case 0x1e:
		if (call < (sizeof (tool_1e)/ sizeof (char **)))
	       return tool_1e[call];
	  break;
/* tool $1f - no such thang */


	case 0x20:
		if (call < (sizeof (tool_20)/ sizeof (char **)))
	       return tool_20[call];
	  break;
	  
	case 0x21:
		if (call < (sizeof (tool_21) / sizeof (char **)))
	       return tool_21[call];
	  break;
	  
	case 0x22:
		if (call < (sizeof (tool_22) / sizeof (char **)))
	       return tool_22[call];
	  break;

	case 0x23:
		if (call < (sizeof (tool_23) / sizeof (char **)))
	       return tool_23[call];
	  break;
	  
	case 0x26:
		if (call < (sizeof (tool_26) / sizeof (char **)))
	       return tool_26[call];
	  break;

	case 0x32:
		if (call < (sizeof (tool_32) / sizeof (char **)))
	       return tool_32[call];
	  break;	  
	  
	  	case 0x33:
		if (call < (sizeof (tool_33) / sizeof (char **)))
		     return tool_33[call];
		break;
	  
     case 0x34:
	  if (call < (sizeof (tool_34) / sizeof (char **)))
	       return tool_34[call];
	  
	  break;
	case 0xff:
		if (call < (sizeof(tool_ff) / sizeof (char **)))
			return tool_ff[call];
			
			
     default:
	  return NULL;
	  
     }
     return NULL;

}


const char *gsos_call (int level, int call)
{

     static char * calls_gs[] = {
	  "",
	  "_CreateGS",	/* 2001 */
	  "_DestroyGS",
	  "_OSShutDownGS",
	  "_ChangePathGS",
	  "_SetFileInfoGS",
	  "_GetFileInfoGS",
	  "_JudgeNameGS",
	  "_VolumeGS",
	  "_SetPrefixGS",
	  "_GetPrefixGS",
	  "_ClearBackUpBitGS",
	  "_SetSysPrefsGS",
	  "_NullGS",
	  "_ExpandPathGS",
	  "_GetSysPrefsGS",
	  "_OpenGS",		/* 2010 */
	  "_NewLineGS",
	  "_ReadGS",
	  "_WriteGS",
	  "_CloseGS",
	  "_FlushGS",
	  "_SetMarkGS",
	  "_GetMarkGS",
	  "_SetEOFGS",
	  "_GetEOFGS",
	  "_SetLevelGS",
	  "_GetLevelGS",
	  "_GetDirEntryGS",
	  "_BeginSessionGS",
	  "_EndSessionGS",
	  "_SessionStatusGS",
	  "_GetDevNumberGS",		/* 2020 */
	  "",
	  "",
	  "",
	  "_FormatGS",
	  "_EraseDiskGS",
	  "_ResetCacheGS",
	  "_GetNameGS",
	  "_GetBootVolGS",
	  "_QuitGS",
	  "_GetVersionGS",
	  "_GetFSTInfoGS",
	  "_DInfoGS",
	  "_DStatusGS",
	  "_DControlGS",
	  "_DReadGS",
	  "_DWriteGS",				/* 2030 */
	  "_BindIntGS",
	  "_UnBindIntGS",
	  "_FSTSpecific",
	  "_AddNotifyProcGS",
	  "_DelNotifyProcGS",
	  "_DRenameGS",
	  "_GetStdRefNumGS",
	  "_GetRefNumGS",
	  "_GetRefInfoGS",
	  "_SetStdRefNumGS",
	  NULL
     };	


     static char * calls_p16[] = {
	  "",
	  "_CREATE_P16",
	  "_DESTROY_P16",
	  "",
	  "_CHANGE_PATH_P16",
	  "_SET_FILE_INFO_P16",
	  "_GET_FILE_INFO_P16",
	  "",
	  "_VOLUME_P16",
	  "_SET_PREFIX_P16",
	  "_GET_PREFIX_P16",
	  "_CLEAR_BACKUP_BIT_P16",
	  "",
	  "",
	  "",
	  "",
	  "_OPEN_P16",			/* $10 */
	  "_NEWLINE_P16",
	  "_READ_P16",
	  "_WRITE_P16",
	  "_CLOSE_P16",
	  "_FLUSH_P16",
	  "_SET_MARK_P16",
	  "_GET_MARK_P16",
	  "_SET_EOF_P16",
	  "_GET_EOF_P16",
	  "_SET_LEVEL_P16",
	  "_GET_LEVEL_P16",
	  "_GET_DIR_ENTRY_P16",
	  "",
	  "",
	  "",
	  "_GET_DEV_NUM_P16",		/* $20 */
	  "_GET_LAST_DEV_P16",
	  "_READ_BLOCK_P16",
	  "_WRITE_BLOCK_P16",
	  "_FORMAT_P16",
	  "_ERASE_DISK_P16",
	  "",
	  "_GET_NAME_P16",
	  "_GET_BOOT_VOL_P16",
	  "_QUIT_P16",
	  "_GET_VERSION_P16",
	  "",
	  "_D_INFO_P16",			/* 2c */
	  "",
	  "",
	  "",
	  "",						/* 30 */
	  "_ALLOC_INTERRUPT_P16",
	  "_DEALLOC_INTERRUPT_P16",	
	  NULL
     };
	

     if (level == 0x20)
     {
	  if (call < (sizeof (calls_gs) / sizeof (char **)))
	       return calls_gs[call]; 	
     }
     else if (level == 0)
     {
	  if (call < (sizeof (calls_p16) / sizeof (char **)))
	       return calls_p16[call]; 
	
     }
     else return NULL;

}



void angie1 (int opcode, union w_b arg, long PC)
{
     printf ("%.2x %.2x\t\t", opcode, b0 (arg));
     putchar ('\'');
     putchar (isprint(opcode) ? opcode : '.');
     putchar (isprint(b0 (arg)) ? b0 (arg) : '.');
     putchar ('\'');
     printf ("\t%lx\n", PC);
}

void angie0 (int opcode, long PC)
{
     printf ("%.2x\t\t", opcode);
     putchar ('\'');
     putchar (isprint(opcode) ? opcode : '.');
     putchar ('\'');
     printf ("\t%lx\n", PC);
}





void angie2 (int opcode, union w_b arg, long PC)
{
     printf ("%.2x %.2x %.2x\t", opcode, b0 (arg), b1 (arg));
     putchar ('\'');
     putchar (isprint (opcode) ? opcode : '.');
     putchar (isprint (b0 (arg)) ? b0 (arg) : '.');
     putchar (isprint (b1 (arg)) ? b1 (arg) : '.');
     putchar ('\'');
     printf ("\t%lx\n", PC);
}

void angie3 (int opcode, union w_b arg, long PC)
{
     printf ("%.2x %.2x %.2x %.2x\t", opcode, 
	     b0 (arg), b1 (arg), b2 (arg));
     putchar ('\'');
     putchar (isprint (opcode) ? opcode : '.');
     putchar (isprint (b0 (arg)) ? b0 (arg) : '.');
     putchar (isprint (b1 (arg)) ? b1 (arg) : '.');
     putchar (isprint (b2 (arg)) ? b2 (arg) : '.');
     putchar ('\'');
     printf ("\t%lx\n", PC);
}



void help(void)
{
     fprintf(stderr, "d65816 0.10 by Kelvin W. Sherlock\n");
     fprintf(stderr, "usage: d65816 [options] file\n");
     fprintf(stderr, "options\n");
     fprintf(stderr, "\t-O            OMF support (NYI)\n");
     fprintf(stderr, "\t-T [1|0]      enable/disable Tool recognition\n");
     fprintf(stderr, "\t-G [1|0]      enable/disable GS/OS recognition\n");
     fprintf(stderr, "\t-P [1|0]      enable/disable P8 recognition\n");
     fprintf(stderr, "\t-o <number>   set origin\n");
     fprintf(stderr, "\t-x [1|0]      set index register length\n");
     fprintf(stderr, "\t-m [1|0]      set accumulator length\n");
     fprintf(stderr, "\t-e [1|0]      set emulation bit\n");
     fprintf(stderr, "\t-f <number>   offset into file\n");
     fprintf(stderr, "\t-l <number>   disassemble <number> bytes only\n");
}

struct info
{
	int address;
	char *desc;
};
/* returns a description of the address, if applicable */
char *describe(union w_b arg)
{
static struct info e1[] =
{
	{0x0000, "DISPATCH1"},
	{0x0004, "DISPATCH2"},
	{0x0008, "UDISPATCH1"},
	{0x000C, "UDISPATCH2"},
	{0x0010, "INTMGRV"},
	{0x0014, "COPMGRV"},
	{0x0018, "ABORTMGRV"},
	{0x001C, "SYSDMGRV"},
	{0x0020, "IRQ_APTALK"},
	{0x0024, "IRQ_SERIAL"},
	{0x0028, "IRQ_SCAN"},
	{0x002C, "IRQ_SOUND"},
	{0x0030, "IRQ_VBL"},
	{0x0034, "IRQ_MOUSE"},
	{0x0038, "IRQ_QTR"},
	{0x003C, "IRQ_KBD"},
	{0x0040, "IRQ_RESPONSE"},
	{0x0044, "IRQ_SRQ"},
	{0x0048, "IRQ_DSKACC"},
	{0x004C, "IRQ_Flush"},
	{0x0050, "IRQ_MICRO"},
	{0x0054, "IRQ_1SEC"},
	{0x0058, "IRQ_EXT"},
	{0x005C, "IRQ_OTHER"},

	{0x0064, "IncBusy"},
	{0x0068, "DecBusy"},
	{0x00bc, "OS_KIND"},
	{0x00bd, "OS_BOOT"},
	{0x0200, "MOVE_INFO"},
	{0x0204, "SET_SYS_SPEED"},
	{0x0208, "DYN_SLOT_ARBITER"},
	{0x9d00, "SCBs"},
	NULL
}; 

int i;

	
	switch (b2(arg))
	{
	case 0xe1:
	     for (i=0; i < sizeof (e1) / sizeof (struct info); i++)
		  if (e1[i].address == s0(arg)) 
		       return e1[i].desc;
		  else if (e1[i].address > s0(arg))
		       return NULL; 
		
	default: return NULL;
	}
}


/*

in: const char *number
out: integer


converts a string (in hex, octal, or base 10) to an integer

returns 0 on error (eg - bad string)

0xnn	= hex
$nn		= hex
0nn		= octal
nn		= decimal (base 10)


*/
int extract (const char *value)
{
int tmp;
	
	if (value == (char *)0 || *value == (char)0)
		tmp = 0;
		
	else if (*value == '$')
			sscanf(value+1, "%x", &tmp);
	else if (*value == '0')
	{
		if (value[1] == 'x')
			sscanf(value+2, "%x", &tmp);
		else
			sscanf(value+1, "%o", &tmp);
	}
	else if (isdigit(*value))
		sscanf(value, "%d", &tmp);
	else tmp = 0;
	 	
	return tmp;
	
}


const char * p8_call (int num)
{
static struct info p8[] =
{
	{0x0040, "ALLOC_INTERRUPT_P8"},
	{0x0041, "DEALLOC_INTERRUPT_P8"},
	{0x0042, "AppleTalk_P8"},
	{0x0043, "SpecialOpenFork_P8"},
	{0x0044, "ByteRangeLock_P8"},
	{0x0065, "QUIT_P8"},
	{0x0080, "READ_BLOCK_P8"},
	{0x0081, "WRITE_BLOCK_P8"},
	{0x0082, "GET_TIME_P8"},
	{0x00C0, "CREATE_P8"},
	{0x00C1, "DESTROY_P8"},
	{0x00C2, "RENAME_P8"},
	{0x00C3, "SetFileInfo_P8"},
	{0x00C4, "GetFileInfo_P8"},
	{0x00C5, "ONLINE_P8"},
	{0x00C6, "SET_PREFIX_P8"},
	{0x00C7, "GET_PREFIX_P8"},
	{0x00C8, "OPEN_P8"},
	{0x00C9, "NEWLINE_P8"},
	{0x00CA, "READ_P8"},
	{0x00CB, "WRITE_P8"},
	{0x00CC, "CLOSE_P8"},
	{0x00CD, "FLUSH_P8"},
	{0x00CE, "SET_MARK_P8"},
	{0x00CF, "GET_MARK_P8"},
	{0x00D0, "SET_EOF_P8"},
	{0x00D1, "GET_EOF_P8"},
	{0x00D2, "SET_BUF_P8"},
	{0x00D3, "GET_BUF_P8"},
	NULL
};

int i;

	for (i = 0; i < sizeof (p8); i++)
		if (p8[i].address == num)
			return p8[i].desc;
		else if (p8[i].address > num) return NULL;
} 
