# Startup file for Apple IIgs environment (Apple IIgs version 0.4.3b)
# See the documentation for a description of internally defined macros.
#
# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT := $(.SILENT)
.SILENT   := yes

# Configuration parameters for DMAKE startup.mk file
# Set these to NON-NULL if you wish to turn the parameter on.
_HAVE_RCS       :=              # yes => RCS  is installed.
_HAVE_SCCS      :=              # yes => SCCS is installed.

# Applicable suffix definitions
A := .lib       # Libraries
E :=            # Executables
F := .f         # Fortran
O := .o         # Objects
P := .p         # Pascal
S := .s         # Assembler sources
V := ,v         # RCS suffix

# Recipe execution configuration 
SHELL           :=  /bin/gsh
#SHELL          :=  #/bin/sh
#SHELLFLAGS     := -ce
GROUPSHELL      := $(SHELL)
GROUPFLAGS      := 
# SHELLMETAS    := |();&<>?*][$$:\\#`'" # original
SHELLMETAS      := |;&<>?*][$$\\'"~^    # for gsh
GROUPSUFFIX     :=
DIVFILE          = $(TMPFILE)

# Standard C-language command names and flags
   #CPP       := #/lib/cpp       # C-preprocessor
   CPP       := /usr/bin/cpp    # C-preprocessor
   CC        := 17/occ          # C-compiler and flags
   MAINFLAGS += -i              #    flags for file that has main()
   VAFLAGS   += -i -O8          #    flags for files that use variable
                                #      argument lists.  You may want -r, too.
   CFLAGS    += -i              #    flags for other objects.  You may want
                                #      -r, too.

# added flags for forcing .a and .o files
# Note that this will screw up with the rules for object files if
# you change $(CC) or $(AS)!!
__AFLAG = -a1
__OFLAG = -a0

   AS      := $(CC)     #as     # Assembler and flags
   ASFLAGS += -c

   LD       = $(CC)             # Loader and flags
   LDFLAGS +=
   LDLIBS   =

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Definition of Print command for this system.
   PRINT = lpr

# Language and Parser generation Tools and their flags
   YACC   := bison              # !standard yacc
   YFLAGS += -y
   YTAB   := y.tab              # yacc output files name stem.

   LEX    := flex               # !standard lex
   LFLAGS +=
   LEXYY  := lex.yy             # lex output file

# Other Compilers, Tools and their flags
   PC   := compile      #pc     # pascal compiler
   PCFLAGS += -E -P
   RC   := #f77                 # ratfor compiler
   FC   := #f77                 # fortran compiler
   REZ  := 17/occ               # resource compiler (we should use rc(1))
   REZFLAGS +=

   CATREZ := /usr/bin/catrez	# used for copying resource forks

   CO      := co                # check out for RCS
   COFLAGS += -q

   AR     := makelib    #ar     # archiver
   ARFLAGS+= #ruv

   RM      := /bin/cp -p rm     # remove a file command
   RMFLAGS +=

   CP      := /bin/cp           # copy files command
   CPFLAGS += -f

   MV      := /bin/cp -p mv     # move files command
   MVFLAGS +=

# Implicit generation rules for making inferences.
# We don't provide .yr or .ye rules here.  They're obsolete.
# Rules for making *$O
# Note that $(__OFLAG) is an 'occ' thing and that the rules for pascal
# files will not really work since '.a' is generated by compile.
   %$O : %.c ; $(CC) -o $@ $(CFLAGS) $(__OFLAG) -c $<
   %$O : %.cc ; $(CC) -o $@ $(CFLAGS) $(__OFLAG) -c $<
#  This is a bit of a kludge since there is no pc(1) yet.
   %$O : %$P ; $(PC) -o $@ $(PFLAGS) $< keep=$* ; $(MV) $*.a $*.o
   %$O : %$S ; $(AS) -o $@ $(ASFLAGS) $(__OFLAG) $<
   %$O : %.asm ; $(AS) -o $@ $(ASFLAGS) $(__OFLAG) $<
#  %$O : %.cl ; class -c $<
#  %$O : %.e %.r %.F %$F
#       $(FC) $(RFLAGS) $(EFLAGS) $(FFLAGS) -c $<

# We have two more suffixes for object files, so the above stuff
# is repeated for them.
# Object files ending in '.a': Force '.a' with occ

   %.a : %.c ; $(CC) -o $@ $(CFLAGS) $(__AFLAG) -c $<
   %.a : %.cc ; $(CC) -o $@ $(CFLAGS) $(__AFLAG) -c $<
   %.a : %$P ; $(PC) -o $@ $(PFLAGS) $< keep=$*
   %.a : %$S ; $(AS) -o $@ $(ASFLAGS) $(__AFLAG) $<
   %.a : %.asm ; $(AS) -o $@ $(ASFLAGS) $(__AFLAG) $<

# Object files ending in '.root': Force neither '.a' nor '.o'
# Note that since we don't specify the output file name, this set of
# rules may not work well if the object file directory is different
# from the source file hierarchy.

   %.root : %.c ; $(CC) $(CFLAGS) -c $<
   %.root : %.cc ; $(CC) $(CFLAGS) -c $<
   %.root : %$P ; $(PC) $(PFLAGS) $< keep=$*
   %.root : %$S ; $(AS) $(ASFLAGS) $<
   %.root : %.asm ; $(AS) $(ASFLAGS) $<

# Resource descriptions in REZ format
   %.r : %.rez ; $(REZ) -o $@ -c $(REZFLAGS) $<

# Executables
   %$E : %$O ; $(LD) $(LDFLAGS) -o $@ $< $(LDLIBS)

# lex and yacc rules
   %.c : %.y ; $(YACC)  $(YFLAGS) $<; mv $(YTAB).c $@
   %.c : %.l ; $(LEX)   $(LFLAGS) $<; mv $(LEXYY).c $@

# This rule tells how to make *.out from it's immediate list of prerequisites
# UNIX only.
   %.out :; $(LD) $(LDFLAGS) -o $@ $^ $(LDLIBS)

# RCS support
.IF $(_HAVE_RCS)
   % : %$V $$(@:d)RCS/$$(@:f)$V;- $(CO) $(COFLAGS) $@
   .NOINFER : %$V $$(@:d)RCS/$$(@:f)$V
.END

# SCCS support
.IF $(_HAVE_SCCS)
   % : s.% ; get $<
   .NOINFER : s.%
.END

# Recipe to make archive files.
%$A : ; @echo "dmake has no default rule for libraries"
#[
#   $(AR) $(ARFLAGS) $@ $?
#   $(RM) $(RMFLAGS) $?
#   ranlib $@
#]

# DMAKE uses this recipe to remove intermediate targets
#	IIgs version note:  DON'T put these on the same line while the
#	Gno kernel still has the sub-shell bug.  (See readme/apple.IIgs.)
.REMOVE :
	/usr/local/bin/rmroot $<
	$(RM) -f $<

# AUGMAKE extensions for SYSV compatibility
@B = $(@:b)
@D = $(@:d)
@F = $(@:f)
"*B" = $(*:b)
"*D" = $(*:d)
"*F" = $(*:f)
<B = $(<:b)
<D = $(<:d)
<F = $(<:f)
?B = $(?:b)
?F = $(?:f)
?D = $(?:d)

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# Local startup file if any
#
# GNO: was "_startup.mk" 
.INCLUDE .IGNORE: "startup.mk"
