
#ifndef INCLUDED_EM65_H
#define INCLUDED_EM65_H

#define PIPE_READ  0
#define PIPE_WRITE 1

#define MAX_NUM_DEVICES 16

#define TERMINAL_IN_INDEX   0
#define TERMINAL_OUT_INDEX  1
#define DISK_INDEX          2
#define CLOCK_INDEX         3

#define NUM_DEVICES         4

#define assert_interrupt( which_device, which_interrupt ) \
    IPC_vars->device_interrupt[ (which_device) ] |= (which_interrupt)

#define clear_interrupt( which_device, which_interrupt ) \
    IPC_vars->device_interrupt[ (which_device) ] &= ~(which_interrupt)

typedef struct
{
    int device_interrupt[ MAX_NUM_DEVICES ];
    int terminal_status;
    int disk_status;

} IPC_space;

extern IPC_space *IPC_vars;
extern int *interrupt_ptr;
extern int *last_interrupt;

extern unsigned long num_instructions;
extern unsigned long num_ticks;

extern char *em65_version_string;
extern char *em65_copyright_string;
extern char *em65_author_string;
extern char *em65_email_string;

/* set to quit the program (break the 65c02 execution loop) */
extern short quitting;

extern short num_devices;

extern short got_sigint;
/* SIGINT has been caught, stop running or tracing and begin stepping */

int nb_getchar( void );

#endif /* #ifndef INCLUDED_EM65_H */

