
#include "em65types.h"
#include "instructions.h"

/* instruction decode tables */

ifunc binary_instruction_table[ 256 ] = {

i00_BRK, i01_ORA,        iEA_NOP,        iEA_NOP, i04_TSB, i05_ORA,        i06_ASL, iEA_NOP,
i08_PHP, i09_ORA,        i0A_ASL,        iEA_NOP, i0C_TSB, i0D_ORA,        i0E_ASL, iEA_NOP,
i10_BPL, i11_ORA,        i12_ORA,        iEA_NOP, i14_TRB, i15_ORA,        i16_ASL, iEA_NOP,
i18_CLC, i19_ORA,        i1A_INC,        iEA_NOP, i1C_TRB, i1D_ORA,        i1E_ASL, iEA_NOP,
i20_JSR, i21_AND,        iEA_NOP,        iEA_NOP, i24_BIT, i25_AND,        i26_ROL, iEA_NOP,
i28_PLP, i29_AND,        i2A_ROL,        iEA_NOP, i2C_BIT, i2D_AND,        i2E_ROL, iEA_NOP,
i30_BMI, i31_AND,        i32_AND,        iEA_NOP, i34_BIT, i35_AND,        i36_ROL, iEA_NOP,
i38_SEC, i39_AND,        i3A_DEC,        iEA_NOP, i3C_BIT, i3D_AND,        i3E_ROL, iEA_NOP,
i40_RTI, i41_EOR,        iEA_NOP,        iEA_NOP, iEA_NOP, i45_EOR,        i46_LSR, iEA_NOP,
i48_PHA, i49_EOR,        i4A_LSR,        iEA_NOP, i4C_JMP, i4D_EOR,        i4E_LSR, iEA_NOP,
i50_BVC, i51_EOR,        i52_EOR,        iEA_NOP, iEA_NOP, i55_EOR,        i56_LSR, iEA_NOP,
i58_CLI, i59_EOR,        i5A_PHY,        iEA_NOP, iEA_NOP, i5D_EOR,        i5E_LSR, iEA_NOP,
i60_RTS, i61_ADC_binary, iEA_NOP,        iEA_NOP, i64_STZ, i65_ADC_binary, i66_ROR, iEA_NOP,
i68_PLA, i69_ADC_binary, i6A_ROR,        iEA_NOP, i6C_JMP, i6D_ADC_binary, i6E_ROR, iEA_NOP,
i70_BVS, i71_ADC_binary, i72_ADC_binary, iEA_NOP, i74_STZ, i75_ADC_binary, i76_ROR, iEA_NOP,
i78_SEI, i79_ADC_binary, i7A_PLY,        iEA_NOP, i7C_JMP, i7D_ADC_binary, i7E_ROR, iEA_NOP,
i80_BRA, i81_STA,        iEA_NOP,        iEA_NOP, i84_STY, i85_STA,        i86_STX, iEA_NOP,
i88_DEC, i89_BIT,        i8A_TXA,        iEA_NOP, i8C_STY, i8D_STA,        i8E_STX, iEA_NOP,
i90_BCC, i91_STA,        i92_STA,        iEA_NOP, i94_STY, i95_STA,        i96_STX, iEA_NOP,
i98_TYA, i99_STA,        i9A_TXS,        iEA_NOP, i9C_STZ, i9D_STA,        i9E_STZ, iEA_NOP,
iA0_LDY, iA1_LDA,        iA2_LDX,        iEA_NOP, iA4_LDY, iA5_LDA,        iA6_LDX, iEA_NOP,
iA8_TAY, iA9_LDA,        iAA_TAX,        iEA_NOP, iAC_LDY, iAD_LDA,        iAE_LDX, iEA_NOP,
iB0_BCS, iB1_LDA,        iB2_LDA,        iEA_NOP, iB4_LDY, iB5_LDA,        iB6_LDX, iEA_NOP,
iB8_CLV, iB9_LDA,        iBA_TSX,        iEA_NOP, iBC_LDY, iBD_LDA,        iBE_LDX, iEA_NOP,
iC0_CPY, iC1_CMP,        iEA_NOP,        iEA_NOP, iC4_CPY, iC5_CMP,        iC6_DEC, iEA_NOP,
iC8_INC, iC9_CMP,        iCA_DEC,        iEA_NOP, iCC_CPY, iCD_CMP,        iCE_DEC, iEA_NOP,
iD0_BNE, iD1_CMP,        iD2_CMP,        iEA_NOP, iEA_NOP, iD5_CMP,        iD6_DEC, iEA_NOP,
iD8_CLD, iD9_CMP,        iDA_PHX,        iEA_NOP, iEA_NOP, iDD_CMP,        iDE_DEC, iEA_NOP,
iE0_CPX, iE1_SBC_binary, iEA_NOP,        iEA_NOP, iE4_CPX, iE5_SBC_binary, iE6_INC, iEA_NOP,
iE8_INC, iE9_SBC_binary, iEA_NOP,        iEA_NOP, iEC_CPX, iED_SBC_binary, iEE_INC, iEA_NOP,
iF0_BEQ, iF1_SBC_binary, iF2_SBC_binary, iEA_NOP, iEA_NOP, iF5_SBC_binary, iF6_INC, iEA_NOP,
iF8_SED, iF9_SBC_binary, iFA_PLX,        iEA_NOP, iEA_NOP, iFD_SBC_binary, iFE_INC, iEA_NOP

};

ifunc decimal_instruction_table[ 256 ] = {

i00_BRK, i01_ORA,         iEA_NOP,         iEA_NOP, i04_TSB, i05_ORA,         i06_ASL, iEA_NOP,
i08_PHP, i09_ORA,         i0A_ASL,         iEA_NOP, i0C_TSB, i0D_ORA,         i0E_ASL, iEA_NOP,
i10_BPL, i11_ORA,         i12_ORA,         iEA_NOP, i14_TRB, i15_ORA,         i16_ASL, iEA_NOP,
i18_CLC, i19_ORA,         i1A_INC,         iEA_NOP, i1C_TRB, i1D_ORA,         i1E_ASL, iEA_NOP,
i20_JSR, i21_AND,         iEA_NOP,         iEA_NOP, i24_BIT, i25_AND,         i26_ROL, iEA_NOP,
i28_PLP, i29_AND,         i2A_ROL,         iEA_NOP, i2C_BIT, i2D_AND,         i2E_ROL, iEA_NOP,
i30_BMI, i31_AND,         i32_AND,         iEA_NOP, i34_BIT, i35_AND,         i36_ROL, iEA_NOP,
i38_SEC, i39_AND,         i3A_DEC,         iEA_NOP, i3C_BIT, i3D_AND,         i3E_ROL, iEA_NOP,
i40_RTI, i41_EOR,         iEA_NOP,         iEA_NOP, iEA_NOP, i45_EOR,         i46_LSR, iEA_NOP,
i48_PHA, i49_EOR,         i4A_LSR,         iEA_NOP, i4C_JMP, i4D_EOR,         i4E_LSR, iEA_NOP,
i50_BVC, i51_EOR,         i52_EOR,         iEA_NOP, iEA_NOP, i55_EOR,         i56_LSR, iEA_NOP,
i58_CLI, i59_EOR,         i5A_PHY,         iEA_NOP, iEA_NOP, i5D_EOR,         i5E_LSR, iEA_NOP,
i60_RTS, i61_ADC_decimal, iEA_NOP,         iEA_NOP, i64_STZ, i65_ADC_decimal, i66_ROR, iEA_NOP,
i68_PLA, i69_ADC_decimal, i6A_ROR,         iEA_NOP, i6C_JMP, i6D_ADC_decimal, i6E_ROR, iEA_NOP,
i70_BVS, i71_ADC_decimal, i72_ADC_decimal, iEA_NOP, i74_STZ, i75_ADC_decimal, i76_ROR, iEA_NOP,
i78_SEI, i79_ADC_decimal, i7A_PLY,         iEA_NOP, i7C_JMP, i7D_ADC_decimal, i7E_ROR, iEA_NOP,
i80_BRA, i81_STA,         iEA_NOP,         iEA_NOP, i84_STY, i85_STA,         i86_STX, iEA_NOP,
i88_DEC, i89_BIT,         i8A_TXA,         iEA_NOP, i8C_STY, i8D_STA,         i8E_STX, iEA_NOP,
i90_BCC, i91_STA,         i92_STA,         iEA_NOP, i94_STY, i95_STA,         i96_STX, iEA_NOP,
i98_TYA, i99_STA,         i9A_TXS,         iEA_NOP, i9C_STZ, i9D_STA,         i9E_STZ, iEA_NOP,
iA0_LDY, iA1_LDA,         iA2_LDX,         iEA_NOP, iA4_LDY, iA5_LDA,         iA6_LDX, iEA_NOP,
iA8_TAY, iA9_LDA,         iAA_TAX,         iEA_NOP, iAC_LDY, iAD_LDA,         iAE_LDX, iEA_NOP,
iB0_BCS, iB1_LDA,         iB2_LDA,         iEA_NOP, iB4_LDY, iB5_LDA,         iB6_LDX, iEA_NOP,
iB8_CLV, iB9_LDA,         iBA_TSX,         iEA_NOP, iBC_LDY, iBD_LDA,         iBE_LDX, iEA_NOP,
iC0_CPY, iC1_CMP,         iEA_NOP,         iEA_NOP, iC4_CPY, iC5_CMP,         iC6_DEC, iEA_NOP,
iC8_INC, iC9_CMP,         iCA_DEC,         iEA_NOP, iCC_CPY, iCD_CMP,         iCE_DEC, iEA_NOP,
iD0_BNE, iD1_CMP,         iD2_CMP,         iEA_NOP, iEA_NOP, iD5_CMP,         iD6_DEC, iEA_NOP,
iD8_CLD, iD9_CMP,         iDA_PHX,         iEA_NOP, iEA_NOP, iDD_CMP,         iDE_DEC, iEA_NOP,
iE0_CPX, iE1_SBC_decimal, iEA_NOP,         iEA_NOP, iE4_CPX, iE5_SBC_decimal, iE6_INC, iEA_NOP,
iE8_INC, iE9_SBC_decimal, iEA_NOP,         iEA_NOP, iEC_CPX, iED_SBC_decimal, iEE_INC, iEA_NOP,
iF0_BEQ, iF1_SBC_decimal, iF2_SBC_decimal, iEA_NOP, iEA_NOP, iF5_SBC_decimal, iF6_INC, iEA_NOP,
iF8_SED, iF9_SBC_decimal, iFA_PLX,         iEA_NOP, iEA_NOP, iFD_SBC_decimal, iFE_INC, iEA_NOP

};

ifunc *instruction_table = binary_instruction_table;

/* memory mapped I/O function tables */

wfunc io_write[ 256 ] = {

iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,
iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop,    iow_nop

};

rfunc io_read[ 256 ] = {

ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,
ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop,    ior_nop

};

void install_iow( wfunc wf, int i )
{
    io_write[ i ] = wf;
}

void install_ior( rfunc rf, int i )
{
    io_read[ i ] = rf;
}

/* debugger disassembler tables */

char instruction_size[ 256 ] = {

1, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,
3, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,

1, 2, 0, 0, 0, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 0, 2, 2, 0, 1, 3, 1, 0, 0, 3, 3, 0,
1, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,

2, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 2, 2, 2, 0, 1, 3, 1, 0, 3, 3, 3, 0,

2, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 0, 2, 2, 0, 1, 3, 1, 0, 0, 3, 3, 0,
2, 2, 0, 0, 2, 2, 2, 0, 1, 2, 1, 0, 3, 3, 3, 0,
2, 2, 2, 0, 0, 2, 2, 0, 1, 3, 1, 0, 0, 3, 3, 0

};

char instruction_is_branch[ 256 ] = {

0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

};

char instruction_is_immediate[ 256 ] = {

0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

0, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
1, 0, 1, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,

1, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,
1, 0, 0, 0,  0, 0, 0, 0,  0, 1, 0, 0,  0, 0, 0, 0,
0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0

};

char *standard_instruction_strings[ 256 ] = {

/* 0 */

"brk",
"ora  ($%2.2X,X)",
"",
"",
"tsb  $%2.2X",
"ora  $%2.2X",
"asl  $%2.2X",
"",
"php",
"ora  #$%2.2X",
"asl  A",
"",
"tsb  $%4.4X",
"ora  $%4.4X",
"asl  $%4.4X",
"",

/* 1 */

"bpl  %+d",
"ora  ($%2.2X),Y",
"ora  ($%2.2X)",
"",
"trb  $%2.2X",
"ora  $%2.2X,X",
"asl  $%2.2X,X",
"",
"clc",
"ora  $%4.4X,Y",
"inc  A",
"",
"trb  $%4.4X",
"trb  $%4.4X,X",
"trb  $%4.4X,X",
"",

/* 2 */

"jsr  $%4.4X",
"and  ($%2.2X,X)",
"",
"",
"bit  $%2.2X",
"and  $%2.2X",
"rol  $%2.2X",
"",
"plp",
"and  #$%2.2X",
"rol  A",
"",
"bit  $%4.4X",
"and  $%4.4X",
"rol  $%4.4X",
"",

/* 3 */

"bmi  %+d",
"and  ($%2.2X),Y",
"and  ($%2.2X)",
"",
"bit  $%2.2X,X",
"and  $%2.2X,X",
"rol  $%2.2X,X",
"",
"sec",
"and  $%4.4X,Y",
"dec  A",
"",
"bit  $%4.4X,X",
"and  $%4.4X,X",
"rol  $%4.4X,X",
"",

/* 4 */

"rti",
"eor  ($%2.2X,X)",
"",
"",
"",
"eor  $%2.2X",
"lsr  $%2.2X",
"",
"pha",
"eor  #$%2.2X",
"lsr  A",
"",
"jmp  $%4.4X",
"eor  $%4.4X",
"lsr  $%4.4X",
"",

/* 5 */

"bvc  %+d",
"eor  ($%2.2X),Y",
"eor  ($%2.2X)",
"",
"",
"eor  $%2.2X,X",
"lsr  $%2.2X,X",
"",
"cli",
"eor  $%4.4X,Y",
"phy",
"",
"",
"eor  $%4.4X,X",
"lsr  $%4.4X,X",
"",

/* 6 */

"rts",
"adc  ($%2.2X,X)",
"",
"",
"stz  $%2.2X",
"adc  $%2.2X",
"ror  $%2.2X",
"",
"pla",
"adc  #$%2.2X",
"ror  A",
"",
"jmp  ($%4.4X)",
"adc  $%4.4X",
"ror  $%4.4X",
"",

/* 7 */

"bvs  %+d",
"adc  ($%2.2X),Y",
"adc  ($%2.2X)",
"",
"stz  $%2.2X,X",
"adc  $%2.2X,X",
"ror  $%2.2X,X",
"",
"sei",
"adc  $%4.4X,Y",
"ply",
"",
"jmp  ($%4.4X,X)",
"adc  $%4.4X,X",
"ror  $%4.4X,X",
"",

/* 8 */

"bra  %+d",
"sta  ($%2.2X,X)",
"",
"",
"sty  $%2.2X",
"sta  $%2.2X",
"stx  $%2.2X",
"",
"dey",
"bit  #$%2.2X",
"txa",
"",
"sty  $%4.4X",
"sta  $%4.4X",
"stx  $%4.4X",
"",

/* 9 */

"bcc  %+d",
"sta  ($%2.2X),Y",
"sta  ($%2.2X)",
"",
"sty  $%2.2X,X",
"sta  $%2.2X,X",
"stx  $%2.2X,Y",
"",
"tya",
"sta  $%4.4X,X",
"txs",
"",
"stz  $%4.4X",
"sta  $%4.4X,X",
"stz  $%4.4X,X",
"",

/* A */

"ldy  #$%2.2X",
"lda  ($%2.2X,X)",
"ldx  #$%2.2X",
"",
"ldy  $%2.2X",
"lda  $%2.2X",
"ldx  $%2.2X",
"",
"tay",
"lda  #$%2.2X",
"tax",
"",
"ldy  $%4.4X",
"lda  $%4.4X",
"ldx  $%4.4X",
"",

/* B */

"bcs  %+d",
"lda  ($%2.2X),Y",
"lda  ($%2.2X)",
"",
"ldy  $%2.2X,X",
"lda  $%2.2X,X",
"ldx  $%2.2X,Y",
"",
"clv",
"lda  $%4.4X,Y",
"tsx",
"",
"ldy  $%4.4X,X",
"lda  $%4.4X,X",
"ldx  $%4.4X,Y",
"",

/* C */

"cpy  #$%2.2X",
"cmp  ($%2.2X,X)",
"",
"",
"cpy  $%2.2X",
"cmp  $%2.2X",
"dec  $%2.2X",
"",
"iny",
"cmp  #$%2.2X",
"dex",
"",
"cpy  $%4.4X",
"cmp  $%4.4X",
"dec  $%4.4X",
"",

/* D */

"bne  %+d",
"cmp  ($%2.2X),Y",
"cmp  ($%2.2X)",
"",
"",
"cmp  $%2.2X,X",
"dec  $%2.2X,X",
"",
"cld",
"cmp  $%4.4X,Y",
"phx",
"",
"",
"cmp  $%4.4X,X",
"dec  $%4.4X,X",
"",

/* E */

"cpx  #$%2.2X",
"sbc  ($%2.2X,X)",
"",
"",
"cpx  $%2.2X",
"sbc  $%2.2X",
"inc  $%2.2X",
"",
"inx",
"sbc  #$%2.2X",
"nop",
"",
"cpx  $%4.4X",
"sbc  $%4.4X",
"inc  $%4.4X",
"",

/* F */

"beq  %+d",
"sbc  ($%2.2X),Y",
"sbc  ($%2.2X)",
"",
"",
"sbc  $%2.2X,X",
"inc  $%2.2X,X",
"",
"sed",
"sbc  $%4.4X,Y",
"plx",
"",
"",
"sbc  $%4.4X,X",
"inc  $%4.4X,X",
""
};

char *orthogonal_instruction_strings[ 256 ] = {

/* 0 */

"brk",
"or   ($%2.2X+X)",
"",
"",
"tsb  $%2.2X",
"or   $%2.2X",
"shl  $%2.2X",
"",
"psh  P",
"or   #$%2.2X",
"shl  A",
"",
"tsb  $%4.4X",
"or   $%4.4X",
"shl  $%4.4X",
"",

/* 1 */

"bnc  %+d",
"or   ($%2.2X)+Y",
"or   ($%2.2X)",
"",
"trb  $%2.2X",
"or   $%2.2X+X",
"shl  $%2.2X+X",
"",
"clr  C",
"or   $%4.4X+Y",
"inc  A",
"",
"trb  $%4.4X",
"or   $%4.4X+X",
"shl  $%4.4X+X",
"",

/* 2 */

"jsr  $%4.4X",
"and  ($%2.2X+X)",
"",
"",
"bit  $%2.2X",
"and  $%2.2X",
"rol  $%2.2X",
"",
"pul  P",
"and  #$%2.2X",
"rol  A",
"",
"bit  $%4.4X",
"and  $%4.4X",
"rol  $%4.4X",
"",

/* 3 */

"bns  %+d",
"and  ($%2.2X)+Y",
"and  ($%2.2X)",
"",
"bit  $%2.2X+X",
"and  $%2.2X+X",
"rol  $%2.2X+X",
"",
"set  C",
"and  $%4.4X+Y",
"dec  A",
"",
"bit  $%4.4X+X",
"and  $%4.4X+X",
"rol  $%4.4X+X",
"",

/* 4 */

"rti",
"xor  ($%2.2X+X)",
"",
"",
"",
"xor  $%2.2X",
"shr  $%2.2X",
"",
"psh  A",
"xor  #$%2.2X",
"shr  A",
"",
"jmp  $%4.4X",
"xor  $%4.4X",
"shr  $%4.4X",
"",

/* 5 */

"bvc  %+d",
"xor  ($%2.2X)+Y",
"xor  ($%2.2X)",
"",
"",
"xor  $%2.2X+X",
"shr  $%2.2X+X",
"",
"clr  I",
"xor  $%4.4X+Y",
"psh  Y",
"",
"",
"xor  $%4.4X+X",
"shr  $%4.4X+X",
"",

/* 6 */

"rts",
"adc  ($%2.2X+X)",
"",
"",
"mov  #0,$%2.2X",
"adc  $%2.2X",
"ror  $%2.2X",
"",
"pul  A",
"adc  #$%2.2X",
"ror  A",
"",
"jmp  ($%4.4X)",
"adc  $%4.4X",
"ror  $%4.4X",
"",

/* 7 */

"bvs  %+d",
"adc  ($%2.2X)+Y",
"adc  ($%2.2X)",
"",
"mov  #0,$%2.2X+X",
"adc  $%2.2X+X",
"ror  $%2.2X+X",
"",
"set  I",
"adc  $%4.4X+Y",
"pul  Y",
"",
"jmp  ($%4.4X+X)",
"adc  $%4.4X+X",
"ror  $%4.4X+X",
"",

/* 8 */

"bra  %+d",
"mov  A,($%2.2X+X)",
"",
"",
"mov  Y,$%2.2X",
"mov  A,$%2.2X",
"mov  X,$%2.2X",
"",
"dec  Y",
"bit  #$%2.2X",
"mov  X,A",
"",
"mov  Y,$%4.4X",
"mov  A,$%4.4X",
"mov  X,$%4.4X",
"",

/* 9 */

"bcc  %+d",
"mov  A,($%2.2X)+Y",
"mov  A,($%2.2X)",
"",
"mov  Y,$%2.2X+X",
"mov  A,$%2.2X+X",
"mov  X,$%2.2X+Y",
"",
"mov  Y,A",
"mov  A,$%4.4X+X",
"mov  X,S",
"",
"mov  #0,$%4.4X",
"mov  A,$%4.4X+X",
"mov  #0,$%4.4X+X",
"",

/* A */

"mov  #$%2.2X,Y",
"mov  ($%2.2X+X),A",
"mov  #$%2.2X,X",
"",
"mov  $%2.2X,Y",
"mov  $%2.2X,A",
"mov  $%2.2X,X",
"",
"mov  A,Y",
"mov  #$%2.2X,A",
"mov  A,X",
"",
"mov  $%4.4X,Y",
"mov  $%4.4X,A",
"mov  $%4.4X,X",
"",

/* B */

"bcs  %+d",
"mov  ($%2.2X)+Y,A",
"mov  ($%2.2X),A",
"",
"mov  $%2.2X+X,Y",
"mov  $%2.2X+X,A",
"mov  $%2.2X+Y,X",
"",
"clr  V",
"mov  $%4.4X+Y,A",
"mov  S,X",
"",
"mov  $%4.4X+X,Y",
"mov  $%4.4X+X,A",
"mov  $%4.4X+Y,X",
"",

/* C */

"cmp  Y,#$%2.2X",
"cmp  A,($%2.2X+X)",
"",
"",
"cmp  Y,$%2.2X",
"cmp  A,$%2.2X",
"dec  $%2.2X",
"",
"inc  Y",
"cmp  A,#$%2.2X",
"dec  X",
"",
"cmp  Y,$%4.4X",
"cmp  A,$%4.4X",
"dec  $%4.4X",
"",

/* D */

"bzc  %+d",
"cmp  A,($%2.2X)+Y",
"cmp  A,($%2.2X)",
"",
"",
"cmp  A,$%2.2X+X",
"dec  $%2.2X+X",
"",
"clr  D",
"cmp  A,$%4.4X+Y",
"psh  X",
"",
"",
"cmp  A,$%4.4X+X",
"dec  $%4.4X+X",
"",

/* E */

"cmp  X,#$%2.2X",
"sbc  ($%2.2X+X)",
"",
"",
"cmp  X,$%2.2X",
"sbc  $%2.2X",
"inc  $%2.2X",
"",
"inc  X",
"sbc  #$%2.2X",
"nop",
"",
"cmp  X,$%4.4X",
"sbc  $%4.4X",
"inc  $%4.4X",
"",

/* F */

"beq  %+d",
"sbc  ($%2.2X)+Y",
"sbc  ($%2.2X)",
"",
"",
"sbc  $%2.2X+X",
"inc  $%2.2X+X",
"",
"set  D",
"sbc  $%4.4X+Y",
"pul  X",
"",
"",
"sbc  $%4.4X+X",
"inc  $%4.4X+X",
""
};

char **instruction_strings = standard_instruction_strings;
