
#ifndef INCLUDED_TABLES_H
#define INCLUDED_TABLES_H

#include "em65types.h"

/* instruction decode tables */
extern ifunc binary_instruction_table[];
extern ifunc decimal_instruction_table[];
extern ifunc *instruction_table;

/* memory mapped I/O tables */
extern wfunc io_write[];
extern rfunc io_read[];

/* functions to install hooks in the I/O tables */
void install_iow( wfunc f, int i );
void install_ior( rfunc f, int i );

/* debugger disassembler tables */
extern char instruction_size[];
extern char instruction_is_branch[];
extern char instruction_is_immediate[];

extern char *standard_instruction_strings[];
extern char *orthogonal_instruction_strings[];
extern char **instruction_strings;

#endif /* #ifndef INCLUDED_TABLES_H */
