
#ifndef INCLUDED_TERMINAL_H
#define INCLUDED_TERMINAL_H

#include "em65.h"

/* messages the terminal will respond to */

#define TERMINAL_GET_CHAR     0x0100
#define TERMINAL_PUT_CHAR     0x0200
#define TERMINAL_NOWRITE      0x0300
#define TERMINAL_WRITE        0x0400
#define TERMINAL_KEYPRESS     0x0500
#define TERMINAL_SAVE_CHAR    0x0600
#define TERMINAL_CLEAR_IFLAG  0x0700

/* setup and start terminal process */
void terminal_init( void );
void terminal_main( void );

/* interface to running terminal process */
int terminal_talk( int message );
void terminal_tell( int message );
unsigned char terminal_flag( void );
unsigned char terminal_read( void );
void terminal_save( unsigned char byte );
void terminal_write( unsigned char byte );
void terminal_clear_iflag( unsigned char byte );

#endif /* #ifndef INCLUDED_TERMINAL_H */
