
#include <assert.h>
#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>

#include "cmdline.h"   /* short em65_realtime_clock, short em65_clock_rate */
#include "cpu.h"       /* F_IRQ */
#include "debugger.h"  /* short running */
#include "em65.h"      /* assert_interrupt() */

int timer_on = 0;
int timer_generated_irq = 0;

void catch_clock()
{
    if ( running )
    {
	num_ticks++;
	
	if ( timer_on )
	{
	    timer_generated_irq = 1;
	    assert_interrupt( CLOCK_INDEX, F_IRQ );
	}
    }
}

unsigned char timer_flag( void )
{
    if ( 0 == timer_generated_irq )
	return 0x00;

    timer_generated_irq = 0;
    clear_interrupt( CLOCK_INDEX, F_IRQ );
    return 0x80;
}

void timer_write( unsigned char byte )
{
    if ( byte & 0x01 )
	timer_on = 1;
    else
	timer_on = 0;
}

void timer_init( void )
{
    int result;
    long usecs;
    struct itimerval t;

    /* set the selected interval */

    /* Debug - zero is not allowed, no matter what the user wants */
    assert( em65_clock_rate );

    if ( em65_clock_rate == 1 )
    {
	t.it_value.tv_usec    = 0;
	t.it_interval.tv_usec = 0;
	t.it_value.tv_sec     = 1;
	t.it_interval.tv_sec  = 1;
    }
    else
    {
	usecs = 1000000 / em65_clock_rate;
	t.it_value.tv_sec     = 0;
	t.it_interval.tv_sec  = 0;
	t.it_value.tv_usec    = usecs;
	t.it_interval.tv_usec = usecs;
    }

    /* set the timer */

    if ( em65_realtime_clock )
	result = setitimer( ITIMER_REAL, &t, NULL );
    else
	result = setitimer( ITIMER_VIRTUAL, &t, NULL );

    if ( -1 == result )
    {
	perror( "timer_init (setitimer)" );
	exit( 1 );
    }

    /* make sure to catch the alarm */

    if ( em65_realtime_clock )
	result = (int)signal( SIGALRM, catch_clock );
    else
	result = (int)signal( SIGVTALRM, catch_clock );

    if ( -1 == result )
    {
	perror( "timer_init (signal)" );
	exit( 1 );
    }
}

