/***********************************************************************
 *
 *	umdss.h		UMDSS source-wide definitions
 *			Part of the UMDSS Project
 *			(C)opyright 1993 Morgan Davis Group
 *
 **********************************************************************/

#ifndef _UMDSS_H_
#define _UMDSS_H_

#include <sys/param.h>
#include "config.h"

#define	VERSION	"1.1d0"
#define	COPR	"copyright (C) 1995 Morgan Davis Group"

	/*
	 * Try to make sense of UNIX directory interfaces.
	 */

#ifdef NDIR
#include <sys/ndir.h>
#define dirent direct
#else
#include <dirent.h>
#endif

#define	STATDIR	 ".Status"		/* SPOOLDIR/.Status directory */

#define	UID		(getuid())	/* umdss user/owner ID */
#define	GID		(getgid())	/* umdss group ID */

#define	LCK_TMPL	"%s/LCK..%s"	/* LOCKDIR pathname template */
#define PID_TMPL	"%10i\n"	/* process ID template */

#define	SITELEN_MAX	(15)		/* max sitename length */
#define	PASSWD_MAX	(15)		/* max password length */
#define	CMDLINE_MAX	(128)		/* max command line length */

#define	IDINPUT_TMPL	"%15[-a-z0-9];%15s"
#define	IDENTRY_TMPL	"%15[^;];%15[^;];%128[^;];%128[ -~]\n"

/****************************************************************************/

#define	NO_ERROR	(0)		/* no error */
#define	ERROR		(-1)		/* generic error code */
#define TIMEOUT		(-1)		/* timeout code */

#define	BUFLEN		(256)		/* buffer length */

#define	ENQ_PROMPT	(5)		/* command prompt */
#define	SEND_CMD	'S'		/* send */
#define	HANGUP_CMD	'H'		/* hangup */
#define	RECEIVE_CMD	'R'		/* receive (text) */
#define	BINARY_CMD	'B'		/* receive (binary) */
#define	CANCEL_CMD	(24)		/* Control-X cancels */

#define	FUDGE		(1)		/* for debugging */

#define	ENQ_CMD_WAIT	(3*FUDGE)	/* Seconds between ENQs for command */
#define	ENQ_TIMEOUT	(30*FUDGE)	/* Seconds master waits for ENQ */
#define	MAX_BOGUS	(5)		/* Bogus commands before aborting */
#define	MAX_TIMEOUTS	(10)		/* Timeouts before aborting */
#define MAX_ATTEMPTS	(10)		/* Command attempts */
#define MAX_FAILURES	(3)		/* Consecutive failures */

#define	basename(s)	(strrchr((char *)(s), '/') + 1)
/* #define basetty(n)	(basename(ttyname(n)) + 3) */
#define basetty(n)	(basename(ttyname(n)))

#include "serial.h"
#include "umglob.c"	/* SCOPE's definition determines global references */

#endif /* _UMDSS_H_ */
