/***********************************************************************
 *
 *	umisc.c		Miscellaneous routines
 *			Part of the UMDSS Project
 *			(C)opyright 1992 Morgan Davis Group
 *
 **********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <time.h>
#include <signal.h>
#include <string.h>

#define	SCOPE	extern
#include "umdss.h"

extern void cleanup();


#ifdef MKDIR
/*
 * mkdir()
 */

int mkdir(name, mode)
	const char *name;	/* name of directory to create */
	unsigned mode;		/* mode for directory */
{
	int	status;

	strcpy(buf, "mkdir ");
	strcat(buf, name);
	strcat(buf, " > /dev/null 2>&1");
	if (!(status = system(buf)))
		chmod(name, mode);
	return(status);
}
#endif


/*
 *	logentry()	Write a message to the logfile
 */

void logentry(code, msg)
	char *code, *msg;
{
	time_t calendar_time;
	struct tm our_time;

	if (!logref) return;

	calendar_time = time(NULL);
	our_time = *localtime(&calendar_time);
	fprintf(logref, "%s %i/%02i-%02i:%02i:%02i %s %s\n",
		sitename, our_time.tm_mon+1, our_time.tm_mday,
		our_time.tm_hour, our_time.tm_min, our_time.tm_sec,
		code, msg);
	fflush(logref);
}


/*
 *	logstatus()	Write a message to the .Status file
 */

void logstatus(msg)
	char *msg;
{
	static FILE *fp = NULL;
	static time_t calendar_time;
	static int first_time = 1;
	static char tty[32];
	
	if (!*sitename)		/* name unknown if it's null */
		return;

	if (first_time) {
		first_time = 0;
		calendar_time = time(NULL);
		sprintf(fpath, "%s/%s", spooldir, STATDIR);
		umask(0);
		if (stat(fpath, &stbuf) && mkdir(fpath, 0777))
			logentry("* <ERROR: MKDIR", fpath);
		umask(0177);
		strcat(fpath, "/");
		strcat(fpath, sitename);
		if (!(fp = fopen(fpath, "w")))
			logentry("* <ERROR: WRITE", fpath);
		else
			chmod(fpath, 0666);
	}
	
	if (msg && fp) {
		rewind(fp);
		fprintf(fp, "%s %d %s %d %lu %d %lu %s\n",
			sitename, calendar_time, ttystr,
			jobsSent, (unsigned long)bytesSent,
			jobsRcvd, (unsigned long)bytesRcvd,
			msg);
	} else if (fp) {
		fclose(fp);
		fp = NULL;
	}
}


/*
 *	trap_hangup()	Trap HUP signals, make a log entry, and exit
 */

void trap_hangup()
{
	logentry("*", "<ALERT: DISCONNECTED>");
	cleanup(ERROR);
}

/*
 *	xfer()		Executes an external program and returns its result
 */
 
int xfer(agentcl, name)
	char *agentcl, *name;
{
	int result;
	char cl[PATHLEN], cl2[PATHLEN];

	sprintf(cl, agentcl, name);
	result = system(cl);
	if (result == 0x7F00) {
		sprintf(cl2, "<ERROR: SYSTEM(\"%s\") FAILED>", cl);
		logentry("*", cl2);
	}
	return(result);
}	


/*
 * Wait on a child process
 */
fwait(pid)
register int	pid;
{
	register int	w;
	int	status;

	while ((w = wait(&status)) != pid && w != -1)
		;
	if (w == -1)
		status = -1;
	return(status);
}


/*
 * find pattern within source
 */

int sindex(source, pattern)
	char *source;	/* source string to search */
	char *pattern;	/* string to look for */
{
	register char *sp;	/* ptr to current position to scan */
	register char *csp;	/* ptr to source string during comparison */
	register char *cp;	/* ptr to place to check for equality */

	/* scanning through the source string */
	sp = source;
	while (*sp) {
		/* scan through the pattern */
		cp = pattern;
		csp = sp;
		while (*cp) {
			if (*cp != *csp)
				break;
			++cp;
			++csp;
		}

		/* was it a match? */
		if (*cp == 0)
			return((int)(sp - source) + 1);
		++sp;
	}

	/* no match at all.. */
	return(0);
}
