

typedef long size_t;

/*
** void *memcpy(void *s1, const void *s2, size_t n);
**
** The memcpy function copies n characters from the object pointed to by s2
** into the object pointed to by s1. If copying takes place between objects
** that overlap, the behavior is undefined.
**
** The memcpy function returns the value of s1.
**
*/

void *memcpy(void *s1, const void *s2, size_t n)

{
	char *source = s2;
	char *dest   = s1;
	int i;

	for (i=0; i<n; i++)
		*dest++ = *source++;

	return s1;
}

/*
** void *memmove(void *s1, const void *s2, size_t n);
**
** The memmove function copies n characters form the object pointed to by s2
** into the objected pointed to by s1. Copying takes place as if the n
** characters from the objected pointed to by s2 are first copied into a
** temporary array of n characters that does not overlap the objects pointed
** to by s1 and s2, and then the n charcters from the temporary array are
** copied into the objected pointed to by s1.
**
** The memmove function returns the value of s1.
*/

void *memmove(void *s1, const void *s2, size_t n)

{
	char *source = s2;
	char *dest   = s1;
	int i;

	if ((int) s1 < (int) s2)
		for (i=0; i<n; i++)
			*dest++ = *source++;
	else {

		dest   += n - 1;
		source += n - 1;

		for (i=0; i<n; i++)
			*dest-- = *source--;
	}

	return s1;
}

/*
** char *strcpy(char *s1, const char *s2);
**
** The strcpy function copies the string pointed to by s2 (including the
** terminating null character) into the array pointed to by s1. If copying
** takes place between objects that overlap, the behavior is undefined.
**
** The strcpy function returns the value of s1.
*/

char *strcpy(char *s1, const char *s2)

{
	char *dest = s1;

	while (*s2)
		*dest++ = *s2++;

	*dest++ = *s2++;

	return s1;
}

/*
** char *strncpy(char *s1, const char *s2, size_t n);
**
** The strncpy function copies not more than n characters (character that
** follow a null character are not copied) from the array pointed to by
** s2 to the array pointed to by s1. If copying takes place between
** objects that overlap, the behavior is undefined.
**
** If the array pointed to by s2 is a string shorter than n characters,
** null character are appended to the copy int he array pointed to by s1,
** until n characters in all have been written.
**
** The strncpy function returns the value of s1.
*/

char *strncpy(char *s1, const char *s2, size_t n)

{
	char *dest = s1;
	int i;

	for (i=0; i<n; i++) {
		*dest++ = *s2;

		if (*s2)
			s2++;
	}

	return s1;
}

/*
** char *strcat(char *s1, const char *s2);
**
** The strcat function appends a copy of the string pointed to by s2
** (including the terminating null character) to the end of a string pointed
** to by s1. The initial character of s2 overwrites the null character
** at the end of s1. If copying takes place between objects that overlap,
** the behavior is undefined.
**
** The strcat function returns the value of s1.
*/

char *strcat(char *s1, const char *s2)

{
	char *dest = s1;

	while (*dest)
		dest++;

	while (*s2)
		*dest++ = *s2++;

	return s1;
}

/*
** char *strncat(char *s1, const char *s2, size_t n);
**
** The strncat function appends not more than n characters (a null character
** and characters that follow it are not appended) from the array pointed to
** by s2 to the end of the string pointed to by s1. The intial character of
** s2 overwrites the null character at the end of s1. A terminating null
** character is always appended to the result. If copying takes place between
** objects that overlap, the behavior is undefined.
**
** The strncat function returns the value of s1.
*/

char *strncat(char *s1, const char *s2, size_t n)

{
	char *dest = s1;
	int i;

	while (*dest)
		dest++;

	for (i=0; i<n; i++) {

		if (!*s2)
			break;

		*dest++ = *s2++;
	}

	*dest++ = 0;

	return s1;
}

/*
** int memcmp(const void *s1, const void *s2, size_t n);
**
** The memcmp function compares the first n characters of the object pointed
** to by s1 to the first n characters of the object pointed to by s2.
**
** The memcmp function returns an integer greater than, equal to, or
** less than zero, accordingly as the object pointed to by s1 is greater than,
** equal to, or less than the object pointed to by s2.
*/

int memcmp(const void *s1, const void *s2, size_t n)

{
	int i;
	char *m1 = s1, *m2 = s2;

	for (i=0; i<n; i++) {

		if (*m1 < *m2)
			return -1;
		else if (*m1 > *m2)
			return 1;

		m1++;
		m2++;
	}

	if (*m1 == *m2)
		return 0;
	else if (*m1 < *m2)
		return -1;
	else if (*m1 > *m2)
		return 1;
}

/*
** int strcmp(const char *s1, const char *s2);
**
** The strcmp function compares the string pointed to by s1 to the string
** pointed to by s2.
**
** The strcmp function returns an integer greater than, equal to, or
** less than zero, accordingly as the string pointed to by s1 is greater than,
** equal to, or less than the string pointed to by s2.
*/

int strcmp(const char *s1, const char *s2)

{
	while (*s1 && *s2) {

		if (*s1 < *s2)
			return -1;
		else if (*s1 > *s2)
			return 1;

		s1++;
		s2++;
	}

	if (*s1 == *s2)
		return 0;
	else if (*s1 < *s2)
		return -1;
	else if (*s1 > *s2)
		return 1;
}


	char string1[16] = "hello, world\n";
	char string2[16] = " ";

void main(void)

{

	strcpy(string2, string1);

	puts(string2);
}
