/***********************************************************************
 *
 *      config.h        UMDSS configuration file
 *                      Part of the UMDSS Project
 *                      (C)opyright 1993 Morgan Davis Group
 *
 **********************************************************************/


#define	SCO	0	/* 1 if SCO UNIX or XENIX */

	/*  If SYSTEMID is defined, it contains the host's name. */
	/*  Otherwise, /etc/hostname holds the host's name	*/

#define	SYSTEMID        "io" /**/

	/*  These flags control various compilation features	*/
	/*  Turn them on (1) or off (0) as appropriate		*/

#define NDIR	0	/* To use <sys/ndir.h> directory interfaces */
#define MKDIR	0	/* If mkdir() not part of standard libraries */
#define DEBUG	0	/* If you want more junk in the log file */
#define	TYPES_T	0	/* To define types like pid_t, mode_t, and off_t */
#define	SGTTY	0	/* If you don't have termio for port settings */

	/*  Pathnames to the log and ID files  */

#define LOGFILE         "/usr/local/lib/umdss/umdsslog"
#define IDFILE          "/usr/local/lib/umdss/idfile"

	/*  These directory paths must end with slashes  */

#if SCO
#define LOCKDIR         "/usr/spool/uucp/"
#else
#define LOCKDIR         "/usr/spool/locks/"
#endif

#define SPOOLDIR        "/usr/spool/umdss/"


	/*  System-dependent settings  */

#define	DPERM		(0775)		/* spool directory permissions */
#define	PATHLEN		(64)		/* maximum pathname length */


	/*
	 *  These are available for compatibility
	 *  with older compilers that do not have them.
	 */

#if TYPES_T
typedef	int pid_t;
typedef int mode_t;
typedef unsigned long off_t;
#endif /* TYPES_T */

