/**********************************************************************
 *
 *	mdx.c	Morgan Davis XMODEM 1.0
 *		(C)opyright 1992 Morgan Davis Group
 *
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>

#include "config.h"
#include "mdx.h"

#if SGTTY
#include <sgtty.h>
#define	TERMGET		TIOCGETP
#define	TERMSET		TIOCSETP
#define	TERMSTRUCT	struct sgttyb
#else
#include <termio.h>
#define	TERMGET		TCGETA
#define	TERMSET		TCSETAW
#define	TERMSTRUCT	struct termio
#endif

	/* Global variables */

TERMSTRUCT default_stty;
mode_t oldcmask;

/*
 *	cleanup()
 *
 *	Called before quitting to reset the environment.
 */

void cleanup()
{
   ioctl(fileno(stdin), TERMSET, &default_stty);
   umask(oldcmask);
}   


int main(argc, argv)
	int argc;
	char *argv[];
{
	extern int optind;
	extern char *optarg;
	TERMSTRUCT mystty;
	char c, mode, *fname;
	int blocksize, crcflag, result, errflag;
	struct stat dummy;

	errflag = mode = crcflag = blocksize = 0;

	while ((c = getopt(argc, argv, "s:r:CKL")) != EOF) {
		switch (c) {
		case 's':
		case 'r':
			mode = c;
			fname = optarg;
			break;
		case 'C':
			if (!blocksize) blocksize = 128;
			++crcflag;
			break;
		case 'K':
			if (blocksize < 1024) blocksize = 1024;
			++crcflag;
			break;
		case 'L':
			blocksize = 4096;
			++crcflag;
			break;
		default:
			errflag = 1;
		}
	}

	if (errflag || !mode) {
		fprintf (stderr, "Usage: %s [ options ]\n", argv[0]);
		fprintf (stderr, "\t-s file\t\tSend file\n");
		fprintf (stderr, "\t-r file\t\tReceive file\n");
		fprintf (stderr, "\t-C\t\tXMODEM-CRC\n");
		fprintf (stderr, "\t-K\t\tXMODEM-1K\n");
		fprintf (stderr, "\t-L\t\tXMODEM-4K\n");
		exit(-1);
	}

	result = stat(fname, &dummy);
	if (mode == 'r' && !result) {
		fprintf(stderr, "%s: %s exists!\n", argv[0], fname);
		return(OSERROR);
	}
	if (mode == 's' && result) {
		fprintf(stderr, "%s: %s not found\n", argv[0], fname);
		return(OSERROR);
	}

	oldcmask = umask(0177);

	ioctl(fileno(stdin), TERMGET, &mystty);
	default_stty = mystty;

#if SGTTY
	mystty.sg_flags &= ~ECHO;                 /* No echo */
	mystty.sg_flags |= HUPCL;                 /* Hangup friendly */
	mystty.sg_flags |= RAW;                   /* RAW mode */
#else
	mystty.c_oflag = mystty.c_iflag = mystty.c_lflag = 0;	/* disabled */
	mystty.c_cflag |= (CS8|CREAD|HUPCL);
	mystty.c_cc[VMIN] = 1;
	mystty.c_cc[VTIME] = 0;
#endif

	ioctl(fileno(stdin), TERMSET, &mystty);

	signal(SIGINT, SIG_IGN);	/* Ignore interrupts */
	signal(SIGQUIT, SIG_IGN);	/* Ignore Quit signal */
	signal(SIGHUP, trap_hangup);	/* If they hang up, record it! */

	if (mode == 's')
		result = xsend(fname, blocksize);
	else
		result = xrecv(fname, crcflag, blocksize);
	cleanup();
	return (result);
}


void trap_hangup()
{
	cleanup();
	exit(HUP_ERROR);
}


int alarm_went_off;

void trap_alarm() { alarm_went_off = TIMEOUT; }

int get_timed_char(seconds)
	int seconds;
{
	char c;
	void trap_alarm();

	alarm_went_off = 0;
	signal(SIGALRM, trap_alarm);
	alarm(seconds);

	c = getchar();

	alarm(0);
	signal(SIGALRM, SIG_DFL);
	return ((alarm_went_off) ? TIMEOUT : c & 0xFF);
}


void write_clear_char(c)
	char c;
{
	while (get_timed_char(2) != TIMEOUT);
	putchar(c);
}

void write_char(c)
	char c;
{
	putchar(c);
}
