/**********************************************************************
 *
 *	mdx.h	Morgan Davis XMODEM 1.0
 *		(C)opyright 1992 Morgan Davis Group
 *
 */

#ifndef __MDX__
#define __MDX__

#define SOH		0x01	/* 128-byte start of header */
#define	STX		0x02	/* 1K start of header */
#define	SSTX		0x82	/* 4K start of header */
#define EOT		0x04
#define ACK		0x06
#define NAK		0x15
#define CAN		0x18

#define	GOOD		0	/* transfer results */
#define TIMEOUT		-1	/* timed out waiting for a response */
#define	CANCELLED	-2	/* other side sent cancel request */
#define FAILED		-3	/* failed from too many errors */
#define	MEMFAIL		-4	/* malloc couldn't get memory */
#define	OSERROR		-5	/* error during read or write */
#define	HUP_ERROR	-6	/* lost carrier */

#define	FUDGE		1

#define MAX_ERROR	10	/* total errors in transmitting a packet */
#define MAX_NAK		30	/* seconds sender waits for a NAK (or CKL) */
#define MAX_EOT		3	/* times sender sends EOT for an ACK */
#define	MAX_RCVHI	10	/* times receiver requests to start */
#define NAK_THRESH	6	/* times to send CKL until going to NAKs */

#define	WRITE_DELAY	10*FUDGE	/* timeout delay after writing a packet */
#define	READ_DELAY	10*FUDGE	/* timeout for reading a packet */
#define	MAXBUF		4096	/* largest data block size */
#define	FRAMING		5	/* <soh> <blk> <blkcomp> <crchi> <crclo> */


	/* Public function definitions */

extern int get_timed_char();		/* Wait for a character */
extern void trap_hangup();		/* Trap for hangup signal */
extern void write_clear_char();
extern void write_char();

#endif /* __MDX__ */
