/***********************************************************************
 *
 *	umaster.c	Master command (sending) mode
 *			Part of the UMDSS Project
 *			(C)opyright 1992 Morgan Davis Group
 *
 **********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>

#define	SCOPE	extern
#include "umdss.h"

	/* Forward references to external functions */

extern void logentry();
extern char get_timed_char();

/*
 *	master()	Sends commands to slave
 */

void master(exit_code)
	char exit_code;
{
	int attempts, failures, c;
	char *cp;
	DIR *outdir;		/* Directory containing outgoing mail */
	FILE *outfile;		/* File to send */
	struct dirent *next;	/* Next directory entry to send */

	/* Make path to site directory */
	sprintf(dpath, "%s%s/", spooldir, sitename);

	if (!(send_job_info()))
		goto all_done;
	
	/* Mail sending loop */

	failures = 0;
	outdir = opendir(dpath);
	while ((next = readdir(outdir)) != NULL) {  
		if (next->d_name[0] == '.') continue;	/* Skip dot files */

		strcpy(fpath, dpath);		/* build pathname */
		strcat(fpath, next->d_name);

		attempts = 0;
		fflush(stdin);

		do {
			c = get_timed_char(ENQ_TIMEOUT);
			switch (c) {
			case TIMEOUT:
				logentry("*", "<ERROR: NO ENQ FROM REMOTE>");
				cleanup(ERROR);
				break;

			case ENQ_PROMPT:
				break;

			default:
#if DEBUG
				sprintf(buf, "<DEBUG: GOT $%02hx, WANTED $05>", c & 0xFF);
				logentry("?", buf);
#endif
				if (++attempts >= MAX_ATTEMPTS) {
					logentry("*", "<ERROR: TOO MUCH LINE NOISE>");
					cleanup(ERROR);
				}
				while(get_timed_char(2) != TIMEOUT);
			}
		} while (attempts);

		write_char(RECEIVE_CMD);
		if (!xfer(sndcmd, fpath)) {
			failures = 0;
			if ((outfile = fopen(fpath, "r")) != NULL) {
				strcpy(towho, "?");
				while (fgets(buf, BUFLEN, outfile) != NULL) {
					 if (!strncmp(buf, "Ppath: ", 7)) {
						 strcpy(towho, buf+7);
						 if ((cp = (char *)strchr(towho, '\n')) != NULL)
							 *cp = '\0';
						 break;
					 }
				}
				fclose(outfile);
				(void) stat(fpath, &stbuf);
				if (!strncmp(towho, sitename, strlen(sitename))) {
					cp = towho + strlen(sitename);
					if (*cp == '!')
						cp++;
					else
						cp = towho;
				} else
					cp = towho;
				sprintf(buf, "%lu %s", stbuf.st_size, cp);
				logentry("S", buf);
				jobsSent++;
				bytesSent += stbuf.st_size;
				logstatus("");
			}
			unlink(fpath);
		} else {
			if (++failures >= MAX_FAILURES) {
				logentry("*", "<ALERT: TOO MANY FAILURES>");
				break;
			} else
				logentry("*", "<ALERT: SEND FAILED>");
		}
	}

	closedir(outdir);

	all_done:
	while (get_timed_char(10) != ENQ_PROMPT);
	write_char(exit_code);
}


int send_job_info()
{
	DIR *outdir;		/* Site's mail directory */
	struct dirent *next;	/* Next directory entry to send */
	unsigned int jobs;
	off_t bytes;
	mode_t curmask;
	int result;

	if ((outdir = opendir(dpath)) == NULL) {
		if(stat(dpath, &stbuf) == -1) {		/* see if dir exists */
			dpath[strlen(dpath)-1] = '\0';	/* chop off slash */
			curmask = umask(0);
			result = mkdir(dpath, DPERM);	/* if not, create it */
			umask(curmask);
			if(result) {			/* if not, create it */
				sprintf(buf, "<ERROR: CAN'T MAKE %s>", dpath);
				logentry("*", buf);
			}
			return(0);	/* always report no jobs */
		}
		sprintf(buf, "<ERROR: #%i OPENING %s>", errno, dpath);
		logentry("*", buf);
		return(0);
	}

	for (bytes = jobs = 0; (next = readdir(outdir)) != NULL; ) {  
		if (next->d_name[0] == '.') continue;	/* Skip dot files */

		strcpy(fpath, dpath);		/* build pathname */
		strcat(fpath, next->d_name);
		(void) stat(fpath, &stbuf);

		++jobs;
		bytes += stbuf.st_size;
	}

	closedir(outdir);
	printf("Bytes: %lu\r\nJobs: %d\r\n", bytes, jobs);
	return(jobs);
}

