/***********************************************************************
 *
 *	umglob.c	UNIX MDSS Global data
 *			Part of the UMDSS Project
 *			(C)opyright 1992 Morgan Davis Group
 *
 *	Include this file with SCOPE defined as extern in order
 *	to create external references to global data.  Otherwise,
 *	include it without defining SCOPE in order to create the
 *	global data (this is done in only umdss.c)
 *
 **********************************************************************/

	/* Global assignments */

#ifndef SCOPE
#define SCOPE

unsigned speeds[SPEEDCNT] = { SPEEDLIST };
char header[] = "Site            Jobs Kilobytes Last Access TTY Session";
char line[] =   "=============== ==== ========= =========== === =======";

#ifdef SYSTEMID
char hostname[] = SYSTEMID;	/* Defined in config.h */
#else
char hostname[SITELEN_MAX+1];
#endif /* SYSTEMID */

char logfile[] = LOGFILE;
char idfile[] = IDFILE;
char lockdir[] = LOCKDIR;
char spooldir[] = SPOOLDIR;

#else

SCOPE unsigned speeds[SPEEDCNT];
SCOPE char header[];
SCOPE char line[];
SCOPE char hostname[];
SCOPE char logfile[];
SCOPE char idfile[];
SCOPE char lockdir[];
SCOPE char spooldir[];

#endif /* SCOPE */


SCOPE TERMSTRUCT default_stty;

SCOPE FILE *logref;

SCOPE char sitename[SITELEN_MAX+1];	/* Name of remote system */
SCOPE char sndcmd[CMDLINE_MAX+1];	/* sending agent command line */
SCOPE char rcvcmd[CMDLINE_MAX+1];	/* receiving agent command line */

SCOPE char lockfile[PATHLEN];		/* Path to lock file */

SCOPE int alarm_went_off;
SCOPE mode_t oldcmask;
SCOPE unsigned jobsSent;		/* work sent tallies */
SCOPE off_t bytesSent;
SCOPE unsigned jobsRcvd;		/* work received tallies */
SCOPE off_t bytesRcvd;

SCOPE char buf[BUFLEN];
SCOPE char fpath[PATHLEN];
SCOPE char dpath[PATHLEN];
SCOPE char towho[BUFLEN];

SCOPE struct stat stbuf;

SCOPE char *namedata;
SCOPE char **nameptr;
