/***********************************************************************
 *
 *	umtally.c	Queue reporting (-q) function
 *			Part of the UMDSS Project
 *			(C)opyright 1992 Morgan Davis Group
 *
 **********************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <stdio.h>
#include <errno.h>

#define	SCOPE	extern
#include "umdss.h"


int
namecomp(s1, s2)
	char **s1, **s2;
{
	return(strcmp(*s1, *s2));
}

int
count_sites()
{
	DIR *sdref;	/* umdss site spool directory */
	char **p, *q;
	unsigned sites, n;
	unsigned bufsiz;
	struct dirent	*nxtsite;	/* Next site directory */

	if ((sdref = opendir(spooldir)) == NULL) {
		fprintf(stderr, "umdss: can't open %s\n", spooldir);
		return(ERROR);
	}
	
	sites = 0;
	bufsiz = 0;
	while (nxtsite = readdir(sdref)) {  
		if (nxtsite->d_name[0] == '.')
			continue;
		++sites;
		bufsiz += strlen(nxtsite->d_name) + 1;
	}

	if (!(namedata = (char *)malloc(bufsiz))) {
		fprintf(stderr, "umdss: can't get memory\n");
		closedir(sdref);
		return(ERROR);
	}

	if (!(nameptr = (char **)malloc(sizeof(char *) * sites))) {
		fprintf(stderr, "umdss: can't get ptr mem\n");
		free(namedata);
		closedir(sdref);
		return(ERROR);
	}

	rewinddir(sdref);
	q = namedata;
	p = nameptr;
	while (nxtsite = readdir(sdref)) {  
		if (nxtsite->d_name[0] == '.')
			continue;
		strcpy(q, nxtsite->d_name);
		*p++ = q;
		q += strlen(nxtsite->d_name) + 1;
	}

	closedir(sdref);
	qsort(nameptr, sites, sizeof(char *), namecomp);
	return(sites);
}


	
tally()
{
	DIR		*sitedir;	/* Site's mail directory */
	FILE		*fp;
	int		tsites, n;
	unsigned int	jobs, tjobs, rjobs;
	off_t		bytes, tbytes, rbytes;
	struct dirent	*nxtfile;
	char		**p, date[12], tty[3], msg[40];
	time_t		calendar_time;
	struct tm	our_time;
	
	if ((tsites = count_sites()) < 1)
		return(ERROR);

	puts(header);
	puts(line);

	tbytes = tjobs = 0;
	
	for (n = 1, p = nameptr; n <= tsites; ++n, ++p) {
		strcpy(dpath, spooldir);		/* build pathname */
		strcat(dpath, *p);
		if (sitedir = opendir(dpath)) {
			bytes = jobs = 0;
			while (nxtfile = readdir(sitedir)) {  
				if (nxtfile->d_name[0] == '.')
					continue;
				strcpy(fpath, dpath);		/* build pathname */
				strcat(fpath, "/");
				strcat(fpath, nxtfile->d_name);
				(void) stat(fpath, &stbuf);
				++jobs;
				bytes += stbuf.st_size;
			}
			closedir(sitedir);

			strcpy(fpath, spooldir);
			strcat(fpath, STATDIR);
			strcat(fpath, "/");
			strcat(fpath, *p);
			*msg = *date = *tty = '\0';
			if (fp = fopen(fpath, "r")) {
				if (fscanf(fp, "%*s %lu %3s %*u %*lu %u %lu %40[ -~]\n",
					&calendar_time, tty, &rjobs, &rbytes, msg) > 0) {
					our_time = *localtime(&calendar_time);
					sprintf(date, "%02u/%02u-%02u:%02u",
						our_time.tm_mon+1, our_time.tm_mday,
						our_time.tm_hour, our_time.tm_min);
				}
				fclose(fp);
			}

			switch(chklock(*p)) {
			case -1:
#if DEBUG
				sprintf(msg, "BAD LOCK (errno=%u)", errno);
#else
				strcpy(msg, "BAD LOCK");
#endif
				break;
			case 1:
				if (rjobs)
					sprintf(msg, "TALKING Received %u (%0.2fK)",
						rjobs, (float)rbytes / 1024);
				else
					strcpy(msg, "TALKING");
			}

			printf("%-15s %4u %9.2f %11s %3s %s\n",
				*p, jobs, (float)bytes / 1024, date, tty, msg);
			tjobs += jobs;
			tbytes += bytes;
		}
	}
	if (tsites > 1) {
		puts(line);
		printf("                %4u %9.2f\n",
			tjobs,
			(float)tbytes / 1024);
	}
	free(namedata);
	free(nameptr);
	return(NO_ERROR);
}
