; This file is part of the Resolution ][ library
;
; Copyright (c) 2000 Arthur Jerijian
; 
; Permission is hereby granted, free of charge, to any person obtaining
; a copy of this software and associated documentation files
; (the "Software"), to deal in the Software without restriction, including
; without limitation the rights to use, copy, modify, merge, publish,
; distribute, sublicense, and/or sell copies of the Software, and to permit
; persons to whom the Software is furnished to do so, subject to the
; following conditions:
; 
; The above copyright notice and this permission notice shall be included
; in all copies or substantial portions of the Software.
; 
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
; OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
; THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; DEALINGS IN THE SOFTWARE.

; ======================================================================
;
; Fill one half of a page (one quarter of the canvas) with a byte.
; This routine will fill every other memory location in the page with
; a byte. It is intended as a helper function to resii_fill_background.
;
; Input paramters
;	fill_byte - one byte -- byte to fill
;	fill_offset - one byte -- starting memory offset (0 or 1)
; Output parameters
;	None

fill_canvas_quarter:
	lda	image_buffer_lo
	sta	buffer_ptr
	lda	image_buffer_hi
	sta	buffer_ptr + 1

	ldy	fill_offset

fcq_loop:
	lda	fill_byte
	sta	(buffer_ptr),Y
	iny
	beq	fcq_loop_test
	iny
	bne	fcq_loop

fcq_loop_test:
	inc	buffer_ptr + 1
	ldy	fill_offset
	lda	buffer_ptr + 1
	cmp	image_buffer_hi + $20
	bne	fcq_loop
	rts

; ======================================================================
;
; Fill the canvas with a background color
;
; Input paramters
;	pen_color - one byte -- color to set the background
; Output parameters
;	None

resii_fill_background:
	lda	pen_color	; Translate the pen color to the
	lsr			; buffer color
	bcc	fb_continue
	ora	#$08
	
fb_continue:
	sta	color_work
	asl			; Fill the buffer color in both nybbles
	asl			; of the fill byte (i.e. multiply
	asl			; the color by 17).
	asl
	ora	color_work
	sta	fill_byte

	sta	ss_aux_page
	lda	#$00		; First quarter: fill byte = color * 17
	sta	fill_offset
	jsr	fill_canvas_quarter
	lda	fill_byte	; Third quarter: rotate fill byte twice
	asl
	adc	#$00
	asl
	adc	#$00
	sta	fill_byte
	inc	fill_offset
	jsr	fill_canvas_quarter
	sta	ss_main_page	; Fourth quarter: rotate fill byte left
	lda	fill_byte
	asl
	adc	#$00
	sta	fill_byte
	jsr	fill_canvas_quarter
	lda	fill_byte	; Second quarter: rotate fill byte twice
	asl
	adc	#$00
	asl
	adc	#$00
	sta	fill_byte
	dec	fill_offset
	jsr	fill_canvas_quarter
	
	rts

