; This file is part of the Resolution ][ library
;
; Copyright (c) 2000 Arthur Jerijian
; 
; Permission is hereby granted, free of charge, to any person obtaining
; a copy of this software and associated documentation files
; (the "Software"), to deal in the Software without restriction, including
; without limitation the rights to use, copy, modify, merge, publish,
; distribute, sublicense, and/or sell copies of the Software, and to permit
; persons to whom the Software is furnished to do so, subject to the
; following conditions:
; 
; The above copyright notice and this permission notice shall be included
; in all copies or substantial portions of the Software.
; 
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
; OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
; THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; DEALINGS IN THE SOFTWARE.

; ======================================================================
;
; Draw a line with a slope of between -1 and +1, after calculating all
; line-drawing parameters.
;
; Input paramters
;	use_color - one byte -- whether to use color (0 = no, 1 = yes)
;	pen_color - one byte -- color or value to write
;	line_x_start - two bytes -- starting X coordinate
;	line_y_start - one byte -- starting Y coordinate
;	line_x_end - two bytes -- ending X coordinate
;	line_y_end - one byte -- ending Y coordinate
;	line_ax - two bytes -- X coordinate delta multiplied by 2
;	line_ay - two bytes -- Y coordinate delta multiplied by 2
;	line_sx - one byte -- whether x_end is more positive than x_start
;	line_sy - one byte -- whether y_end is more positive than y_start

draw_line_low_slope:
	lda	line_ax			; Calculate d = ay - (ax / 2)
	sta	line_d_work
	lda	line_ax + 1
	sta	line_d_work + 1
	lsr	line_d_work + 1
	ror	line_d_work
	sec
	lda	line_ay
	sbc	line_d_work
	sta	line_d
	lda	line_ay + 1
	sbc	line_d_work + 1
	sta	line_d + 1

dlls_loop:
	jsr	resii_draw_pixel_offset	; Draw a pixel
	sec				; If the line is finished, quit
	lda	x_coord
	sbc	line_x_end
	bne	dlls_continue
	lda	x_coord + 1
	sbc	line_x_end + 1
	bne	dlls_continue
	rts

dlls_continue:
	lda	line_d + 1		; If d < 0, skip ahead. Otherwise,
	asl				; subtract ax from d and move y.
	bcs	dlls_add_x
	sec
	lda	line_d
	sbc	line_ax
	sta	line_d
	lda	line_d + 1
	sbc	line_ax + 1
	sta	line_d + 1
	lda	line_sy
	beq	dlls_dec_y
	jsr	resii_inc_y_offset
	clc
	bcc	dlls_add_x
dlls_dec_y:
	jsr	resii_dec_y_offset

dlls_add_x:
	clc				; Add ay to d
	lda	line_d
	adc	line_ay
	sta	line_d
	lda	line_d + 1
	adc	line_ay + 1
	sta	line_d + 1
	lda	line_sx			; Move x and continue to the
	beq	dlls_dec_x		; next pixel
	jsr	resii_inc_x_offset
	clc
	bcc	dlls_loop
dlls_dec_x:
	jsr	resii_dec_x_offset
	clc
	bcc	dlls_loop

; ======================================================================
;
; Draw a line with a slope of less than -1 or greater than +1,
; after calculating all line-drawing parameters.
;
; Input paramters
;	use_color - one byte -- whether to use color (0 = no, 1 = yes)
;	pen_color - one byte -- color or value to write
;	line_x_start - two bytes -- starting X coordinate
;	line_y_start - one byte -- starting Y coordinate
;	line_x_end - two bytes -- ending X coordinate
;	line_y_end - one byte -- ending Y coordinate
;	line_ax - two bytes -- X coordinate delta multiplied by 2
;	line_ay - two bytes -- Y coordinate delta multiplied by 2
;	line_sx - one byte -- whether x_end is more positive than x_start
;	line_sy - one byte -- whether y_end is more positive than y_start

draw_line_high_slope:
	lda	line_ay			; Calculate d = ax - (ay / 2)
	sta	line_d_work
	lda	line_ay + 1
	sta	line_d_work + 1
	lsr	line_d_work + 1
	ror	line_d_work
	sec
	lda	line_ax
	sbc	line_d_work
	sta	line_d
	lda	line_ax + 1
	sbc	line_d_work + 1
	sta	line_d + 1

dlhs_loop:
	jsr	resii_draw_pixel_offset	; Draw a pixel
	sec				; If the line is finished, quit
	lda	y_coord
	sbc	line_y_end
	bne	dlhs_continue
	rts

dlhs_continue:
	lda	line_d + 1		; If d < 0, skip ahead. Otherwise,
	asl				; subtract ay from d and move x.
	bcs	dlhs_add_y
	sec
	lda	line_d
	sbc	line_ay
	sta	line_d
	lda	line_d + 1
	sbc	line_ay + 1
	sta	line_d + 1
	lda	line_sx
	beq	dlhs_dec_x
	jsr	resii_inc_x_offset
	clc
	bcc	dlhs_add_y
dlhs_dec_x:
	jsr	resii_dec_x_offset

dlhs_add_y:
	clc				; Add ax to d
	lda	line_d
	adc	line_ax
	sta	line_d
	lda	line_d + 1
	adc	line_ax + 1
	sta	line_d + 1
	lda	line_sy			; Move y and continue to the
	beq	dlhs_dec_y		; next pixel
	jsr	resii_inc_y_offset
	clc
	bcc	dlhs_loop
dlhs_dec_y:
	jsr	resii_dec_y_offset
	clc
	bcc	dlhs_loop

; ======================================================================
;
; Draw a line between any two points
;
; Input paramters
;	use_color - one byte -- whether to use color (0 = no, 1 = yes)
;	pen_color - one byte -- color or value to write
;	line_x_start - two bytes -- starting X coordinate
;	line_y_start - one byte -- starting Y coordinate
;	line_x_end - two bytes -- ending X coordinate
;	line_y_end - one byte -- ending Y coordinate
; Output parameters
;	None

resii_draw_line:
	ldx	#$01			; X reg contains sign of x2 - x1
	sec				; Calculate ax = |x2 - x1|
	lda	line_x_end
	sbc	line_x_start
	sta	line_ax
	lda	line_x_end + 1
	sbc	line_x_start + 1
	sta	line_ax + 1
	bcs	dl_store_sx		; If (x2 - x1) < 0, take the
	ldx	#$00			; absolute value
	sec
	lda	#$00
	sbc	line_ax
	sta	line_ax
	lda	#$00
	sbc	line_ax + 1
	sta	line_ax + 1
dl_store_sx:
	stx	line_sx			; Store the sign of x2 - x1

dl_calculate_ay:
	ldx	#$01			; X reg contains sign of y2 - y1
	sec				; Calculate ay = |y2 - y1|
	lda	line_y_end
	sbc	line_y_start
	sta	line_ay
	lda	#$00
	sbc	#$00
	sta	line_ay + 1
	bcs	dl_store_sy		; If (y2 - y1) < 0, take the
	ldx	#$00			; absolute value
	sec
	lda	#$00
	sbc	line_ay
	sta	line_ay
	lda	#$00
	sbc	line_ay + 1
	sta	line_ay + 1
dl_store_sy:
	stx	line_sy			; Store the sign of y2 - y1

	asl	line_ax			; Double ax and ay
	rol	line_ax + 1
	asl	line_ay
	rol	line_ay + 1

	lda	line_x_start		; Start with (x_start, y_start)
	sta	x_coord
	lda	line_x_start + 1
	sta	x_coord + 1
	lda	line_y_start
	sta	y_coord

	jsr	resii_x_offset		; Compute the initial pixel memory
	jsr	resii_y_offset		; offsets

	sec				; Compare ax with ay
	lda	line_ax
	sbc	line_ay
	lda	line_ax + 1
	sbc	line_ay + 1

	bcc	dl_high_slope		; Depending on (ax - ay), draw a
	jmp	draw_line_low_slope	; line with the appropriate slope
					; range
dl_high_slope:
	jmp	draw_line_high_slope

