; This file is part of the Resolution ][ library
;
; Copyright (c) 2000 Arthur Jerijian
; 
; Permission is hereby granted, free of charge, to any person obtaining
; a copy of this software and associated documentation files
; (the "Software"), to deal in the Software without restriction, including
; without limitation the rights to use, copy, modify, merge, publish,
; distribute, sublicense, and/or sell copies of the Software, and to permit
; persons to whom the Software is furnished to do so, subject to the
; following conditions:
; 
; The above copyright notice and this permission notice shall be included
; in all copies or substantial portions of the Software.
; 
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
; OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
; THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
; FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
; DEALINGS IN THE SOFTWARE.

; ======================================================================
;
; TEST PROGRAM
;
; This module unifies all other modules and provides a jump table
; for function call entry
;
; Assemble with the command
;       xa -C -v -M test.asm -o test.bin                                       

.text
#include "defs.asm"

*= $4000

#define	resii_graphics_enable		program_start
#define resii_fill_background		program_start + 3
#define resii_x_offset			program_start + 6
#define resii_y_offset			program_start + 9
#define resii_inc_x_offset		program_start + 12
#define resii_dec_x_offset		program_start + 15
#define resii_inc_y_offset		program_start + 18
#define resii_dec_y_offset		program_start + 21
#define resii_draw_pixel_offset		program_start + 24
#define resii_draw_pixel		program_start + 27
#define resii_read_pixel_offset		program_start + 30
#define resii_read_pixel		program_start + 33
#define resii_draw_line			program_start + 36

#define y_holder			zp + 3

	jmp	line_test
	jmp	line_test_2
	jmp	line_test_3
	jmp	line_test_4

line_test:
	jsr	resii_graphics_enable
	lda	#$00
	sta	pen_color
	jsr	resii_fill_background
	lda	#$01
	sta	use_color
	lda	#$0E
	sta	pen_color
	lda	#$00
	sta	line_x_start
	sta	line_x_start + 1
	sta	line_y_start
	lda	#$8B
	sta	line_x_end
	lda	#$00
	sta	line_x_end + 1
	lda	#$BF
	sta	line_y_end
	jmp	resii_draw_line

line_test_2:
	jsr	resii_graphics_enable
	lda	#$00
	sta	pen_color
	jsr	resii_fill_background
	lda	#$00
	sta	line_x_start
	sta	line_x_start + 1
	sta	line_y_start
	sta	line_x_end
	sta	line_x_end + 1
	lda	#$BF
	sta	line_y_end
	lda	#$01
	sta	use_color
	lda	#$00
	sta	pen_color

lt2_loop:
	jsr	resii_draw_line
	inc	line_x_start
	inc	line_x_end
	lda	line_x_start
	cmp	#$80
	beq	lt2_end
	lsr
	lsr
	lsr
	sta	pen_color
	clc
	bcc	lt2_loop

lt2_end:
	rts

line_test_3:
	jsr	resii_graphics_enable
	lda	#$00
	sta	pen_color
	jsr	resii_fill_background
	lda	#$01
	sta	use_color
	lda	#$00
	sta	y_holder

lt3_loop:
	ldy	y_holder
	lda	lt3_data, Y
	sta	pen_color
	iny
	lda	pen_color
	cmp	#$FF
	bne	lt3_continue
	rts

lt3_continue:
	lda	lt3_data, Y
	sta	line_x_start
	iny
	lda	lt3_data, Y
	sta	line_x_start + 1
	iny
	lda	lt3_data, Y
	sta	line_y_start
	iny
	lda	lt3_data, Y
	sta	line_x_end
	iny
	lda	lt3_data, Y
	sta	line_x_end + 1
	iny
	lda	lt3_data, Y
	sta	line_y_end
	iny
	sty	y_holder
	jsr	resii_draw_line
	clc
	bcc	lt3_loop

lt3_data:
.byte	$F	; Color
.word	1	; Start X
.byte	1	; Start Y
.word	68	; End X
.byte	1	; End Y

.byte	$F
.word	68
.byte	1
.word	68
.byte	94

.byte	$F
.word	68
.byte	94
.word	1
.byte	94

.byte	$F
.word	1
.byte	94
.word	1
.byte	1

.byte	$A
.word	2
.byte	2
.word	67
.byte	93

.byte	$A
.word	2
.byte	93
.word	67
.byte	2

.byte	$E
.word	71
.byte	1
.word	138
.byte	1

.byte	$E
.word	138
.byte	1
.word	138
.byte	94

.byte	$E
.word	138
.byte	94
.word	71
.byte	94

.byte	$E
.word	71
.byte	94
.word	71
.byte	1

.byte	$C
.word	72
.byte	2
.word	137
.byte	93

.byte	$C
.word	72
.byte	93
.word	137
.byte	2

.byte	$B
.word	1
.byte	97
.word	68
.byte	97

.byte	$B
.word	68
.byte	97
.word	68
.byte	190

.byte	$B
.word	68
.byte	190
.word	1
.byte	190

.byte	$B
.word	1
.byte	190
.word	1
.byte	97

.byte	$1
.word	2
.byte	98
.word	67
.byte	189

.byte	$1
.word	2
.byte	189
.word	67
.byte	98

.byte	$7
.word	71
.byte	97
.word	138
.byte	97

.byte	$7
.word	138
.byte	97
.word	138
.byte	190

.byte	$7
.word	138
.byte	190
.word	71
.byte	190

.byte	$7
.word	71
.byte	190
.word	71
.byte	97

.byte	$6
.word	72
.byte	98
.word	137
.byte	189

.byte	$6
.word	72
.byte	189
.word	137
.byte	98

.byte	$FF	; End marker

line_test_4:
	jsr	resii_graphics_enable
	lda	#$00
	sta	pen_color
	jsr	resii_fill_background
	lda	#$00
	sta	use_color
	lda	#$01
	sta	pen_color
	lda	#$00
	sta	line_x_start
	sta	line_x_start + 1
	sta	line_y_start
	sta	line_x_end
	sta	line_x_end + 1
	lda	#$BF
	sta	line_y_end

lt4_loop:
	jsr	resii_draw_line
	clc
	lda	#$0F
	adc	line_x_end
	sta	line_x_end
	lda	#$00
	adc	line_x_end + 1
	sta	line_x_end + 1

	sec
	lda	#$2F
	sbc	line_x_end
	lda	#$02
	sbc	line_x_end + 1
	bcs	lt4_loop

	rts
