
#include <fcntl.h>

/*

When open is used under DOS 3.3, param3 is the file's type:

    Param3,hex    File type

    00            Text
    01            Integer basic
    02            Applesoft basic
    04            Binary
    08            Relocatable
    10            S-type file
    20            A-type file
    40            B-type file

*/


/* the following loads two common non-compressed
   bsaved graphics image formats associated with
   double hires mode... the convention of calling
   the second image a .AUX file is supported in
   this loader when loading a 2 part file... and
   when loading a single file the load is split
   in the middle after loading the first half
   into auxilliary memory */


/* the following array simplifies scanline origin offset
   lookup in the hires screen area...
   HB stands for High-Res Base-Address and is indexed
   sequentially from scanline 0-191 which avoids the
   ubiquituous venetian blind effect that we know and love */
extern unsigned HB[];

/* the following soft switches select between
   upper and lower banks of video memory */
extern char *dhrmain;
extern char *dhraux;



int dlode(name)
char *name;
{
   int fh, status=-2;
   int c, fa = 0, fl = 0;
   int height,packet,jdx,idx;
   char name2[33];


   jdx = 999;
   for (idx = 0; name[idx] != 0; idx++) {
        name2[idx] = name[idx];
		if (name[idx] == '.') jdx = idx;
   }
   name2[idx] = 0;

   if (jdx != 999) name2[jdx] = 0;
   strcat(name2,".AUX");


   fh = open(name,O_RDONLY,4); /* open a binary file */
   if (fh == -1)return -1;

   c = read(fh,&fa,2);
   if (c == 2)c = read(fh,&fl,2);


   switch(fl) {
	   case 16384:
	       /* a single file read to auxilliary memory first */
	       /* switch to auxilliary memory - page2 */
	       *dhraux = 0;
	   case 8192:
	       /* a 2 file image is loaded into main memory first
	          and aux memory second... this is not gospel
	          but simply the way I wrote this */
	       c = read(fh,(char *)HB[0],8192);
		   /* for a single file... */
		   /* switch back to main memory - page1 */
           if (fl == 16384) *dhrmain = 0;
           if (c != 8192)break;

           if (fl == 8192) {
           		close(fh);
           		fh = open(name2,O_RDONLY,4); /* open a binary file */
           		if (fh == -1)return -1;
           		c = read(fh,&fa,2);
           		if (c != 2)break;
           		c = read(fh,&fl,2);
           		if (c!= 2 || fl != 8192) break;
           		*dhraux = 0; /* switch to auxmem and read-in the
           		                  second file */
		   }
           c = read(fh,(char *)HB[0],8192);
           if (fl == 8192) *dhrmain = 0;
           if (c != 8192)break;
           status=0;
		   break;
   }

   close(fh);

   return status;
}
