/* APPLEVU.c by bill buckels 2008         */
/* a slideshow for the apple II           */
/* written in Manx Aztec C65 Version 3.2b */
/* runs under DOS 3.3                     */
/* displays BSaved HIRES Images           */
/* requires a text script called piclist  */


#include <stdio.h>

extern char XPIC;
extern char YPIC;

main()
{
    FILE *fp;
    int idx, bsaved, err=0, c, first = 0;
    char picname[66], R, A, G;;

   /* initialize video */
   setcrtmode(2);
   if (getch() == 27) {
	 err = 1;
   }
   else {
	 if((fp=fopen("PICLIST","r"))==NULL) {
		 err = 2;
	 }
	 else {
		picname[0] = 0;
        fgets(picname,66,fp); /* get the first filename */
		if (picname[0] < 33 || picname[0] > 122)err = 3;
		else black();
	 }
  }

  if (err == 0) {
  	for (;;) {
			bsaved = 1;
			for (idx = 0; picname[idx] != 0; idx++) {

				if (picname[idx] < 33 || picname[idx] > 122) {
				   picname[idx] = 0;
				   break;
				}
				if (picname[idx] != '.')continue;
				R = picname[idx + 1];
				A = picname[idx + 2];
				G = picname[idx + 3];
				if (R == 'R' && A == 'A' && G == 'G') {
					bsaved = 0;
					black();
					break;
				}
				if (R == 'T' && A == 'O' && G == 'P') {
					black();
					bsaved = 0;
					break;
				}
				if (R == 'B' && A == 'O' && G == 'T') {
					bsaved = 0;
					break;
				}
			}
			/* signal centre image on screen */
			XPIC = 40;
			YPIC = 192;
			if (bsaved == 0) c = piclode(picname);
			else c = bload(picname);

			if (c!=0 && first == 0) {
			    err = c;
			    fclose(fp);
			    break;
			}
			first = 1;
			if(c==0) {
				if (getch()==27) {
					fclose(fp);
					break;
				}
			}

            picname[0] = 0;
			fgets(picname,66,fp); /* get the first filename */
		    if (picname[0] < 33 || picname[0] > 122) {
				fclose(fp);
				if((fp=fopen("PICLIST","r"))==NULL) {
						 err = 2;
						 break;
	            }
	            else {
				   fgets(picname,66,fp); /* get the first filename */
				}
			}

	}
  }

  setcrtmode(0);
  scr_apple();
  if (err < 0 || err > 1) {
	  printf("\n");
	  bellerr();
	  switch(err) {
	  case -1: printf("! Can't open %s",picname);break;
	  case -2: printf("! %s wrong format!",picname);break;
	  case 2: printf("! Can't open PICLIST"); break;
	  case 3: printf("! Error Reading PICLIST"); break;
	  default: break;
	  }
	  printf("\nPress Any Key...");
	  getch();
  }
  reboot();
}
