
/* This demo program is loosely based on the following version of
   Rod's Color Pattern in C by Dr. John B. Matthews:

   http://home.roadrunner.com/~jbmatthews/apple2.html#rp1c

   Which in turn is based on Rod's Color Pattern, written in Basic
   by Randy Wigginton, which originally appeared on page 55 of the Red Book
   distributed by Apple Computer, Inc. circa 1978. It was described as
   "a simple but eloquent program. It generates a continuous flow of colored
   mosaic-like patterns in a 40 high by 40 wide block matrix.
   Many of the patterns generated by this program are pleasing to the eye
   and will dazzle the mind for minutes at a time."

   At any rate this particular version sets pixels directly in the
   lores display (using the library function setlopixel) rather than
   use the monitor routines.

   Bill Buckels
   December 2009

 */



#include <g3.h>



lrod ()
{

    int i, j, k, w, fmi, fmk, color, c=0;

	for (w = 3; w < 51; w++) {
		for (i = 1; i < 20; i++) {
			for (j = 0; j < 20; j++) {
				k = i + j;
				color = (j * 3) / (i + 3) + i * w / 12;
				fmi = 40 - i;
				fmk = 40 - k;
				setlopixel(color, i, k, 0);
				setlopixel(color, k, i, 0);

				setlopixel(color, fmi, fmk, 0);
				setlopixel(color, fmk, fmi, 0);

				setlopixel(color, k, fmi, 0);
				setlopixel(color, fmi, k, 0);

				setlopixel(color, i, fmk, 0);
				setlopixel(color, fmk, i, 0);
				if ((c = kbhit()) > 0) {
					clearkey();
					return c-128;

				}
			}
		}
	}

	if ((c = kbhit()) > 0) {
		clearkey();
		c-=128;
	}
	return c;

}



main()
{


    setcrtmode(LORES);
    clearkey();
    for (;;) {
        loclear();
		if (lrod()==27)break;

    }
    loclear();
	setcrtmode(TEXTMODE);
	scr_apple();
	reboot();

}



