/* converts binary musical files of type .SND   */
/* to character arrays for embedding in C code  */
/* a binary file of the array is also created.  */
/* the output files are music macros for the apple II */


#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>

char far *soundbuffer;

#define S_IWRITE    0000200     /* write permission, owner   */

int makefile(char *filename,int length)
{
int fh;

if((fh = open(filename,O_CREAT|O_TRUNC|O_WRONLY|O_BINARY,S_IWRITE)) == -1)
        return 0;
    write(fh,(char *)&soundbuffer[0],length);
    if(close(fh) == -1)
    return 0;
}

int xplay(int xfrequency)
{
  if(xfrequency < 64 || xfrequency > 4096 )
  {
    /* if we are out of range don't play anything */
    return -1;
  }

  /* octave 0 */
  if(xfrequency<127)
  {
  if(xfrequency<67 ) return  0 ;
  if(xfrequency<71 ) return  1 ;
  if(xfrequency<76 ) return  2 ;
  if(xfrequency<80 ) return  3 ;
  if(xfrequency<85 ) return  4 ;
  if(xfrequency<90 ) return  5 ;
  if(xfrequency<96 ) return  6 ;
  if(xfrequency<101) return  7 ;
  if(xfrequency<107) return  8 ;
  if(xfrequency<114) return  9 ;
  if(xfrequency<120) return  10;
                     return  11;
  }

  /* first octave */
  if(xfrequency<255)
  {
  if(xfrequency<136) return  12;
  if(xfrequency<143) return  13;
  if(xfrequency<152) return  14;
  if(xfrequency<160) return  15;
  if(xfrequency<170) return  16;
  if(xfrequency<180) return  17;
  if(xfrequency<190) return  18;
  if(xfrequency<202) return  19;
  if(xfrequency<215) return  20;
  if(xfrequency<227) return  21;
  if(xfrequency<240) return  22;
                     return  23;
  }

  /* second octave */
  if(xfrequency<512)
  {
   if(xfrequency<270)return 24;
   if(xfrequency<286)return 25;
   if(xfrequency<304)return 26;
   if(xfrequency<322)return 27;
   if(xfrequency<340)return 28;
   if(xfrequency<360)return 29;
   if(xfrequency<382)return 30;
   if(xfrequency<406)return 31;
   if(xfrequency<428)return 32;
   if(xfrequency<454)return 33;
   if(xfrequency<480)return 34;
                     return 35;
   }

   /* third octave */

  if(xfrequency<1024)
  {
  if(xfrequency<540)return 36 ;
  if(xfrequency<572)return 37 ;
  if(xfrequency<605)return 38 ;
  if(xfrequency<643)return 39 ;
  if(xfrequency<680)return 40 ;
  if(xfrequency<720)return 41 ;
  if(xfrequency<765)return 42 ;
  if(xfrequency<810)return 43 ;
  if(xfrequency<855)return 44 ;
  if(xfrequency<910)return 45 ;
  if(xfrequency<965)return 46 ;
                    return 47 ;
  }

  /* fourth octave */

  if(xfrequency<2048)
  {
  if(xfrequency<1080) return  48;
  if(xfrequency<1144) return  49;
  if(xfrequency<1210) return  50;
  if(xfrequency<1286) return  51;
  if(xfrequency<1340) return  52;
  if(xfrequency<1440) return  53;
  if(xfrequency<1530) return  54;
  if(xfrequency<1620) return  55;
  if(xfrequency<1710) return  56;
  if(xfrequency<1820) return  57;
  if(xfrequency<1930) return  58;
                      return  59;
  }

  /* fifth octave */
  /* sixth octave ignored */
   if(xfrequency<2160)return 60;
   if(xfrequency<2288)return 61;
   if(xfrequency<2420)return 62;
   if(xfrequency<2572)return 63;
   if(xfrequency<2680)return 64;
   if(xfrequency<2880)return 65;
   if(xfrequency<3060)return 66;
   if(xfrequency<3240)return 67;
   if(xfrequency<3420)return 68;
   if(xfrequency<3640)return 69;
   if(xfrequency<3860)return 70;
                      return 71;

}

main(int argc, char *argv[])
{
   FILE *fp,*fp2;
   char *wordptr;
   char *ptr;
   long target;
   unsigned utarget;
   int bincounter=0;
   int *intptr;

   int octave, note;
   int frequency,duration,counter=0;
   char scratchbuffer[128],writebuffer[128],binbuffer[128];

   if(argc!=2)
   {
    printf("SND filename required...");
    exit(0);
    }

   if((fp=fopen(argv[1],"rb"))==NULL)
   {
    perror(argv[1]);
    exit(0);
    }



   strcpy(scratchbuffer,argv[1]);
   wordptr=strtok(scratchbuffer,".");
   sprintf(writebuffer,"%s.TXT",scratchbuffer);
   sprintf(binbuffer,"%s.BIN",scratchbuffer);

   fp2=fopen(writebuffer,"w");


        target=filelength(fileno(fp))+8;
        utarget = (unsigned )target;
        soundbuffer = _fmalloc(utarget);
        memset(soundbuffer,0,utarget);
        ptr= (char *)&soundbuffer[2];

   fprintf(fp2,
   "/* musical array created from file %s */\n",argv[1]);
   fprintf(fp2,
   "/* array structure is octave, note, duration */\n");
   fprintf(fp2,
   "char %s[]={\n",scratchbuffer);

    while((frequency=getw(fp))!=-1){
         duration=fgetc(fp);

         if (duration == 0)continue;

         if((frequency=xplay(frequency))<0)
         {
            octave=7;
            note  =0;
         }
         else
         {
            octave = frequency/12;
            note   = frequency%12;
        }
         fprintf(fp2,"%2d, %2d, %2d,",octave,note,duration);

         *ptr++=(char)octave;
         *ptr++=(char)note;
         *ptr++=(char)duration;
         bincounter+=3;

         counter++;
         if(counter==6){
            fprintf(fp2,"\n");
            counter=0;
         }
         }


   /* use 255 as the terminator... used to be -1 which is not a char */
   fprintf(fp2,"\n\'\\xff\',\'\\xff\',\'\\xff\'};\n",scratchbuffer);

         *ptr++='\xff';
         *ptr++='\xff';
         *ptr++='\xff';
         bincounter+=3;

   fclose(fp);
   fclose(fp2);
   intptr=(int *)&soundbuffer[0];
   *intptr=bincounter;
   makefile(binbuffer,bincounter+2);
   _ffree(soundbuffer);
   exit(0);

}


