/*

METOO and MOIAUSSI! (C) Copyright Bill Buckels 1990 - 2008.
All rights reserved.
Apple //e ProDOS 8 Version 2.0

Written in Manx Aztec C65 Version 3.2b
MS-DOS cross-development environment

*/

/* header */

#include <stdio.h>
#include <fcntl.h>
#include <prodos.h>
#include <sgtty.h>
#include <device.h>
#include <sysfunc.h>

#define TEXTMODE  0
#define GRAFMODE  2  /* graphics only */

/* mouse cordinates */
#define MXMAX 1023
#define MYMAX 1023

#define bronx() sound(0,0,3)
#define happy() sound(3,0,1)
#define wait() sound(7,0,10)
/* 82 pictures so randomization must be in the range 0-81 */
/* the first six values are incremented in-synch so no duplicates in the set */

#ifdef CMAIN
int randomseed[7] = {0,13,26,39,52,65,78};
#else
extern int randomseed[7];
#endif

/* special keys as noted */
/* note that none of the special keys used are affected by caps lock */

#define ESCKEY     27        /* exit current module */
#define ENTERKEY   13        /* initialize command  */
#define SPACEBAR   32        /* same as ENTERKEY    */
#define SOUNDKEY   19        /* sound toggle */

#ifdef CMAIN
int language;
int multiples = 3;
int song_idx = 0;
int mousebutton,mousex,mousey;
/* a global flag for program management */
/* must be set to 0 if mouse exists     */
unsigned char mouseflag=1;
char *KEYPRESS = (char*)0xC000;
char *KEYCLEAR = (char*)0xC010;
#else
extern int language;
extern int multiples;
extern int song_idx;
extern int mousebutton,mousex,mousey;
extern unsigned char mouseflag;
extern char *KEYPRESS;
extern char *KEYCLEAR;
#endif

/* the limits for the multiple choices - default is set to 3 */
/* pressing the number 3 or 6 prior to pressing the spacebar       */
/* or the enter key will flipflop between levels                   */

#define THREE      51
#define SIX        54

#define BACKSPACE  8
#define LEFTARROW  8
#define RIGHTARROW 21
#define UPARROW    11
#define DOWNARROW  10
#define DELETE     127
#define CTRLKEY    -64  /* toupper - 64 = ctrl value of a key press */

#define ON  1
#define OFF 0

#ifdef CMAIN
int soundflag = ON;
#else
extern int soundflag;
#endif

#define ENGLISH 0
#define FRENCH  1

#define PUT 0    /* action verbs for putimage */
#define GET 1
#define P_STIX  2
#define P_BLACK 3
#define P_WHITE 4
#define P_AND   5
#define P_XOR   6


/* the auxmem (ems) library info */
/* graphics library map for library TIME.RIB */

#define ME2_SIZE 17484 /* library size in bytes */

/* lib info for character array created from fragment MENU.RAG */
#define MENU_WIDTH  40
#define MENU_HEIGHT 33
#define MENU_OFFSET 0

/* lib info for character array created from fragment MENUB.RAG */
#define MENUB_WIDTH  40
#define MENUB_HEIGHT 82
#define MENUB_OFFSET 1320

/* lib info for character array created from fragment MENUT.RAG */
#define MENUT_WIDTH  40
#define MENUT_HEIGHT 81
#define MENUT_OFFSET 4600

/* lib info for character array created from fragment SHOW.RAG */
#define SHOW_WIDTH  40
#define SHOW_HEIGHT 19
#define SHOW_OFFSET 7840

/* lib info for character array created from fragment SPIN.RAG */
#define SPIN_HEIGHT 95
#define SPIN_OFFSET 8600

/* lib info for character array created from binary file NAM.BIN */
#define NAM_SIZE   1312
#define NAM_OFFSET 12400
#define NAM_LEN    16

/* lib info for character array created from binary file SEN.BIN */
#define SEN_OFFSET 13712
#define SEN_LEN    40

/* lib info for character array created from binary file ARF.BIN */
#define ARF_OFFSET 16992
#define ARF_LEN    6

/* lib info for character array created from fragment S0.RAG */
#define MINI_SIZE   676
#define MINI_WIDTH  13
#define MINI_HEIGHT 52
#define S0_OFFSET 17484

/* lib info for character array created from fragment S1.RAG */
#define S1_OFFSET 18160

/* lib info for character array created from fragment S2.RAG */
#define S2_OFFSET 18836

/* lib info for character array created from fragment S3.RAG */
#define S3_OFFSET 19512

/* lib info for character array created from fragment S4.RAG */
#define S4_OFFSET 20188

/* lib info for character array created from fragment S5.RAG */
#define S5_OFFSET 20864

#define clearscreen() setmem(0x4000,0x2000,0x80)

#define CURSORS_SIZE 2228 /* library size in bytes */

/* lib info for character array created from fragment NOTE.RAG */
#define NOTE_SIZE   44
#define NOTE_WIDTH  2
#define NOTE_HEIGHT 22
#define NOTE_OFFSET 0

/* lib info for character array created from fragment RWORM.RAG */
#define WORM_WIDTH  10
#define WORM_HEIGHT 46
#define RWORM_OFFSET 44

/* lib info for character array created from fragment LWORM.RAG */
#define LWORM_OFFSET 504

/* lib info for character array created from fragment N1.RAG */
#define NUM_SIZE   76
#define NUM_WIDTH  4
#define NUM_HEIGHT 19
#define N1_OFFSET 964

/* lib info for character array created from fragment N2.RAG */
#define N2_OFFSET 1040

/* lib info for character array created from fragment N3.RAG */
#define N3_OFFSET 1116

/* lib info for character array created from fragment N4.RAG */
#define N4_OFFSET 1192

/* lib info for character array created from fragment N5.RAG */
#define N5_OFFSET 1268

/* lib info for character array created from fragment N6.RAG */
#define N6_OFFSET 1344

/* lib info for character array created from fragment N7.RAG */
#define N7_OFFSET 1420

/* lib info for character array created from fragment N8.RAG */
#define N8_OFFSET 1496

/* lib info for character array created from fragment N9.RAG */
#define N9_OFFSET 1572

/* lib info for character array created from fragment N10.RAG */
#define N10_OFFSET 1648

/* lib info for character array created from fragment NOTEBACK.RAG */
#define NOTEBACK_OFFSET 1724

/* lib info for character array created from fragment WORMBACK.RAG */
#define WORMBACK_OFFSET 1768

/* screen coordinates */
#define NOTEX 38
#define NOTEY 169

/* pointer to the base address of the library    */
/* use globals... avoid initializing common data */
/* repeatedly... */
#ifdef CMAIN
char *CURSORS=(char *)4192;
char *NOTE;
char *NOTEBACK;
char *WORMBACK;
char *LEFTWORM;
char *RIGHTWORM;
int picpos[6][3] = { 0, 5,0, 13,5, 1, 26, 5, 2,
                     0,67,3, 13,67,4, 26,67, 5};
int senpos[3][3] = { 0, 2, 0, 0,55, 1, 0, 108, 2};

#else
extern char *CURSORS;
extern char *NOTE;
extern char *NOTEBACK;
extern char *WORMBACK;
extern char *LEFTWORM;
extern char *RIGHTWORM;
extern int picpos[6][3];
extern int senpos[3][3];
#endif

#define NUM_CHOICES 82

#define BLACK 0
#define BLUE 1
#define ORANGE 2
#define WHITE 3