/*

METOO and MOIAUSSI! (C) Copyright Bill Buckels 1990 - 2008.
All rights reserved.
Apple //e ProDOS 8 Version 2.0

Written in Manx Aztec C65 Version 3.2b
MS-DOS cross-development environment

*/

/* word match */

#include "me2.h"

int seny[4] = {24,77,130,163};
int px, sx, plen, slen;

char prefix[40];
char suffix[40];

ovmain(answers)
int answers;
{
  int idx;
  int c, pos=0, oldpos=0, action, mychoice;
  int y1, y2, arrowflag;

  arrowflag = 0;
  y1 = (MYMAX / 191) * senpos[1][1];
  y2 = (MYMAX / 191) * senpos[2][1];

  /* override for modules 3 and 4 */
  /* only one round of play */
  /* only 3 minipix */
  answers=10;
  multiples=3;

  layout(4);

  /* if a mouse is in use set the
     initial position based on the mouse */
  if (mouseflag == 0) {
	  cmouse();
      if (mousey > y1) pos =  1;
      if (mousey > y2) pos =  2;
      oldpos = pos;
  }

  for (;;) {

      mychoice = randomchoice();
      makecursor(randomseed[mychoice]);

      for (idx = 0; idx < multiples; idx++) {
	     loadmini(randomseed[idx], idx);
	     senpos[idx][2] = randomseed[idx];
	     if (idx == pos) action = PUT;
	     else action = P_XOR;
	     showmany(idx, action, idx);
	  }
      shownoun(senpos[pos][2],0);
      showcursor(pos,0);


      for (;;) {

		  c = kbhit();
		  if (c!=0)kbclear();

		  /* break on ESCAPE, SPACE, or ENTER */
		  if (c == 27 || c == 32 || c == 13)break;

		  switch(c) {
			case UPARROW:    pos --;
			                 if (pos < 0)pos+=3;
			                 arrowflag = 1;
			                 break;
			case DOWNARROW:
                             pos ++;
                             if (pos > 2)pos-=3;
                             arrowflag = 1;
                             break;

            default:         if (mouseflag != 0 || arrowflag != 0) break;
            				 pos = 0;
            				 if (mousey > y1) pos =  1;
                             if (mousey > y2) pos =  2;


		  }
          /* if position changes update the selected image */
		  if (pos != oldpos) {
		     showmany(oldpos, P_XOR, oldpos);
		     showcursor(oldpos,1);
		     shownoun(0,1);
		     showmany(pos, PUT, pos);
		     showcursor(pos,0);
		     shownoun(senpos[pos][2],0);
		     oldpos = pos;
		  }



	  }
      /* quit on ESCAPE */
	  if (c == 27)break;

	  if (pos == mychoice) {
        shownumber(answers);
        answers++;
        if (answers==20) return answers;
	  }
	  else {
		  if(soundflag)bronx();
	  }

	  showmany(0, P_BLACK, 0);
	  showmany(1, P_BLACK, 2);
	  showmany(2, P_BLACK, 2);
	  shownoun(0,1); /* erase old text */
	  showcursor(pos,1);

  }

  return 0;
}

/* used by sentence module only */
shownoun(choice, erase)
int choice, erase;
{
   char buffer[NAM_LEN];
   unsigned base;
   int x, y;


	y = seny[3];
	x = senpos[0][0];

	if (erase) {
		hbar(y,x, BLACK,NAM_LEN,8);
	}
	else {

		base = NAM_OFFSET + (choice * NAM_LEN);
		emsget(base,&buffer[0],16);
		plots2(buffer,x,y,1);
	}

}

/* used by sentence module only */
showcursor(pos, erase)
int pos, erase;
{
   int y;

   y = seny[pos];

   if (erase) {
	   hbar(y,px, BLACK,plen,8);
	   hbar(y,sx, BLACK,slen,8);

   }
   else {
	   plots2(prefix,px,y,1);
	   plots2(suffix,sx,y,1);
   }

}

/* used by sentence module only */
makecursor(choice)
int choice;
{
	unsigned base;
	int idx, jdx;

	base = SEN_OFFSET + (choice * SEN_LEN);
	emsget(base,&prefix[0],SEN_LEN);

	suffix[0] = 0;
	jdx = 999;

	for (idx = 0; prefix[idx] != 0; idx++) {
		if (prefix[idx] == '#') {
			prefix[idx] = 0;
			jdx = idx;
		}
	}
	if (jdx != 999) {
		jdx++;
		base += jdx;
		emsget(base,&suffix[0],SEN_LEN-jdx);
	}

	plen = strlen(prefix);
	slen = strlen(suffix);

	idx = plen + 13 + slen;
	px = (39 - idx)/2;

	senpos[0][0] = px + plen;
	senpos[1][0] = px + plen;
	senpos[2][0] = px + plen;

	sx = px + plen + 13;

}

/* used by sentence module only */
showmany(position, action, bufoff)
int position, action, bufoff;
{
	int buffer, x, y;

	buffer = S0_OFFSET + (bufoff * MINI_SIZE);

    x = senpos[position][0];
    y = senpos[position][1];

	emsputimage(buffer,MINI_WIDTH,MINI_HEIGHT,x,y,action);
}