/*

METOO and MOIAUSSI! (C) Copyright Bill Buckels 1990 - 2008.
All rights reserved.
Apple //e ProDOS 8 Version 2.0

Written in Manx Aztec C65 Version 3.2b
MS-DOS cross-development environment

*/

/* title and splash screen display module */
/* musical and animated opening/closing sequences */

/* we are somewhat limited here due to our lack of a  */
/* timer and also due to our 1 mghz processor speed   */

/* the CINIT.OVR is called to set to graphics mode and */
/* load the font prior to this module being called. */

#include "me2.h"

extern char XPIC;
extern char YPIC;

char *pressmess[2]={"PRESS \"ESCAPE\" TO EXIT OR",
                    "APPUYEZ SUR \"ESC\" POUR QUITTER OU"};

char *pressmess2[2]={"ANY OTHER KEY TO CONTINUE",
                     "SUR UNE TOUCHE AUTRE POUR CONTINUER"};


int credits()
{
  int temp, temp2, x, l;


  hbar(174,0, BLACK,MENU_WIDTH,18);

  l = strlen(pressmess[language]);
  temp=(39-l)/2;
  l = strlen(pressmess2[language]);
  temp2=(39-l)/2;

  plots2(pressmess[language],temp,174,1);
  plots2(pressmess2[language],temp2,182,1);

  x = getch();

  hbar(174,0, BLACK,MENU_WIDTH,8);
  hbar(182,0, BLACK,MENU_WIDTH,8);

  return (x);
}


/* arguments of auxmem (ems) library name and image name */
/* uses plots2 for the message                  */

char *waitmess[2]={"ONE MOMENT PLEASE",
                   "UN MOMENT S.V.P."};

ovmain(libname,libsize)
char *libname;
unsigned libsize;
{
  int c,l;
  int temp;
  char d;
  int emscheck();
  int emslode();

  language=ENGLISH;

  c = open("LANG.TXT",O_RDONLY,0xc3);
  if (c!= -1) {
    read(c,&d,1);
    close(c);
    if (d == 'F' || d == 'f')language=FRENCH;
  }

  /* if the library is already in upper ram don't worry */
  if(emscheck(libname)==0)
  {

    /* if there is a problem don't continue */
    l = strlen(waitmess[language]);
    temp=(39-l)/2;

    plots2(waitmess[language],temp,174,1);
    c=emslode(libname,libsize);
    hbar(174,0, BLACK,MENU_WIDTH,8);

     if(c==-3||c==-1) {
		return 27;
	 }
   }

   /* a keypress value will be returned from the animation sequence */
   c = pomp();

   /* if no keypresses or mouse button presses
      have occurred during the animation sequence
      we need to provide a prompt that allows
      an exit prior to reaching the main menu */
   if (c==0) c=credits();

  /* clean-up if we are leaving */
  if(c==27)
  {
      emsoff();
  }

  return(c);

}

titleload()
{
    int fh;

    fh = open("OLDIES.BIN",O_RDONLY,0xc3);
    read(fh,(char *)0x4000,0x2000);
    close(fh);
    return 0;
}



/* musical and animated opening/closing sequences */

/* musical arrays created from file pomp.snd */
/* array structure is octave, note, duration  */
/* 19 components - 1 for each screen cell     */

/* each musical array is played following the placement    */
/* of the corresponding animation cell. this allows the    */
/* image to seat onto the phosphor for the viewer because  */
/* of the time gap while the music is played. thus creates */
/* the required dwell effect and avoids perceived flicker. */


char pomp0[]={
 3,  7, 14,
 3,  6,  3,
 3,  7,  3,
 3,  9,  7, '\xff', '\xff', '\xff'};
char pomp1[]={
 3,  4, 14,
 3,  2, 14, '\xff', '\xff', '\xff'};

char pomp2[]={
 3,  0, 14,
 2, 11,  3,
 3,  0,  3,
 3,  2,  7, '\xff', '\xff', '\xff'};
char pomp3[]={
 2,  9, 28, '\xff', '\xff', '\xff'};

char pomp4[]={
 2, 11, 14,
 3,  1,  3,
 3,  2,  7,
 3,  4,  3, '\xff', '\xff', '\xff'};
char pomp5[]={
 3,  9, 14,
 3,  2, 14, '\xff', '\xff', '\xff'};

char pomp6[]={
 3,  7, 14,
 3,  7,  3,
 3,  6,  7,
 3,  4,  3, '\xff', '\xff', '\xff'};
char pomp7[]={
 3,  2, 28, '\xff', '\xff', '\xff'};

char pomp8[]={
 3,  7, 14,
 3,  6,  3,
 3,  7,  3,
 3,  9,  7, '\xff', '\xff', '\xff'};
char pomp9[]={
 3,  4, 14,
 3,  2, 14, '\xff', '\xff', '\xff'};

char pomp10[]={
 3,  0, 14,
 2, 11,  3,
 3,  0,  3,
 3,  2,  7, '\xff', '\xff', '\xff'};
char pomp11[]={
 2,  9, 28, '\xff', '\xff', '\xff'};

char pomp12[]={
 2, 11, 14,
 3,  1,  3,
 3,  2,  7,
 3,  4,  3, '\xff', '\xff', '\xff'};
char pomp13[]={
 3,  9, 14,
 3,  2, 14, '\xff', '\xff', '\xff'};

char pomp14[]={
 4,  0, 14,
 4,  0,  3,
 3, 11,  7,
 3,  9,  3, '\xff', '\xff', '\xff'};
char pomp15[]={
 3, 11,  7,
 3,  7,  7,
 3,  6,  7,
 3,  5,  7, '\xff', '\xff', '\xff'};

char pomp16[]={
 3,  4, 14,
 3,  6,  3,
 3,  7,  7,
 3,  9,  3, '\xff', '\xff', '\xff'};
char pomp17[]={
 3,  2, 14,
 3,  7, 14, '\xff', '\xff', '\xff'};

char pomp18[]={
 2,  7, 14,
 3,  0,  3,
 2, 11,  7,
 2,  9,  3,
 2,  7, 28, '\xff', '\xff', '\xff'};

#define WIDE 6
#define NARROW 4
#define HEIGHT 16


/* 1. WIDE CELLS */
/* animation cells a1-a4 have 14 pixels of black on the         */
/* trailing edge to blot the visible image of the previous cell */
/* the applicable animation rate is 14-pixels per iteration.    */
/* the image portion of animation cells is 28 pixels wide.      */
/* each cell is 16 rasters deep.                                */

char a1[]={
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x8F,
0x80, 0x80, 0x80, 0xBE, 0xC0, 0x93,
0x80, 0x80, 0xFC, 0xFF, 0xFF, 0x9F,
0x80, 0x80, 0xFE, 0xFF, 0xFF, 0x8F,
0x80, 0x80, 0xFE, 0xFF, 0xFF, 0x87,
0x80, 0x80, 0xFC, 0xC3, 0xFF, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80};


char a2[]={
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0xBE, 0x80, 0x80,
0x80, 0x80, 0xE0, 0xFF, 0x81, 0x8F,
0x80, 0x80, 0xF8, 0xFF, 0xDF, 0x93,
0x80, 0x80, 0xFC, 0xFF, 0xFF, 0x9F,
0x80, 0x80, 0xFC, 0xC3, 0xFF, 0x8F,
0x80, 0x80, 0x98, 0x80, 0xFE, 0x87,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80};


char a3[]={
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0xBE, 0x80, 0x80,
0x80, 0x80, 0x80, 0xFF, 0x81, 0x80,
0x80, 0x80, 0xC0, 0xFF, 0x81, 0x8F,
0x80, 0x80, 0xF0, 0xFF, 0xDF, 0x93,
0x80, 0x80, 0xF8, 0xC3, 0xFF, 0x9F,
0x80, 0x80, 0xF8, 0x80, 0xFE, 0x8F,
0x80, 0x80, 0xF0, 0x80, 0xF8, 0x87,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80};


char a4[]={
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x8F, 0x80, 0x80,
0x80, 0x80, 0xC0, 0xBF, 0x80, 0x80,
0x80, 0x80, 0xE0, 0xFF, 0x80, 0x80,
0x80, 0x80, 0xE0, 0xFF, 0x81, 0x8F,
0x80, 0x80, 0xF0, 0xF3, 0xC3, 0x93,
0x80, 0x80, 0xF0, 0xC1, 0xFF, 0x9F,
0x80, 0x80, 0xF0, 0xC1, 0xFF, 0x8F,
0x80, 0x80, 0xE0, 0x80, 0xFE, 0x87,
0x80, 0x80, 0x80, 0x80, 0xF0, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80, 0x80, 0x80};


/* 2. NARROW CELLS */
char b1[]={
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x8F,
0x80, 0xBE, 0xC0, 0x93,
0xFC, 0xFF, 0xFF, 0x9F,
0xFE, 0xFF, 0xFF, 0x8F,
0xFE, 0xFF, 0xFF, 0x87,
0xFC, 0xC3, 0xFF, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80};


char b2[]={
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0xBE, 0x80, 0x80,
0xE0, 0xFF, 0x81, 0x8F,
0xF8, 0xFF, 0xDF, 0x93,
0xFC, 0xFF, 0xFF, 0x9F,
0xFC, 0xC3, 0xFF, 0x8F,
0x98, 0x80, 0xFE, 0x87,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80};


char b3[]={
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0xBE, 0x80, 0x80,
0x80, 0xFF, 0x81, 0x80,
0xC0, 0xFF, 0x81, 0x8F,
0xF0, 0xFF, 0xDF, 0x93,
0xF8, 0xC3, 0xFF, 0x9F,
0xF8, 0x80, 0xFE, 0x8F,
0xF0, 0x80, 0xF8, 0x87,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80};


char b4[]={
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x8F, 0x80, 0x80,
0xC0, 0xBF, 0x80, 0x80,
0xE0, 0xFF, 0x80, 0x80,
0xE0, 0xFF, 0x81, 0x8F,
0xF0, 0xF3, 0xC3, 0x93,
0xF0, 0xC1, 0xFF, 0x9F,
0xF0, 0xC1, 0xFF, 0x8F,
0xE0, 0x80, 0xFE, 0x87,
0x80, 0x80, 0xF0, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80,
0x80, 0x80, 0x80, 0x80};


/* coordinates for base placement of each animation cell */
int pompcords[19]={
    0,   0, 2,  4,
    6,   8, 10, 12,
    14, 16, 18, 20,
    22, 24, 26, 28,
    30, 32, 34};



pomp()
{

   /* pomp and circumstance */
   char *pomp,*circ;
   int p_count,c_count,x,y=176,width;
   char c;
   int retval,i;

 /* load the title initially */
 titleload();

 for(c_count=0;c_count<2;c_count++)
 {

    /* load the title second time through */
    /* the bottom of the title erases the previous animation
       if a picture was left on the screen */
   if(c_count==1)
   {
        XPIC=0;
        YPIC=0;
        piclode("PLOGO.RAG");
   }

   for(p_count=0;p_count<19;p_count++)
   {
       /* get the xdimension */
       x=pompcords[p_count];
       width=WIDE;

       /* use p_count to reference our screen position (19 cells)       */
       /* point to the appropriate portion of the music (19 variations) */
       /* and to the appropriate animation cell (4 variations, 2 sizes) */
       switch(p_count)
       {
                  /* case 0 : the image at the left edge does not   */
                  /* blot the previous image. use the narrow image. */
           case 0 :width=NARROW;
                   pomp=(char *)&pomp0[0];  circ=(char *)&b1[0];break;
           case 4 :pomp=(char *)&pomp4[0];  circ=(char *)&a1[0];break;
           case 8 :pomp=(char *)&pomp8[0];  circ=(char *)&a1[0];break;
           case 12:pomp=(char *)&pomp12[0]; circ=(char *)&a1[0];break;
           case 16:pomp=(char *)&pomp16[0]; circ=(char *)&a1[0];break;

           case 1 :pomp=(char *)&pomp1[0];  circ=(char *)&a2[0];break;
           case 5 :pomp=(char *)&pomp5[0];  circ=(char *)&a2[0];break;
           case 9 :pomp=(char *)&pomp9[0];  circ=(char *)&a2[0];break;
           case 13:pomp=(char *)&pomp13[0]; circ=(char *)&a2[0];break;
           case 17:pomp=(char *)&pomp17[0]; circ=(char *)&a2[0];break;

           case 2 :pomp=(char *)&pomp2[0];  circ=(char *)&a3[0];break;
           case 6 :pomp=(char *)&pomp6[0];  circ=(char *)&a3[0];break;
           case 10:pomp=(char *)&pomp10[0]; circ=(char *)&a3[0];break;
           case 14:pomp=(char *)&pomp14[0]; circ=(char *)&a3[0];break;
           case 18:pomp=(char *)&pomp18[0]; circ=(char *)&a3[0];break;

           case 3 :pomp=(char *)&pomp3[0];  circ=(char *)&a4[0];break;
           case 7 :pomp=(char *)&pomp7[0];  circ=(char *)&a4[0];break;
           case 11:pomp=(char *)&pomp11[0]; circ=(char *)&a4[0];break;
           case 15:pomp=(char *)&pomp15[0]; circ=(char *)&a4[0];break;
        }

   /* do it here */
   putimage(circ,width,HEIGHT,x,y,PUT);
   if( (retval=keyplay(pomp))!=0 )p_count=19;

   }

   /* go back for another round */
   /* the escape key can be pressed on the first screen
      without exiting the program */
   }

return retval;
}

