/* (C) Copyright 2008 Bill Buckels */

/* What Time is It - Apple Version by Bill Buckels */
/* main menu module */

/* June, 1991         */
/* version 1.0        */
/* English Modules... */
/* French Modules followed shortly thereafter */

#include <stdio.h>
#include <fcntl.h>
#include <prodos.h>
#include <sgtty.h>
#include <device.h>
#include <sysfunc.h>


extern int randomseed;
extern int hourslimit;

int getch();

/* special keys as noted */
/* note that none of the special keys used are affected by caps lock */

#define ESCKEY     27        /* exit current module */
#define ENTERKEY   13        /* initialize command  */
#define SPACEBAR   32        /* same as ENTERKEY    */
#define SOUNDKEY   19        /* sound toggle */

#define THREE      51
#define FIVE       53
extern int multiples;

/* the limits for the multiple choices - default is set to 3 boxes */
/* pressing the number 3 or 5 prior to pressing the spacebar       */
/* or the enter key will flipflop between levels                   */

#define BACKSPACE  8
#define LEFTARROW  8
#define RIGHTARROW 21
#define UPARROW    11
#define DOWNARROW  10
#define DELETE     127
#define CTRLKEY    -64  /* toupper - 64 = ctrl value of a key press */


#define PUT 0    /* action verbs for putimage */
#define GET 1
#define P_AND 5

ovmain(position)
int position;
{

/* a pointer to the library buffer in memory */
extern char *SNAIL;

#define SNAIL_SIZE 1522 /* library size in bytes */

#define SNL_SIZE   350
#define SNL_WIDTH  10
#define SNL_HEIGHT 35

extern char *SNLBACK;
extern char *LEFTSNL;
extern char *RIGHTSNL;

   int c,newx,newy,oldx,oldy;

   /* set the startup flag and save the screen beneath position 0  */
   /* then put the first snail in place and move him based on the  */
   /* keys that are pressed                                        */
   /* return the position at the cursor if enter is pressed        */

   liblode("SNAIL.RIB",SNAIL_SIZE);

   newx=10;newy=44;

   if(position ==1)newx = 20;
   if(position ==2)newy = 80+32;

   oldx = newx;
   oldy = newy;

   putimage(SNLBACK,SNL_WIDTH,SNL_HEIGHT,newx,newy,GET);
   if(newx == 10)
      putimage(LEFTSNL,SNL_WIDTH,SNL_HEIGHT,
      newx,newy,P_AND);
   else
      putimage(RIGHTSNL,SNL_WIDTH,SNL_HEIGHT,
      newx,newy,P_AND);
   noteworthy(1);

   while ((c=getch())!=ESCKEY)
   {

        switch(c)
        {
            case FIVE      :  multiples = 5;break;
            case THREE     :  multiples = 3;break;
            case SOUNDKEY  :  noteworthy(0);   break;


            case SPACEBAR  :
            case ENTERKEY  :  if(newx==10)
                              {
                                if(newy==44)position=0;
                                else position=2;
                                }
                              else
                              {
                                if(newy==44)position=1;
                                else
                                    position=3;
                                }

                              return position;


            case UPARROW   :
            case DOWNARROW :
            case LEFTARROW :
            case RIGHTARROW:  /* clear arrow keys */
                              if(c==UPARROW)  newy=44;
                              if(c==DOWNARROW)newy=80+32;
                              if(c==LEFTARROW )newx=10;
                              if(c==RIGHTARROW)newx=20;

                              /* update screen for arrow key change */
                              if(newy!=oldy || newx != oldx)
                              {
                              /* restore the screen */
                              putimage(SNLBACK,SNL_WIDTH,SNL_HEIGHT,
                                               oldx,oldy,PUT);
                              /* store the screen */
                              putimage(SNLBACK,SNL_WIDTH,SNL_HEIGHT,
                                               newx,newy,GET);
                              if(newx == 10)
                                 putimage(LEFTSNL,SNL_WIDTH,SNL_HEIGHT,
                                                 newx,newy,P_AND);
                              else
                                 putimage(RIGHTSNL,SNL_WIDTH,SNL_HEIGHT,
                                                 newx,newy,P_AND);
                              }
                              oldx=newx;oldy=newy;break;
         default:             break;

        }

   }

return 3; /* return the 4th position if ESCAPE is pressed */
}
