/* DEMOCLR.c by bill buckels 2007         */
/* a graphics demo for the apple //e      */
/* written in Manx Aztec C65 Version 3.2b */
/* runs under PRODOS 8                    */
/* this was based on an old  dos 3.3 demo.*/
/* I modified it to suit the G2 library   */
/* I didn't bother to center the demo...  */
/* The original is left-justified for     */
/* some reason, and I just left it as-is  */
/* for this version...                    */


#define TEXTMODE  0
#define GRAFMODE  2  /* graphics only           */

#define clearscreen() fbox(0,0,39,191,0)
int getch();

/* base addresses for last 4 text lines */
/* of secondary text page               */

int textbase[4]={
    0x0A50,
    0x0AD0,
    0x0B50,
    0x0BD0};

main()
{
	int c,i,z,a,b,m,n,o;

	setcrtmode(GRAFMODE);
	plots("Press",32,100,4);
	plots("Any",32,108,4);
	plots("Key...",32,116,4);

	c=getch();
	clearscreen();
	clear_bottom();

    plots("G2 ProDOS GRAPHICS LIBRARY",7,80,1);

	bdrw(0,87,260,87);
	bdrw(0,78,260,78);

	mscreen();
	print_bottom("This shows how plots(s,x,y,c) works.",1,0);
	print_bottom("Also, it shows how mscreen() can create",2,0);
	print_bottom("a mixed screen. Hit any key to go on.",3,0);
	c=getch();
	clear_bottom();

	fscreen();
	vdrw(0,5,260,5);
	vlineto(260,186);
	vlineto(0,186);
	vlineto(0,5);
	gdrw(10,100,250,100);
	rdrw(10,140,250,140);
	a=1; b=-1; z=139; n=99;
	for(i=10;i<=250;++i){
		if(z<=100 || z>=140)
			a=-a;
		if(n<100 || n>=140)
			b=-b;
		z+=a;
		n+=b;
		plot(i,z);
		plot(i,n);
	}

	mscreen();
	print_bottom("Hi, we are back to mixed screen again!",0,0);
	print_bottom("This shows how lines and points can be",1,0);
	print_bottom("drawn by vdrw, gdrw, rdrw, and plot.",2,0);
	print_bottom("Hit any key to continue.",3,0);
	c=getch();
	clear_bottom();

	fscreen();
	for(o=5;o<=15;o+=5){
		circle(30,163,o);
		circle(230,163,o);
	}
	for(m=29;m<=229;m+=50)
		circle(m,40,20);
	plotchar('H',4,37);
	plotchar('E',11,37);
	plotchar('L',18,37);
	plotchar('L',25,37);
	plotchar('O',32,37);

	mscreen();
	print_bottom("These circles are drawn by the circle",0,0);
	print_bottom("function with center & radius specified.",1,0);
	print_bottom("Now, let's see how set_asp(x,y) works.",2,0);
	print_bottom("Press any key to continue.",3,0);
	c=getch();
	clear_bottom();

	fscreen();
	plots("set_asp(3,1)",14,160);
	set_asp(3,1);
	circle(130,163,20);

	mscreen();
	print_bottom("That's all, folks!  See you later.",1,0);
	print_bottom("Press any key to take the farewell look.",3,0);
	c=getch();
	clear_bottom();

	fscreen();
	c=getch();

	setcrtmode(TEXTMODE);
    _exit();

}

/* the functions below should probably be in the G2 library */
/* in the interests of leaving well enough alone, I have */
/* just knocked-them in as local functions... */

clear_bottom()
{
	char *crt;
	int row, col;
	char c = 32 + 128;

	for (row = 0; row < 4; row++) {
	  crt = (char *)(textbase[row]);
      for (col = 0; col < 40; col++) {
	     *crt++ = c;
	  }
    }
}


/* row = 0,0 to 3,39 in split screen mode */
/* printf was used in the original demo that I based this demo on */
/* and was not giving me the results I wanted so I am just going directly */
/* to the text screen address and outputting a raw ascii value */
print_bottom(str,row,col)
char *str;
int row, col;
{
     char *crt  = (char *)(textbase[row]+col);
     char c;

      while((c=*str++)!=0)*crt++=(c+128);
}


