/* Pic2Put (C) Copyright 2008 Bill Buckels */


#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <dos.h>
#include <bios.h>
#include <malloc.h>
#include <string.h>
#include <graph.h>


unsigned char header[5]={
    '\xfd','\x00','\xb8','\x00','\x00'};

int pic2put(char *pic, char *put)
{

    FILE *fp, *fp2;
    unsigned int picsize;
    int c;

    fp=fopen(pic,"rb");

    if (NULL == fp)return -1;

    picsize=filelength(fileno(fp));

    fp2 = fopen(put, "wb");

    fwrite(header,1,5,fp2);
    fwrite(&picsize,1,2,fp2);

    for (;;) {

		c = fgetc(fp);
		if (c==EOF) break;
		fputc(c,fp2);
	}


    fclose(fp);
    fclose(fp2);
}


main(int argc, char *argv[])
{

	int idx, jdx;
	char buffer[66];

	if (argc < 2) {
		puts("usage is \"pic2put my.pic\"");
		exit(0);
	}

	jdx = 999;

	strcpy(buffer, argv[1]);

	for (idx = 0; buffer[idx] !=0; idx++) {
		if (buffer[idx] == '.')jdx = idx;
	}

	if (jdx != 999)buffer[jdx] = 0;
	strcat(buffer,".put");

	pic2put(argv[1], buffer);

	exit(0);


}