/* Nessus
 * Copyright (C) 1999 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */        
 
 
#include <includes.h>

#ifndef BE_BUGGY
#include <peks.h>
#undef recv
#undef send
#undef shutdown
/* Remove the libpeks redefinitions of send() and recv() */



/*----------------------------------------------------------------------------
				
  				Forwarder
  	
    
	When nessusd forks, each child needs to send data to the
	client. 

	libpeks handles this situation, however it chokes when too
	many hosts have been tested.

	So, when forking, nessusd will create a forwarder : all the
	children send their data to it, and it just has to forward
	it to the client. 


	This file may be removed once the libpeks bug has been identified.

				
 ----------------------------------------------------------------------------*/

static void forwarder(int in, int out);


int * forwarder_setup()
{
 int *s = emalloc(2*sizeof(int));
 if(socketpair(AF_UNIX, SOCK_STREAM, 0, s)<0)
 {
  perror("socketpair ");
  EXIT(1);
 }
 printf("forwarder_setup : %d,%d\n", s[0], s[1]);
 return s;
}


int forwarder_get_in(int * s)
{
 return s? s[1]:-1;
}


void forwarder_insert_out(int * s, int out)
{
 if(!s)
  return;
 
 s[1] = out;
}


void forwarder_thread(int * in_and_out)
{
 forwarder(in_and_out[0], in_and_out[1]);
}


void forwarder_close(int * in_and_out)
{
 shutdown(in_and_out[0], 2);
 close(in_and_out[0]);
 
 io_shutdown(in_and_out[1], 2);
 close(in_and_out[1]);
}


/*
 * in  : local input
 * out : socket connected to the client
 */ 
static void forwarder(int in, int out)
{
 struct timeval tv = {0,100};
 fd_set rd;
 int max = in;
 
 if(out>in)max = out;

 while(1)
 {
   tv.tv_sec = 0;
   tv.tv_usec = 0;
  /* Is the client connected ? */

  if(io_send(out, NULL, 0, 0)<0)
  {
   printf("Communication closed\n");
   shutdown(in, 2);
   close(in);
   EXIT(0);
 }
 FD_ZERO(&rd);
 
 FD_SET(in, &rd);
 FD_SET(out, &rd);
 if(select(max+1, &rd, NULL, NULL, &tv)>0)
 {
   char * buffer = emalloc(4096);
   if(FD_ISSET(out, &rd))
   {
    /*
     * client -> server 
     */
    int n;
    n = io_recv(out, buffer, 4095,0);
    if(n>0)send(in, buffer, n, 0);
    printf("recu : %s\n", buffer);
    }
   
   if(FD_ISSET(in, &rd))
   {
    int n;
    /*
     * server -> client
     */
    bzero(buffer, 4095);
    n = recv(in, buffer, 4095,0);
    printf("On envoie : %s\n", buffer);
    if(n>0)io_send(out, buffer, n, 0);
    }
   efree(&buffer);
  }
 }
}
#endif /* BE_BUGGY */

