# Note that this is NOT a relocatable package
# DON'T FORGET TO UPDATE THE MOZILLA DEPENDENCY
%define ver      1.2.0
%define rel      1
%define prefix   /usr
%define sysconfdir	/etc

Summary:   Galeon
Name:      galeon
Version:   %ver
Release:   %rel
Copyright: GPL
Group:     Applications/Internet
Source:    galeon-%{PACKAGE_VERSION}.tar.gz
URL:       http://galeon.sourceforge.net
BuildRoot: /tmp/galeon-%{PACKAGE_VERSION}-root
Packager:  Marco Pesenti Gritti <mpeseng@tin.it>
Autoreq: 0
BuildRequires: 	gettext >= 0.10.38
BuildRequires:	mozilla-devel = 0.9.9
BuildRequires:	glib-devel
BuildRequires:	gtk+-devel >= 1.2.9
BuildRequires:	libxml-devel >= 1.8.14
BuildRequires:	gnome-libs-devel >= 1.2.11
BuildRequires:	GConf-devel >= 1.0.4
BuildRequires:	ORBit-devel >= 0.5.7
BuildRequires:	oaf-devel >= 0.6.5
BuildRequires:	gnome-vfs-devel >= 1.0.1
BuildRequires:	gdk-pixbuf-devel >= 0.11.0
BuildRequires:	libglade-devel >= 0.13
Requires:	glib
Requires:       gtk+ >= 1.2.9
Requires:       libxml >= 1.8.14
Requires:       gnome-libs >= 1.2.11
Requires:       GConf >= 1.0.4
Requires:       ORBit >= 0.5.7
Requires:       oaf >= 0.6.5
Requires:       gnome-vfs >= 1.0.1
Requires:       gdk-pixbuf >= 0.11.0
Requires: 	libglade >= 0.13
Requires: 	mozilla = 0.9.9

%description
Galeon is a web browser built around Gecko (Mozilla 's rendering engine) 
and Necko (Mozilla's networking engine). It's a GNOME web browser, 
designed to take advantage of as many GNOME technologies as makes sense. 
Galeon was written to do just one thing - browse the web.
%prep
%setup

%build

# if you set the DONT_BUILD_NAUTILUS_VIEW environment variable to something 
# else than "" the view won't be built. Otherwise, it will e built if 
# libnautilus is detected by configure.
if [ "$DONT_BUILD_NAUTILUS_VIEW" != "" ] ; then
	NAUTILUS_VIEW_OPTION="--enable-nautilus-view=no"
	echo Warning: The nautilius view will not be built.
else
	NAUTILUS_VIEW_OPTION=""
fi

if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%{prefix} \
		--with-gnome --without-debug --sysconfdir=%{sysconfdir} \
		--disable-install-schemas $NAUTILUS_VIEW_OPTION \
		--mandir=$RPM_BUILD_ROOT%{_mandir}
else
	CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%{prefix} \
		--with-gnome --without-debug --sysconfdir=%{sysconfdir} \
		--disable-install-schemas $NAUTILUS_VIEW_OPTION \
		--mandir=$RPM_BUILD_ROOT%{_mandir}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{sysconfdir} install

%clean
rm -rf $RPM_BUILD_ROOT

%files

%defattr(0555, bin, bin, 755)

%doc AUTHORS COPYING COPYING.README ChangeLog NEWS README INSTALL THANKS TODO FAQ FAQ.html README.ExtraPrefs

%{_bindir}/galeon
%{_bindir}/galeon-bin
%{_bindir}/galeon-config-tool

%{_libdir}/galeon/components

%defattr (0444, bin, bin,755)
%config %{_sysconfdir}/gconf/schemas/galeon.schemas
%config %{_sysconfdir}/sound/events/galeon.soundlist 
%{_datadir}/gnome/apps/Internet/*.desktop
%{_datadir}/galeon
%{_datadir}/locale/*/LC_MESSAGES/*.mo
%{_datadir}/oaf/GNOME_Galeon_Automation.oaf
%{_datadir}/oaf/GNOME_Galeon_NautilusView.oaf
%{_datadir}/pixmaps/*
%{_datadir}/sounds/galeon
%{_datadir}/gnome/ui/nautilus-galeon-view-ui.xml

%{_mandir}/man1/galeon.1*

%defattr (-, root, root)
%{_datadir}/gnome/help/*
%{_datadir}/omf/galeon/*

%post
%{_bindir}/galeon-config-tool --fix-gconf-permissions
%{_bindir}/galeon-config-tool --pkg-install-schemas
if which scrollkeeper-update>/dev/null 2>&1; then scrollkeeper-update; fi

%postun
if which scrollkeeper-update>/dev/null 2>&1; then scrollkeeper-update; fi

