/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_h
#define __galeon_h

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Configuration includes
 */	
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/**
 * Macros for checking mozilla version
 */
#include "mozilla_version.h"

/**
 * Runtime detected mozilla version
 */
extern int mozilla_version; 

/**
 * Galeon global includes 
 */
#include "galeon_types.h"

/**
 * Preferences strings
 */
#include "prefs_strings.h"

/**
 * OAF IIDs and objects
 */
#define GALEON_AUTOMATION_IID     "OAFIID:GNOME_Galeon_Automation"
#ifdef ENABLE_NAUTILUS_VIEW
#define GALEON_NAUTILUS_VIEW_IID  "OAFIID:GNOME_Galeon_NautilusViewFactory"
#endif

/* the virtual URL of "My Portal" feature */
#define MYPORTAL_URL          "myportal:"

/* the Galeon homepage */
#define GALEON_HOMEPAGE_URL   "http://galeon.sourceforge.net"

/* the Galeon bug report homepage */
#define GALEON_BUGREPORT_URL  ("http://bugzilla.gnome.org/enter_bug.cgi" \
                               "?product=galeon&version=" VERSION)

/* the Galeon FAQ page */
#define GALEON_FAQ_URL (SHARE_DIR "/FAQ.html")

/* bookmark file locations - relative to home dir */
#define NETSCAPE_BOOKMARKS    "/.netscape/bookmarks.html"
#define MOZILLA_PREFS_DIR     "/.mozilla/"

/**
 * Globals: FIXME!
 */

/* Has xpcom been initialised? */
extern gboolean pushed_startup;

/* Are we exiting? We use this to reject CORBA requests that otherwise
   would crash galeon. It's not enough to unregister from OAF because
   we may have received already some requests that have not been yet 
   processed */
extern gboolean galeon_exiting;

/* types of drag and drop for links */
extern const GtkTargetEntry url_drag_types[];
extern const GtkTargetEntry drop_types[];
extern const GtkTargetEntry embed_drop_types[];
extern const gint url_drag_types_num_items;
extern const gint drop_types_num_items;
extern const gint embed_drop_types_num_items;

/** the global list of MimeItems */
extern GList *mime_types;

/** Global windows count, includes download progress dialogs **/
extern gint window_count;

/** The global list of all GaleonWindow structures */
extern GList *all_windows;

/** The global list of all GaleonEmbed structures */
extern GList *all_embeds;

/** Styles for tab labels */
extern GtkStyle *loading_text_style;
extern GtkStyle *new_text_style;

/* global character set hash and sorted title list*/
extern GHashTable *charsets;
extern GList *sorted_charset_titles;

/* are we in server mode? */
extern gboolean galeon_server_mode;

/* server mode timeout */
extern gint galeon_server_timeout;

/* are we in panel mode? */
extern gboolean galeon_panel_mode;

/* last save image directory */
extern gchar *save_dir;

/* when true, the session won't be automatically saved when locations
 * change or embeds are closed.  useful for functions that close a lot of
 * embeds at once. */
extern gboolean dont_autosave_session;

/**
 * The standard pixmaps for bookmarks / sites
 */
extern PixmapData *folder_pixmap_data;
extern PixmapData *folder_open_pixmap_data;
extern PixmapData *default_folder_pixmap_data;
extern PixmapData *default_folder_open_pixmap_data;
extern PixmapData *site_pixmap_data;
extern PixmapData *smart_bm_fold_pixmap_data;
extern PixmapData *smart_bm_unfold_pixmap_data;

#define DEFAULT_CHROME GTK_MOZ_EMBED_FLAG_ALLCHROME

extern const gint bookmarks_dnd_targets_num_items;

/*
 * Miscellaneous function prototypes. Most large modules have a header
 * of their own.
 */

/* main.c */
void galeon_exit (gboolean return_from_main_loop,
		  gboolean unset_crashed_flag);

/* netscape.c */
gboolean netscape_import_prefs (void);

/* mozilla_prefs.c */
void mozilla_prefs_import_language (void);

/* autobookmarks.c */
void autobookmarks_generate (void);

/* newuser.c */
gboolean newuser_check (void);
void newuser_show_druid (void); 

/* panel.c */
void panel_main (void);

/* ProgressListener2.cpp */
void downloader_dialog_init (void);

#ifdef __cplusplus
}
#endif

#endif /* __galeon_h */
