
/* The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express oqr
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is Galeon web browser code, released Sept 2001
 *
 * The Initial Developer of the Original Code is Marco Pesenti Gritti
 * and is Copyright (C) 2001. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU Public License (the "GPL"), in which case the
 * provisions of the GPL are applicable instead of those above.
 * If you wish to allow use of your version of this file only
 * under the terms of the GPL and not to allow others to use your
 * version of this file under the MPL, indicate your decision by
 * deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL.  If you do not delete
 * the provisions above, a recipient may use your version of this
 * file under either the MPL or the GPL.
 */


/**
 * Configuration includes
 */     
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/**
 * Create a version int from components
 */
#define VERSION4(a,b,c,d) ((a << 24) + (b << 16) + (c << 8) + d)
#define VERSION3(a,b,c) VERSION4(a,b,c,0)
#define VERSION2(a,b) VERSION3(a,b,0)

/**
 * Split version int into components
 */
#define VERSIONA(v) (v >> 24)
#define VERSIONB(v) ((v >> 16) & 0xFF)
#define VERSIONC(v) ((v >> 8) & 0xFF)
#define VERSIOND(v) (v  & 0xFF)
#define VERSIONPLUS(v) (VERSIOND(v) ? "+" : "")

/**
 * Convenience macros for printing versions
 */
#define VERSIONFMT "%i.%i.%i%s"
#define VERSIONFMTARGS(ver) VERSIONA(ver), VERSIONB(ver), VERSIONC(ver), VERSIONPLUS(ver)
