# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementSnapshotsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_snapshots_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.snapshots.begin_create_or_update(
                resource_group_name=resource_group.name,
                snapshot_name="str",
                snapshot={
                    "location": "str",
                    "completionPercent": 0.0,
                    "copyCompletionError": {"errorCode": "str", "errorMessage": "str"},
                    "creationData": {
                        "createOption": "str",
                        "elasticSanResourceId": "str",
                        "galleryImageReference": {
                            "communityGalleryImageId": "str",
                            "id": "str",
                            "lun": 0,
                            "sharedGalleryImageId": "str",
                        },
                        "imageReference": {
                            "communityGalleryImageId": "str",
                            "id": "str",
                            "lun": 0,
                            "sharedGalleryImageId": "str",
                        },
                        "logicalSectorSize": 0,
                        "performancePlus": bool,
                        "provisionedBandwidthCopySpeed": "str",
                        "securityDataUri": "str",
                        "sourceResourceId": "str",
                        "sourceUniqueId": "str",
                        "sourceUri": "str",
                        "storageAccountId": "str",
                        "uploadSizeBytes": 0,
                    },
                    "dataAccessAuthMode": "str",
                    "diskAccessId": "str",
                    "diskSizeBytes": 0,
                    "diskSizeGB": 0,
                    "diskState": "str",
                    "encryption": {"diskEncryptionSetId": "str", "type": "str"},
                    "encryptionSettingsCollection": {
                        "enabled": bool,
                        "encryptionSettings": [
                            {
                                "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                            }
                        ],
                        "encryptionSettingsVersion": "str",
                    },
                    "extendedLocation": {"name": "str", "type": "str"},
                    "hyperVGeneration": "str",
                    "id": "str",
                    "incremental": bool,
                    "incrementalSnapshotFamilyId": "str",
                    "managedBy": "str",
                    "name": "str",
                    "networkAccessPolicy": "str",
                    "osType": "str",
                    "provisioningState": "str",
                    "publicNetworkAccess": "str",
                    "purchasePlan": {"name": "str", "product": "str", "publisher": "str", "promotionCode": "str"},
                    "securityProfile": {"secureVMDiskEncryptionSetId": "str", "securityType": "str"},
                    "sku": {"name": "str", "tier": "str"},
                    "supportedCapabilities": {
                        "acceleratedNetwork": bool,
                        "architecture": "str",
                        "diskControllerTypes": "str",
                    },
                    "supportsHibernation": bool,
                    "tags": {"str": "str"},
                    "timeCreated": "2020-02-20 00:00:00",
                    "type": "str",
                    "uniqueId": "str",
                },
                api_version="2023-10-02",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_snapshots_begin_update(self, resource_group):
        response = await (
            await self.client.snapshots.begin_update(
                resource_group_name=resource_group.name,
                snapshot_name="str",
                snapshot={
                    "dataAccessAuthMode": "str",
                    "diskAccessId": "str",
                    "diskSizeGB": 0,
                    "encryption": {"diskEncryptionSetId": "str", "type": "str"},
                    "encryptionSettingsCollection": {
                        "enabled": bool,
                        "encryptionSettings": [
                            {
                                "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                                "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                            }
                        ],
                        "encryptionSettingsVersion": "str",
                    },
                    "networkAccessPolicy": "str",
                    "osType": "str",
                    "publicNetworkAccess": "str",
                    "sku": {"name": "str", "tier": "str"},
                    "supportedCapabilities": {
                        "acceleratedNetwork": bool,
                        "architecture": "str",
                        "diskControllerTypes": "str",
                    },
                    "supportsHibernation": bool,
                    "tags": {"str": "str"},
                },
                api_version="2023-10-02",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_snapshots_get(self, resource_group):
        response = await self.client.snapshots.get(
            resource_group_name=resource_group.name,
            snapshot_name="str",
            api_version="2023-10-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_snapshots_begin_delete(self, resource_group):
        response = await (
            await self.client.snapshots.begin_delete(
                resource_group_name=resource_group.name,
                snapshot_name="str",
                api_version="2023-10-02",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_snapshots_list_by_resource_group(self, resource_group):
        response = self.client.snapshots.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-10-02",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_snapshots_list(self, resource_group):
        response = self.client.snapshots.list(
            api_version="2023-10-02",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_snapshots_begin_grant_access(self, resource_group):
        response = await (
            await self.client.snapshots.begin_grant_access(
                resource_group_name=resource_group.name,
                snapshot_name="str",
                grant_access_data={
                    "access": "str",
                    "durationInSeconds": 0,
                    "fileFormat": "str",
                    "getSecureVMGuestStateSAS": bool,
                },
                api_version="2023-10-02",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_snapshots_begin_revoke_access(self, resource_group):
        response = await (
            await self.client.snapshots.begin_revoke_access(
                resource_group_name=resource_group.name,
                snapshot_name="str",
                api_version="2023-10-02",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
