# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datamigration.aio import DataMigrationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataMigrationManagementServiceTasksOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataMigrationManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_service_tasks_list(self, resource_group):
        response = self.client.service_tasks.list(
            group_name="str",
            service_name="str",
            api_version="2025-03-15-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_service_tasks_create_or_update(self, resource_group):
        response = await self.client.service_tasks.create_or_update(
            group_name="str",
            service_name="str",
            task_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": "project_task_properties",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_service_tasks_get(self, resource_group):
        response = await self.client.service_tasks.get(
            group_name="str",
            service_name="str",
            task_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_service_tasks_delete(self, resource_group):
        response = await self.client.service_tasks.delete(
            group_name="str",
            service_name="str",
            task_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_service_tasks_update(self, resource_group):
        response = await self.client.service_tasks.update(
            group_name="str",
            service_name="str",
            task_name="str",
            parameters={
                "etag": "str",
                "id": "str",
                "name": "str",
                "properties": "project_task_properties",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_service_tasks_cancel(self, resource_group):
        response = await self.client.service_tasks.cancel(
            group_name="str",
            service_name="str",
            task_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...
