# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.oracledatabase import OracleDatabaseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestOracleDatabaseMgmtCloudVmClustersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(OracleDatabaseMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_list_by_subscription(self, resource_group):
        response = self.client.cloud_vm_clusters.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_begin_create_or_update(self, resource_group):
        response = self.client.cloud_vm_clusters.begin_create_or_update(
            resource_group_name=resource_group.name,
            cloudvmclustername="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": {
                    "cloudExadataInfrastructureId": "str",
                    "cpuCoreCount": 0,
                    "displayName": "str",
                    "giVersion": "str",
                    "hostname": "str",
                    "sshPublicKeys": ["str"],
                    "subnetId": "str",
                    "vnetId": "str",
                    "backupSubnetCidr": "str",
                    "clusterName": "str",
                    "compartmentId": "str",
                    "computeModel": "str",
                    "computeNodes": ["str"],
                    "dataCollectionOptions": {
                        "isDiagnosticsEventsEnabled": bool,
                        "isHealthMonitoringEnabled": bool,
                        "isIncidentLogsEnabled": bool,
                    },
                    "dataStoragePercentage": 0,
                    "dataStorageSizeInTbs": 0.0,
                    "dbNodeStorageSizeInGbs": 0,
                    "dbServers": ["str"],
                    "diskRedundancy": "str",
                    "domain": "str",
                    "fileSystemConfigurationDetails": [{"fileSystemSizeGb": 0, "mountPoint": "str"}],
                    "iormConfigCache": {
                        "dbPlans": [{"dbName": "str", "flashCacheLimit": "str", "share": 0}],
                        "lifecycleDetails": "str",
                        "lifecycleState": "str",
                        "objective": "str",
                    },
                    "isLocalBackupEnabled": bool,
                    "isSparseDiskgroupEnabled": bool,
                    "lastUpdateHistoryEntryId": "str",
                    "licenseModel": "str",
                    "lifecycleDetails": "str",
                    "lifecycleState": "str",
                    "listenerPort": 0,
                    "memorySizeInGbs": 0,
                    "nodeCount": 0,
                    "nsgCidrs": [{"source": "str", "destinationPortRange": {"max": 0, "min": 0}}],
                    "nsgUrl": "str",
                    "ociUrl": "str",
                    "ocid": "str",
                    "ocpuCount": 0.0,
                    "provisioningState": "str",
                    "scanDnsName": "str",
                    "scanDnsRecordId": "str",
                    "scanIpIds": ["str"],
                    "scanListenerPortTcp": 0,
                    "scanListenerPortTcpSsl": 0,
                    "shape": "str",
                    "storageSizeInGbs": 0,
                    "subnetOcid": "str",
                    "systemVersion": "str",
                    "timeCreated": "2020-02-20 00:00:00",
                    "timeZone": "str",
                    "vipIds": ["str"],
                    "zoneId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_get(self, resource_group):
        response = self.client.cloud_vm_clusters.get(
            resource_group_name=resource_group.name,
            cloudvmclustername="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_begin_update(self, resource_group):
        response = self.client.cloud_vm_clusters.begin_update(
            resource_group_name=resource_group.name,
            cloudvmclustername="str",
            properties={
                "properties": {
                    "computeNodes": ["str"],
                    "cpuCoreCount": 0,
                    "dataCollectionOptions": {
                        "isDiagnosticsEventsEnabled": bool,
                        "isHealthMonitoringEnabled": bool,
                        "isIncidentLogsEnabled": bool,
                    },
                    "dataStorageSizeInTbs": 0.0,
                    "dbNodeStorageSizeInGbs": 0,
                    "displayName": "str",
                    "fileSystemConfigurationDetails": [{"fileSystemSizeGb": 0, "mountPoint": "str"}],
                    "licenseModel": "str",
                    "memorySizeInGbs": 0,
                    "ocpuCount": 0.0,
                    "sshPublicKeys": ["str"],
                    "storageSizeInGbs": 0,
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_begin_delete(self, resource_group):
        response = self.client.cloud_vm_clusters.begin_delete(
            resource_group_name=resource_group.name,
            cloudvmclustername="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_list_by_resource_group(self, resource_group):
        response = self.client.cloud_vm_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_begin_add_vms(self, resource_group):
        response = self.client.cloud_vm_clusters.begin_add_vms(
            resource_group_name=resource_group.name,
            cloudvmclustername="str",
            body={"dbServers": ["str"]},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_begin_remove_vms(self, resource_group):
        response = self.client.cloud_vm_clusters.begin_remove_vms(
            resource_group_name=resource_group.name,
            cloudvmclustername="str",
            body={"dbServers": ["str"]},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_cloud_vm_clusters_list_private_ip_addresses(self, resource_group):
        response = self.client.cloud_vm_clusters.list_private_ip_addresses(
            resource_group_name=resource_group.name,
            cloudvmclustername="str",
            body={"subnetId": "str", "vnicId": "str"},
        )

        # please add some check logic here by yourself
        # ...
