# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementLongTermRetentionManagedInstanceBackupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_list_by_location(self, resource_group):
        response = self.client.long_term_retention_managed_instance_backups.list_by_location(
            location_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_list_by_database(self, resource_group):
        response = self.client.long_term_retention_managed_instance_backups.list_by_database(
            location_name="str",
            managed_instance_name="str",
            database_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_get(self, resource_group):
        response = await self.client.long_term_retention_managed_instance_backups.get(
            location_name="str",
            managed_instance_name="str",
            database_name="str",
            backup_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_begin_delete(self, resource_group):
        response = await (
            await self.client.long_term_retention_managed_instance_backups.begin_delete(
                location_name="str",
                managed_instance_name="str",
                database_name="str",
                backup_name="str",
                api_version="2024-11-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_list_by_instance(self, resource_group):
        response = self.client.long_term_retention_managed_instance_backups.list_by_instance(
            location_name="str",
            managed_instance_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_list_by_resource_group_location(self, resource_group):
        response = self.client.long_term_retention_managed_instance_backups.list_by_resource_group_location(
            resource_group_name=resource_group.name,
            location_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_list_by_resource_group_database(self, resource_group):
        response = self.client.long_term_retention_managed_instance_backups.list_by_resource_group_database(
            resource_group_name=resource_group.name,
            location_name="str",
            managed_instance_name="str",
            database_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_get_by_resource_group(self, resource_group):
        response = await self.client.long_term_retention_managed_instance_backups.get_by_resource_group(
            resource_group_name=resource_group.name,
            location_name="str",
            managed_instance_name="str",
            database_name="str",
            backup_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_begin_delete_by_resource_group(self, resource_group):
        response = await (
            await self.client.long_term_retention_managed_instance_backups.begin_delete_by_resource_group(
                resource_group_name=resource_group.name,
                location_name="str",
                managed_instance_name="str",
                database_name="str",
                backup_name="str",
                api_version="2024-11-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_long_term_retention_managed_instance_backups_list_by_resource_group_instance(self, resource_group):
        response = self.client.long_term_retention_managed_instance_backups.list_by_resource_group_instance(
            resource_group_name=resource_group.name,
            location_name="str",
            managed_instance_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
