(function() {
  var coffee, compileObject, fs, getDefaultMixins, util, vm, _;
  coffee = require('coffee-script');
  fs = require('fs');
  _ = require('underscore');
  util = require('util');
  vm = require('vm');
  exports.compile = function(fileName, newFileName, callback) {
    if (callback == null) {
      callback = function(err, fileName, newFileName) {};
    }
    if (typeof fileName === 'object') {
      return compileObject(fileName, newFileName);
    }
    if (typeof newFileName === 'function') {
      callback = newFileName;
      newFileName = void 0;
    }
    if (newFileName === void 0) {
      newFileName = fileName.replace(/\.css\.coffee$/i, '.css');
    }
    return fs.readFile(fileName, function(err, data) {
      var css, js, sandbox;
      if (err) {
        return callback(err, fileName, newFileName);
      } else {
        try {
          js = coffee.compile(data.toString().trim());
          sandbox = {
            exports: {
              css: {},
              mixins: getDefaultMixins()
            },
            require: require
          };
          vm.runInNewContext(js, sandbox);
          css = compileObject(sandbox.exports.css, sandbox.exports.mixins);
          return fs.writeFile(newFileName, css, function(err) {
            return callback(err, fileName, newFileName);
          });
        } catch (err) {
          return callback(err, fileName, newFileName);
        }
      }
    });
  };
  exports.getDefaultMixins = getDefaultMixins;
  compileObject = function(cssObject, mixins) {
    var compileCssList, outputList;
    mixins || (mixins = getDefaultMixins());
    outputList = [];
    compileCssList = function(cssObject) {
      var declarationText, declarations, isNested, iterateDeclarations, nestedSelectors, selector, _results;
      _results = [];
      for (selector in cssObject) {
        declarations = cssObject[selector];
        declarationText = [];
        nestedSelectors = {};
        isNested = false;
        iterateDeclarations = function(d) {
          var cssProperty, key, value, _results2;
          _results2 = [];
          for (key in d) {
            value = d[key];
            _results2.push(typeof value === 'object' ? (nestedSelectors["" + selector + " " + key] = value, isNested = true) : mixins[key] ? iterateDeclarations(mixins[key](value)) : (cssProperty = key.replace(/[A-Z]/g, function(s) {
              return '-' + s.toLowerCase();
            }), declarationText.push("    " + cssProperty + ": " + value + ";")));
          }
          return _results2;
        };
        iterateDeclarations(declarations);
        outputList.push("" + selector + " {\n" + (declarationText.join('\n')) + "\n}");
        _results.push(isNested ? compileCssList(nestedSelectors) : void 0);
      }
      return _results;
    };
    compileCssList(cssObject);
    return outputList.join('\n');
  };
  getDefaultMixins = function() {
    return {
      boxShadowAll: function(value) {
        return {
          WebkitBoxShadow: value,
          MozBoxShadow: value,
          boxShadow: value
        };
      },
      opacityAll: function(value) {
        return {
          filter: 'alpha(opacity=' + (value * 100) + ')',
          opacity: value
        };
      }
    };
  };
}).call(this);
