<?php

namespace Kanboard\Plugin\PhpcasAuth\Controller;

use Kanboard\Controller\BaseController as BaseController;
use Kanboard\Plugin\PhpcasAuth\Auth\PhpcasAuthProvider;

/**
 * Phpcas Controller
 *
 * @package  controller
 * @author   Envoles
 */
class PhpcasController extends BaseController
{
    /**
     * Handle authentication
     *
     * @access public
     */
    public function login()
    {

        require_once 'CAS-1.3.1/eoleCAS.php';
        require_once 'configCAS/cas.inc.php';
        
        $myphpCAS = new \eolephpCAS();

        if (__CAS_DEBUG) {
            $myphpCAS->setDebug('/var/log/phpcas/phpcas-eportail.log');
        }
        
        $myphpCAS->client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, true);
              
        if (__CAS_LOGOUT){
            if (method_exists("eolephpCAS", 'eolelogoutRequests')){
                $myphpCAS->eolelogoutRequests(false);
            }
        }
    
        if (__CAS_VALIDER_CA) {
            $myphpCAS->setCasServerCACert(__CAS_CA_LOCATION); // verification par rapport a la CA
        } else {
            if (method_exists("EolephpCAS", "setNoCasServerValidation")){
                $myphpCAS->setNoCasServerValidation();
            }
        }
    
        $myphpCAS->forceAuthentication();
    
        $user = $myphpCAS->getUser();
        $details = $myphpCAS->getDetails();
        if(!isset($details["utilisateur"])&&isset($details["attributes"])) {
            $details["utilisateur"]=$details["attributes"];
        }

        // Authentification Kanboard
        $provider = new PhpcasAuthProvider($this->container);
        $this->authenticationManager->passwordAuthentication($user, "PASSWORDCAS");
        $this->response->redirect($this->helper->url->to('DashboardController', 'show'));
    }

    public function logout()
    {
        require_once 'CAS-1.3.1/eoleCAS.php';
        require_once 'configCAS/cas.inc.php';
    
        $myphpCAS = new \eolephpCAS();

        $myphpCAS->client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);
    
        if (__CAS_VALIDER_CA) {
            $myphpCAS->setCasServerCACert(__CAS_CA_LOCATION);
        }
        else {
            if (method_exists("eolephpCAS", 'setNoCasServerValidation')){
                $myphpCAS->setNoCasServerValidation();
            }
        }
        
        $url=$this->helper->url->to('AuthController', 'login',array(),"",true);
        $myphpCAS->logout(array("service"=>$url));        
    }
}
