<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_clean', language 'fr', branch 'MOODLE_31_STABLE'
 *
 * @package   theme_clean
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Clean</h2>
<p><img class="img-polaroid" src="clean/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>À propos</h3>
<p>Clean est un thème Bootstrap modifié pour Moodle qui hérite des styles et procédures de rendu (<i>renderers</i>) de son thème parent.</p>
<h3>Parents</h3>
<p>Ce thème se fonde sur le thème Bootstrap, qui a été créé pour Moodle 2.5, avec l\'aide de<br />Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Crédits</h3>
<p>Auteurs : Bas Brands, David Scotson, Mary Evans<br />Contact : bas@sonsbeekmedia.nl<br />Site web : <a href="http://www.basbrands.nl">www.basbrands.nl</a></p>
<h3>Annoncer un bogue</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
<h3>Plus d\'information</h3>
<p><a href="clean/README.txt">Comment copier et personnaliser ce thème</a> (en anglais).</p>
</div>
</div>';
$string['configtitle'] = 'Clean';
$string['customcss'] = 'CSS personnalisée';
$string['customcssdesc'] = 'Les règles CSS que vous définissez ici seront ajoutées à chacune des pages, vous permettant ainsi de personnaliser facilement ce thème.';
$string['footnote'] = 'Pied de page';
$string['footnotedesc'] = 'Le contenu de ce champ sera affiché dans le pied-de-page de chaque page.';
$string['invert'] = 'Inverser la barre de navigation';
$string['invertdesc'] = 'Alterne le texte et le fond de la barre de navigation en haut de la page entre noir et blanc.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Le logo n\'est affiché que dans l\'entête de la page d\'accueil et de la page de connexion.<br />Si la hauteur de votre logo dépasse 75px, ajoutez la règle CSS div.logo {height: 100px;} dans la zone CSS personnalisée ci-dessous, en adaptant la hauteur en pixels à la taille de votre logo.';
$string['pluginname'] = 'Clean';
$string['region-side-post'] = 'Droite';
$string['region-side-pre'] = 'Gauche';
$string['sitelogo'] = 'Logo de la plateforme';
$string['sitename'] = 'Affiche le nom de la plateforme avec un petit logo';
$string['sitenamedesc'] = 'S\'il n\'y a pas de petit logo, le nom de la plateforme est toujours affiché dans la barre de navigation. Si un petit logo est défini, il peut être affiché avec ou sans le nom de la plateforme.';
$string['smalllogo'] = 'Petit logo';
$string['smalllogodesc'] = 'Le petit logo est affiché dans la barre de navigation. Si un logo d\'entête est défini pour la page d\'accueil et la page de connexion, le petit logo n\'est pas affiché sur ces pages.';
