<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'fr', branch 'MOODLE_26_STABLE'
 *
 * @package   local_moodleorg
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'Moodle peut être téléchargé gratuitement et son enregistrement est volontaire. C\'est pourquoi nous ne disposons pas de données complètes sur son utilisation. Cependant, nous produisons sur la page Statistiques des graphiques intéressants sur la base de données que nous possédons.';
$string['aboutstatisticsheading'] = 'Statistiques Moodle';
$string['aboutstatisticstitle'] = 'Moodle.org : statistiques Moodle';
$string['activeusers24hours'] = 'Utilisateurs enregistrés actifs durant les dernières 24 heures :';
$string['activeuserspastmonth'] = 'Utilisateurs enregistrés actifs durant le mois passé :';
$string['browsegittitle'] = 'Consultez le code source';
$string['cachedef_frontpagecolumn'] = 'Colonnes page d\'accueil';
$string['cachedef_usefulposts'] = 'Messages utiles';
$string['communities'] = 'Communautés';
$string['communitiesmy'] = 'Mes communautés';
$string['community'] = 'Communauté';
$string['communityadministration'] = 'Administration communauté';
$string['communitycurrent'] = 'Communauté actuelle';
$string['communityenrolme'] = 'Devenir membre de cette communauté';
$string['communityenrolmentoptions'] = 'Rejoindre une communauté';
$string['communityintro'] = 'Moodle a une vaste et très diverse communauté d\'utilisateurs, comprenant rien que sur ce site plus de <a href="http://moodle.org/userpics">{$a->usercount} utilisateurs enregistrés</a> parlant plus de <a href="http://download.moodle.org/langpack/">{$a->langcount} langues</a> dans <a href="http://moodle.org/sites">{$a->countrycount} pays</a> (nous avons <a href="http://moodle.org/stats">d\'autres statistiques</a>).';
$string['communityjoinbyyourself'] = 'Rejoindre par vous-même';
$string['communityjoinbyyourselfas'] = 'Rejoindre par vous-même comme {$a->rolename}';
$string['communitynoguestaccess'] = 'Les utilisateurs anonymes ne peuvent pas accéder à cet espace de la communauté. Veuillez vous connecter.';
$string['communitynotenrollable'] = 'Vous ne pouvez pas rejoindre cette communauté par vous-même. Veuillez contacter le facilitateur de la communauté.';
$string['communitysomeallowguest'] = 'Certaines communautés autorisent l\'accès anonyme';
$string['communityunenrolme'] = 'Quitter la communauté {$a}';
$string['conferencecenter'] = 'Centre de congrès Moodle';
$string['connectedsites'] = 'Certains sites Moodle sont connectés à moodle.org via le réseau Moodle. Vous pouvez ainsi vous connecter directement à ces sites si vous vous êtes authentifié ici.';
$string['donations'] = 'Moodle est offert sans aucune obligation financière. Nombreux sont cependant les membres de la communauté qui ont fait un don à notre projet afin de nous aider à payer les développeurs qui permettent à Moodle d\'exister.';
$string['donationsmoney'] = 'Vous pouvez aussi contribuer directement au moyen d\'un don. Ces montants sont utilisés pour réaliser les fonctionnalités désirées sur notre feuille de route. Pour faire un don par carte de crédit dans la plupart des principales devises, cliquez sur le bouton Paypal ci-dessous.<br /><br /> Les donateurs de plus de 10 $ peuvent ajouter leur nom à cette page pour une année. N\'oubliez pas de cliquer sur le bouton « continuer » après avoir payé, pour voir le formulaire où vous pouvez modifier la façon dont votre entrée apparaît.';
$string['donationsservices'] = 'Si vous avez un besoin de services Moodle comme de l\'hébergement, du soutien, une installation, une programmation personnalisée, l\'élaboration de cours ou du consulting, veuillez contacter un <a href="http://moodle.com/">Partenaire Moodle de moodle.com</a> autorisé (vous verrez leurs bandeaux publicitaires sur ce site). Les partenaires versent un pourcentage fixe de tous leurs revenus dans le fonds de développement du Moodle Trust, de sorte que tout le monde est gagnant.';
$string['donationstitle'] = 'Dons';
$string['donationstrust'] = 'Moodle a un fonds de développement géré par le Moodle Trust, qui mandate des programmeurs pour travailler sur Moodle, et prend également en charge des financements, comme celui de moodle.org.';
$string['downloadcore'] = 'Notre méthode de distribution principale a lieu au moyen de ces paquetages standards. Ils contiennent les modules et plugins maintenus par les développeurs centraux et conviennent à une installation sur pratiquement tous les environnements disposant de PHP et d\'un gestionnaire de base de données.';
$string['downloadcoretitle'] = 'Paquetages Moodle standards';
$string['downloadintro'] = 'Moodle est un logiciel libre sous <a href="http://docs.moodle.org/fr/Licence">Licence GPL</a>. Tout ce que nous produisons est disponible au téléchargement librement et gratuitement.';
$string['downloadlang'] = 'Dans les versions actuelles de Moodle, l\'installation de langues a été automatisé et est accessible dans le menu d\'administration de votre site. Toutefois, pour certaines versions plus anciennes de Moodle, les paquetages de langue doivent être téléchargés manuellement.';
$string['downloadlangtitle'] = 'Paquetages de langue';
$string['downloadmac'] = 'Si vous ne disposez pas d\'un serveur web déjà installé, ces paquetages tout-en-un vous permettront d\'installer très facilement Moodle sur tout ordinateur Apple avec Mac OS X.';
$string['downloadmactitle'] = 'Moodle pour Mac OS X';
$string['downloadmodules'] = 'Consultez notre base de données très fournie de plugins pouvant être ajoutés à votre site Moodle pour lui donner des fonctionnalités supplémentaires par rapport à la version standard.';
$string['downloadmodulestitle'] = 'Plugins';
$string['downloadthemes'] = 'L\'apparence d\'un site Moodle peut être modifiée complètement en utilisant un thème différent. Nous tenons à jour une base de données de thèmes que des utilisateurs de Moodle ont créés et partagés.';
$string['downloadthemestitle'] = 'Thèmes';
$string['downloadviagitcvs'] = 'Il est aussi possible d\'obtenir Moodle <a href="https://docs.moodle.org/fr/Git_pour_administrateurs">à l\'aide de Git</a> ou <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">de CVS</a>.';
$string['downloadwin'] = 'Si vous ne disposez pas d\'un serveur web déjà installé, ces paquetages tout-en-un vous permettront d\'installer très facilement Moodle sur tout ordinateur tournant sous Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle pour Windows';
$string['erroradminonly'] = 'Seuls les administrateurs peuvent accéder à cette interface.';
$string['erroralreadyvoted'] = 'Vous avez déjà voté pour {$a}';
$string['errormaxmessages'] = 'Vous ne pouvez pas envoyer plus de 3 messages.';
$string['errornomainnews'] = 'Impossible de trouver ou de créer un forum principal des nouvelles du site';
$string['errorsendingmail'] = 'Une erreur est survenue lors de l\'envoi du message. Veuillez essayer plus tard ou contacter l\'administrateur du site.';
$string['events'] = 'Nous sommes spécialisés dans l\'apprentissage en ligne. Cependant, c\'est aussi très sympathique de se rencontrer pour de vrai ! Ces liens vous proposent des informations sur nos congrès ou conférences (appelées « MoodleMoots ») et d\'autres événements.';
$string['eventstitle'] = 'Événements';
$string['feed_events'] = 'Événements';
$string['feed_events_more'] = 'Plus d\'événements';
$string['feed_news'] = 'Annonces';
$string['feed_news_more'] = 'Voir toutes les annonces';
$string['feed_resources'] = 'Ressources';
$string['feed_useful'] = 'Messages utiles';
$string['feed_useful_more'] = 'Plus de messages';
$string['focusbox_community'] = 'Assistance et forums de la communauté';
$string['focusbox_community_text'] = 'Obtenir de l\'assistance et partager des idées, dans votre langue.';
$string['focusbox_community_viewall'] = 'Toutes les communautés';
$string['focusbox_future'] = 'Aider à modeler le futur de Moodle';
$string['focusbox_future_crowdfund'] = 'Projets de financement participatif';
$string['focusbox_future_gdf'] = 'Discussions des développeurs';
$string['focusbox_future_research'] = 'Recherche Moodle';
$string['focusbox_future_roadmap'] = 'Planification';
$string['focusbox_future_text'] = 'Découvrir les actions à venir et aider à progresser.';
$string['focusbox_settingup'] = 'Configurer Moodle';
$string['focusbox_settingup_community'] = 'Assistance de la communauté';
$string['focusbox_settingup_download'] = 'Téléchargement gratuit';
$string['focusbox_settingup_hosting'] = 'Hébergement';
$string['focusbox_settingup_install'] = 'Installation';
$string['focusbox_settingup_own'] = 'Par vous-même';
$string['focusbox_settingup_partner'] = 'Via un partenaire Moodle';
$string['focusbox_settingup_plugins'] = 'Plugins';
$string['focusbox_settingup_support'] = 'Assistance commerciale';
$string['focusbox_teaching'] = 'Enseigner avec Moodle';
$string['focusbox_teaching_books'] = 'Livres';
$string['focusbox_teaching_courses'] = 'Cours et contenus';
$string['focusbox_teaching_docs'] = 'Documentation';
$string['focusbox_teaching_text'] = 'Explorer la diversité des fonctionnalités de Moodle et les ressources disponibles.';
$string['focusbox_theproject'] = 'Le projet Moodle';
$string['focusbox_theproject_about'] = 'À propos de Moodle';
$string['focusbox_theproject_devs'] = 'Développeurs';
$string['focusbox_theproject_hq'] = 'Moodle HQ';
$string['focusbox_theproject_partners'] = 'Partenaires Moodle';
$string['focusbox_theproject_stats'] = 'Statistiques';
$string['focusbox_theproject_text'] = 'En savoir plus sur le projet Moodle et nos partenariats ouverts et collaboratifs.';
$string['focusbox_uptodate'] = 'Rester à jour';
$string['focusbox_uptodate_buzz'] = 'Buzz Moodle';
$string['focusbox_uptodate_planet'] = 'Planète Moodle';
$string['focusbox_uptodate_security'] = 'Annonces de sécurité';
$string['focusbox_uptodate_social'] = 'Média sociaux';
$string['focusbox_uptodate_text'] = 'Les dernières nouvelles sur Moodle et ses mises à jour.';
$string['generaldeveloperforum'] = 'Forum général des développeurs';
$string['graphpopulation'] = 'Graphique population Moodle';
$string['graphregistrationmap'] = 'Carte enregistrements Moodle';
$string['graphregistrationmapdesc'] = 'Top 10 des sites inscrits dans {$a} pays';
$string['graphusersites'] = 'Comparaison utilisateurs Moodle et sites';
$string['heroslide_community_description'] = 'Bienvenue dans la communauté Moodle ! Découvrez la force d\'une collaboration ouverte dans l\'une des communautés du logiciel libre les plus vastes au monde.';
$string['heroslide_community_headline'] = 'Centré sur la communauté, soutenu à l\'échelle mondiale.';
$string['heroslide_community_slidecontrol'] = 'Bénéficie d\'une communauté à l\'échelle mondiale';
$string['heroslide_global_description'] = 'Disponible dans plus de 100 langues, Moodle a la confiance de grandes et petites institutions et organisations, avec des millions d\'utilisateurs du monde entier.';
$string['heroslide_global_headline'] = 'Le socle d\'environnements d\'apprentissage du monde entier';
$string['heroslide_global_slidecontrol'] = 'Le socle d\'environnements d\'apprentissage du monde entier';
$string['heroslide_link_demo'] = 'Démo';
$string['heroslide_link_features'] = 'Fonctionnalités';
$string['heroslide_link_forums'] = 'Forums de la communauté';
$string['heroslide_link_sites'] = 'Sites enregistrés';
$string['heroslide_link_stats'] = 'Statistiques';
$string['heroslide_link_stories'] = 'Autres témoignages';
$string['heroslide_power_description'] = 'La plateforme d\'apprentissage libre qui vous aide à mettre en place un enseignement en ligne et des apprentissages efficients, dans un environnement collaboratif et privé.';
$string['heroslide_power_headline'] = 'Puissant. Sûr. Libre.';
$string['heroslide_power_slidecontrol'] = 'Robuste plateforme d\'apprentissage libre';
$string['heroslide_story_description'] = '« Être à la pointe de l\'apprentissage au moyen des technologies nous permet de favoriser les découvertes, la créativité et les opportunités des étudiants.» – Prof. Darell Evans, Pro Vice-Chancelier (apprentissage et enseignement), Monash University';
$string['heroslide_story_headline'] = 'Améliore partout l\'enseignement et l\'apprentissage';
$string['heroslide_story_slidecontrol'] = 'Retours d\'expériences de Moodle dans le monde entier';
$string['jobs'] = 'Visitez notre base de données d\'emplois pour des informations sur des postes en lien avec Moodle, dans le monde entier.';
$string['logoinfo'] = 'Le nom Moodle™ est une marque déposée du Moodle Trust.

Si vous avez l\'intention d\'utiliser le nom et/ou le logo pour faire de la publicité pour des services génériques Moodle (par exemple hébergement Moodle, assistance Moodle, certification Moodle, formation Moodle, consulting Moodle, personnalisation Moodle, développement de cours Moodle, design de thèmes Moodle, intégrations de Moodle, installations de Moodle, etc.) ou comme nom d\'un logiciel, vous devez demander et recevoir la permission directe et écrite du Moodle Trust, via l\'[assistance de moodle.com](http://moodle.com/helpdesk/), en conformité avec les restrictions normales des marques déposées.

Il n\'y a aucune restriction sur l\'utilisation du nom dans d\'autres contextes (par exemple, si vous utilisez Moodle simplement pour fournir des cours, vous pouvez utiliser le nom librement pour y référer). Si vous avez des doutes sur un cas particulier, veuillez prendre contact avec nous via l\'[assistance de moodle.com](http://moodle.com/helpdesk/). Nous serons heureux de vous fournir une autorisation officielle écrite, ou bien de l\'aide pour modifier la rédaction de votre texte.';
$string['logotitle'] = 'Logo Moodle';
$string['moodlepartner_corporate'] = 'Formation en entreprise';
$string['moodlepartner_other'] = 'Autres secteurs';
$string['moodlepartner_school'] = 'École';
$string['moodlepartner_university'] = 'Université';
$string['networkinfo'] = 'Les sites ci-dessous sont connectés avec moodle.org au moyen du réseau Moodle, de sorte que vous pouvez vous y connecter directement depuis ici.';
$string['networktitle'] = 'Sites connectés';
$string['newregistrations'] = 'Nouveaux enregistrements';
$string['newstitle'] = 'Annonces';
$string['noenrolledcoursesyet'] = 'Vous n\'êtes encore inscrit à aucun cours sur ce site';
$string['partnerslogan'] = 'Le projet Moodle est soutenu par 60 partenaires Moodle dans le monde entier.<br/><a href="http://moodle.com/partners/about/">Plus d\'informations</a> sur le programme des partenaires Moodle. <a href="http://moodle.com/partners">Trouvez un partenaire Moodle</a> près de chez vous.';
$string['permalink'] = 'Permalien';
$string['pluginname'] = 'Site moodle.org';
$string['popularissues'] = 'Problématiques les plus populaires';
$string['recentlyratedposts'] = 'Messages évalués récemment';
$string['recentpart'] = 'Cette page montre quelques personnes ayant utilisé moodle.org aujourd\'hui.';
$string['registeredsites'] = 'Les institutions ne sont pas tenues d\'informer quiconque qu\'elles utilisent Moodle, car Moodle est un logiciel libre. Cependant, certains sites Moodle ont choisi de s\'enregistrer auprès de nous et nous en conservons une liste.';
$string['registeredsitestitle'] = 'Sites enregistrés';
$string['registereduserslastday'] = 'Nouveaux utilisateurs au cours des 24 dernières heures :';
$string['registereduserstotal'] = 'Total des utilisateurs enregistrés :';
$string['registrationgraphalt'] = 'Tous les enregistrements de Moodle';
$string['registrationgraphdesc'] = 'Nous effectuons un <a href="http://docs.moodle.org/en/Usage">contrôle régulier des sites</a> afin de nous assurer qu\'ils existent encore, c\'est pourquoi le nombre est parfois en diminution';
$string['registrationslast6months'] = 'Enregistrements durant les 6 derniers mois';
$string['registrationstotal'] = 'Tous les enregistrements actuels';
$string['resources_buzz'] = 'Buzz';
$string['resources_courses'] = 'Cours';
$string['resources_jobs'] = 'Emplois';
$string['resources_plugins'] = 'Plugins';
$string['roadmap'] = 'Planification de Moodle';
$string['rssdescription'] = 'Messages des forums de moodle.org évalués récemment ou comme utiles';
$string['rsstitle'] = 'Messages des forums de moodle.org';
$string['searchmoodleorg'] = 'Rechercher sur moodle.org';
$string['securitytitle'] = 'Annonces de sécurité';
$string['shop'] = 'Vous cherchez un moyen de montrer que vous faites partie de notre communauté ? Visitez notre magasin en ligne : T-shirts, tasses et beaucoup d\'autres choses pourront vous intéresser.';
$string['social-facebook-moodle'] = 'Page Facebook officielle de Moodle';
$string['social-googleplus-community'] = 'Page Google+ officielle de la communauté Moodle';
$string['social-googleplus-moodle'] = 'Page Google+ officielle de Moodle';
$string['socialinfo'] = 'Nous sommes présents sur plusieurs réseaux sociaux pour sensibiliser le public sur le projet Moodle et partager les dernières nouvelles et événements du monde de Moodle. Suivez-nous pour rester à jour et rencontrer d\'autres personnes de la communauté !';
$string['social-linkedin-moodle'] = 'Page LinkedIn officielle de Moodle';
$string['socialtitle'] = 'Média sociaux';
$string['social-twitter-moodle'] = 'Annonces officielles de Moodle, nouvelles sur Moodle agrégées depuis Planète Moodle et Buzz Moodle, ainsi que les messages utiles des forums';
$string['social-twitter-moodledev'] = 'Nouvelles du développement de Moodle et des mises à jour';
$string['social-twitter-moodlehq'] = 'Tweets de Moodle HQ';
$string['social-twitter-moodlejobs'] = 'Postes de travail Moodle proposés';
$string['social-twitter-moodlenet'] = 'Cours et contenus Moodle partagés';
$string['social-twitter-moodleplugins'] = 'Plugins Moodle publiés récemment';
$string['social-twitter-moodleresearch'] = 'Nouvelles sur la conférence annuelle Moodle Research Conference et sur les recherches en lien avec Moodle';
$string['social-twitter-moodlesecurity'] = 'Annonces de sécurité Moodle';
$string['social-twitter-moodlesites'] = 'Annonces sur le statut des sites web et services de Moodle HQ';
$string['social-twitter-moodlethemes'] = 'Thèmes Moodle publiés récemment';
$string['social-youtube-moodle'] = 'Chaîne YouTube officielle de Moodle';
$string['statscountries'] = 'Pays';
$string['statscourses'] = 'Cours';
$string['statsenrolments'] = 'Inscriptions';
$string['statsposts'] = 'Messages des forums';
$string['statsquestions'] = 'Questions de tests';
$string['statsresources'] = 'Ressources';
$string['statsteachers'] = 'Enseignants';
$string['statsusers'] = 'Utilisateurs';
$string['supportbooks'] = 'Nous tenons à jour une liste des nombreux livres Moodle disponibles.';
$string['supportcommercial'] = 'Les partenaires Moodle sont des fournisseurs de services certifiés du monde entier qui peuvent vous aider dans votre implémentation de Moodle.';
$string['supportdocs1'] = 'Moodle Docs est un bon endroit pour commencer, notamment les pages « Foire aux questions » (FAQ).';
$string['supportdocs2'] = 'Une façon simple et facile d\'accéder à la documentation est l\'utilisation des liens « Documentation Moodle pour cette page » au bas de chaque page de votre propre site Moodle.';
$string['supportdocsfaq'] = 'Foire aux questions (FAQ)';
$string['supportdocslang'] = 'Moodle Docs dans d\'autres langues';
$string['supportforums'] = 'Notre communauté d\'utilisateurs communique principalement au moyen de forums situés dans des « cours » sur ce site Moodle. Vous devez vous « inscrire » à un cours pour participer aux discussions des forums qu\'il contient (l\'inscription est totalement gratuite).';
$string['supportforumsenglish'] = 'L\'assistance principale et les discussions entre développeurs et utilisateurs ont lieu ici, en anglais :';
$string['supportforumsenglishname'] = 'Using Moodle';
$string['supportforumslang'] = 'L\'espace où se tiennent toutes les discussions autour de Moodle en français est accessible ici :';
$string['supportforumslangname'] = 'Moodle en Français';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=20';
$string['supportforumslist'] = 'Nous avons également beaucoup d\'autres forums, dans différentes langues :';
$string['supportforumslistname'] = 'Liste de tous les cours';
$string['supportintro'] = 'Vous n\'êtes pas tout seul ! Il y a une multitude de façons d\'obtenir de l\'aide sur Moodle.';
$string['top10countriesbyregistration'] = 'Top 10 des pays, par enregistrements';
$string['top10sitesbycourses'] = 'Top 10 des sites, par cours';
$string['top10sitesbyusers'] = 'Top 10 des sites, par utilisateurs';
$string['url-about'] = 'http://docs.moodle.org/fr/À_propos_de_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/fr/Installation';
$string['url-standards'] = 'http://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/fr/';
$string['versionsused'] = 'Versions utilisées';
