#!/bin/bash

moderegistration=$(CreoleGet ninegate_moderegistration none)
labelsniveau01=$(CreoleGet ninegate_niveau01labels non)
iconniveau01=$(CreoleGet ninegate_niveau01icon non) 
affniveau02=$(CreoleGet ninegate_niveau02view non)
labelsniveau02=$(CreoleGet ninegate_niveau02labels non)
iconniveau02=$(CreoleGet ninegate_niveau02icon non) 
weburl=$(CreoleGet web_url non) 
ninegate_websocket=$(CreoleGet ninegate_activate_websocket non) 
websocket_url=$(CreoleGet adresse_ip_eth0 non) 
websocket_portinterne=$(CreoleGet ninegate_websocket_portinterne non) 

www_dir="$container_path_web/var/www/html"

# Récuper les composer associés à la version de php installé
version74=`php -r 'echo version_compare(phpversion(), "7.4.0", ">=");'`
if [[ "$version74" == "1" ]]
then
    cp -rf /var/www/html/ninegate/scripts/php74/composer.json /var/www/html/ninegate/composer.json
    cp -rf /var/www/html/ninegate/scripts/php74/composer.lock /var/www/html/ninegate/composer.lock
else
    version72=`php -r 'echo version_compare(phpversion(), "7.2.0", ">=");'`
    if [[ "$version72" == "1" ]]
    then
        cp -rf /var/www/html/ninegate/scripts/php72/composer.json /var/www/html/ninegate/composer.json
        cp -rf /var/www/html/ninegate/scripts/php72/composer.lock /var/www/html/ninegate/composer.lock
    else
        version70=`php -r 'echo version_compare(phpversion(), "7.0.0", ">=");'`
        if [[ "$version70" == "1" ]]
        then
            cp -rf /var/www/html/ninegate/scripts/php70/composer.json /var/www/html/ninegate/composer.json
            cp -rf /var/www/html/ninegate/scripts/php70/composer.lock /var/www/html/ninegate/composer.lock
        fi
    fi
fi

# Suppression des logs trop ancien
find var/logs -mindepth 1 -mtime +7 -delete

# Installation des dépendances composer
echo COMPOSER = Install
export COMPOSER_ALLOW_SUPERUSER=1
composer self-update --1 --quiet
composer install --quiet
rm -f /var/www/html/ninegate/var/logs/dev.log

# Permissions
./perm.sh www-data

# Copie des polices du projet dans le rep web
cp -rf src/Cadoles/CoreBundle/Resources/public/fonts web/

# Copie de la commande local de base si elle la commande n'existe pas
if [ ! -f src/Cadoles/CoreBundle/Command/LocalCommand.php ]; then
    cp -rf scripts/LocalCommand.php src/Cadoles/CoreBundle/Command/LocalCommand.php
fi

# Nettoyage du cache
echo 
echo CACHE = Refresh
rm /var/www/html/ninegate/var/cache -rf > /dev/null
php bin/console cache:clear --env=prod --no-debug --quiet

# Migration si nécessaire du schéma de la base
php bin/console doctrine:schema:update --force --env=prod --no-debug --quiet

# Insertion data de base
php bin/console Core:InitData --env=prod
php bin/console Cron:InitData --env=prod
php bin/console Portal:InitData --env=prod

# Passage des scripts
php bin/console Core:Script --env=prod

# Passage des scripts locaux
php bin/console Core:Local --env=prod

# Generation des assets
echo ASSET = Dump
bin/console assetic:dump --env=prod  --quiet

# Permissions
./perm.sh www-data

# Server Websocket
if [[ "$ninegate_websocket" = 'oui' ]]
then
    echo 
    /var/www/html/ninegate/scripts/ninegate-websocket.sh
fi

echo 