#!/bin/bash

# Se positionner sur la racine du projet
DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
cd ${DIR}
cd ../..
DIR=$(pwd)

# Import des env
. $DIR/.env
. $DIR/.env.local

# Déclaration d'un proxy
if [[ "$WSS_USE" == "1" ]]
then
    # Server Websocket
    if [[ "$1" != "restartifdown" ]]; then
        echo WEBSOCKET = STOP
        pid="$(pgrep -a -f app:Websocket| grep $ALIAS)"
        if [ -n "${pid}" ]; then
            IFS=' ' read -r -a array <<< "$pid"
            kill -9 ${array[0]};
        fi
    fi

    # Port LISTEN ?
    pid="$(pgrep -a -f app:Websocket| grep $ALIAS)"
    restart="yes"
    if [ "$1" == "restartifdown" ] && [ -n "${pid}" ] ; then
        restart="no"
    fi

    if [ "$restart" == "yes" ] && [ "$1" != "stop" ] ; then
        echo WEBSOCKET = START
        systemctl restart wss$ALIAS
    fi
fi