<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\Persistence\ManagerRegistry;

use App\Entity\Alertcategory;
use App\Form\AlertcategoryType;

class AlertcategoryController extends AbstractController
{
    private $nameentity  = 'Alertcategory';
    private $labelentity = 'App\Entity\Alertcategory';
    private $labelroute  = 'app_portal_config_alertcategory';
    private $labeldata   = 'alertcategory';
    private $labeldatas  = 'alertcategorys';

    public function submit(Request $request, ManagerRegistry $em)
    {
        // Initialisation de l'enregistrement
        $data = new Alertcategory();
        
        // Création du formulaire
        $form = $this->createForm(AlertcategoryType::class,$data,array("mode"=>"submit"));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  

            $idicon = $form->get('idicon')->getData();
            $icon=$em->getRepository("App\Entity\Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);

            // Sauvegarde
            $em->getManager()->persist($data);
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute("app_portal_config_alert");
        }
        
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,
            $this->labeldata    => $data,
            'mode'              => 'submit',
            'icons'             => $em->getRepository("App\Entity\Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }  

    public function update($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id,$em);
        
        // Vérifier que cet enregistrement est modifiable
                                    
        // Création du formulaire
        $form = $this->createForm(AlertcategoryType::class,$data,array(
            "mode"      =>"update",
            "idicon"    => ($data->getIcon()?$data->getIcon()->getId():null),
        ));

        // Récupération des data du formulaire
        $form->handleRequest($request);
    
        // Sur erreur
        $this->getErrorForm($id,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            $idicon = $form->get('idicon')->getData();
            $icon=$em->getRepository("App\Entity\Icon")->findoneby(["id"=>$idicon]);
            $data->setIcon($icon);

            // Sauvegarde
            $em->getManager()->flush();

            // Retour à la liste
            return $this->redirectToRoute("app_portal_config_alert");
        }
        
       
        // Affichage du formulaire
        return $this->render($this->nameentity.'\edit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,            
            $this->labeldata    => $data,
            'mode'              => 'update',
            'icons'             => $em->getRepository("App\Entity\Icon")->findAll(),
            'form'              => $form->createView()
        ]);
    }

    public function delete($id,Request $request, ManagerRegistry $em)
    {
        // Récupération de l'enregistrement courant 
        $data=$this->getData($id,$em);

        // Vérifier que cet enregistrement est supprimable

        // Supprimer la donnée
        $em->getManager()->remove($data);
        $em->getManager()->flush();
        
        return $this->redirectToRoute("app_portal_config_alert");
    }

    protected function getDatas($em)
    {
        $datas = $em->getRepository($this->labelentity)->findAll();
        return $datas;
    } 
            
    protected function getData($id,$em)
    {
        $data = $em->getRepository($this->labelentity)->find($id);

        if (!$data) {
            throw $this->createNotFoundException('Unable to find '.$this->labeldata);
        }

        return $data;
    } 

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }    
}
