<?php

namespace Cadoles\CoreBundle\Service;

use Cadoles\CoreBundle\Entity\User;
use Cadoles\CoreBundle\Entity\Group;
use Cadoles\CoreBundle\Entity\UserGroup;
use Doctrine\ORM\EntityManager;
use Symfony\Component\HttpFoundation\Response;

class onlyService
{
    protected $container;
    protected $em;    
    
    protected $only_activate = false;
    protected $only_url;
    protected $only_host;
    protected $only_user;
    protected $only_password;
    protected $debug = false;
    protected $headers = [];
    
    public function __construct($container, EntityManager $em)
    {
        $this->container = $container;
        $this->em = $em;
        
        $this->only_activate = $this->container->getParameter('activate_widonlyoffice');
        if($this->only_activate) {
            $this->only_activate=$this->container->getParameter('widonlyoffice_sync');
            if($this->only_activate) {
                $this->only_url         = $this->container->getParameter('widonlyoffice_url')."/api/2.0/";
                $this->only_user        = $this->container->getParameter('widonlyoffice_user');
                $this->only_password    = $this->container->getParameter('widonlyoffice_password');
                $this->only_host        = str_replace("https://","",str_replace("http://","",$this->container->getParameter("widonlyoffice_url")));
            }
        }
    }

    public function isEnabled() {
        return $this->only_activate;
    }

//==================================================================================================================================================================    
//== Function User==================================================================================================================================================
//==================================================================================================================================================================

    public function syncUser(User $user) {
        /* Pour l'instant ne sert plus en effet la synchro du côté only ne permet pas de modifier le mail d'une personne
        Et une personne lié à une fiche ldap sur only on ne peut pas nom plus modifier nom et prénom
        
        $this->mydebug("==SYNC ONLY USER==========================================================");
        
        // Authentification à Only
        if($this->authOnly()) {
            // Recherche utilisateur only
            $this->mydebug("Recherche utilisateur only");
            $respuser = \Unirest\Request::get($this->only_url.'/people/'.$user->getUsername(),$this->headers);

            // Si existe modification
            if(!$this->koresponse($respuser)) {
                $this->mydebug("Modification user = ".$user->getUsername());
                $onlyuser=$respuser->body->response;
                
                // Si véritable modification
                if($onlyuser->firstName!=$user->getFirstname()||$onlyuser->lastName!=$user->getLastname()||$onlyuser->email!=$user->getEmail()) {
                    $this->mydebug("Lancer la modification");
                    $this->mydebug($onlyuser->firstName." !=".$user->getFirstname());
                    $this->mydebug($onlyuser->lastName." !=".$user->getLastname());
                    $this->mydebug($onlyuser->email." !=".$user->getEmail());

                    $query      = array(
                        'firstName' => $user->getFirstname(),
                        'lastName' => $user->getLastname(),
                        'email' => $user->getEmail(),
                    );
                    $body       = \Unirest\Request\Body::json($query);
                    $respupdate = \Unirest\Request::put($this->only_url.'/people/'.$onlyuser->id,$this->headers,$body);
                }
            }
            
            // Sinon création
            else {
                $this->mydebug("Création user = ".$user->getUsername());
            }

        }

        
        //$respuser = \Unirest\Request::get($this->only_url.'/people/'.$onlygroup->responsible->id,$this->headers);

        // Correspondance profil ldapuser = profil eportail

        // Si existe modification

        // Sinon création

        // Ratacchement utilisateur group
        */

        return true;
    }

    public function delUser(User $user) {
        // On recherche l'utilisateur eportail

        // Si existe suppression

        return true;
    }

//==================================================================================================================================================================    
//== Function Groupe================================================================================================================================================
//==================================================================================================================================================================

    public function syncGroup(Group $group, $oldid) {
        if($group->getNosynconly()) return true;

        $this->mydebug("==SYNC ONLY GROUP=========================================================");

        // Authentification à Only
        if($this->authOnly()) {
            // Si groupe de travail
            if($group->getFgcanshare()) {
                // Info du groupe
                $grouptitle=$group->getLabel();
                $groupdescription=$group->getDescription();
                $groupowner=$group->getOwner();
                $groupisprivate=true;
                $tocreate=false;

                // Si pas de propriétaire de projet on le rattache à admin
                if(!$groupowner)
                    $groupowner=$this->em->getRepository("CadolesCoreBundle:USer")->findOneBy(["username"=>"admin"]);

                if($groupowner) {
                    // On recherche le propriétaire du groupe dans only
                    $this->mydebug("Recherche du propriétaire du group only");
                    $respuser   = \Unirest\Request::get($this->only_url.'/people/'.$groupowner->getUsername(),$this->headers);

                    // Normalement on a toujours le propriétaire dans only
                    if(!$this->koresponse($respuser)) {
                        // Si idonlyoffice de lié
                        if($group->getIdonlyoffice()) {
                            // Recherche groupe only
                            $this->mydebug("Recherche group only ".$group->getIdonlyoffice());
                            $respgroup = \Unirest\Request::get($this->only_url.'/project/'.$group->getIdonlyoffice(),$this->headers);

                            // Si existe modification
                            if(!$this->koresponse($respgroup)) {
                                $this->mydebug("Modification Group = ".$group->getLabel());
                                $onlygroup=$respgroup->body->response;
                                
                                // Si véritable modification
                                if($onlygroup->status!=0||$onlygroup->responsible->userName!=$groupowner->getUsername()||$onlygroup->title!=$grouptitle||$onlygroup->description!=$groupdescription||$onlygroup->isPrivate!=$groupisprivate) {
                                    $this->mydebug("Lancer la modification");
                                    $this->mydebug($respuser->body->response->userName." != ".$groupowner->getUsername());
                                    $this->mydebug($onlygroup->title." != ".$grouptitle);
                                    $this->mydebug($onlygroup->description." != ".$groupdescription);
                                    $this->mydebug($onlygroup->isPrivate." != ".$groupisprivate);
                                    $this->mydebug($onlygroup->status." != 0");

                                    // Liste des membres Only
                                    $membersOnly=[];
                                    $respmember = \Unirest\Request::get($this->only_url.'/project/'.$group->getIdonlyoffice().'/team',$this->headers);
                                    if(!$this->koresponse($respmember)) {
                                        foreach($respmember->body->response as $member) {
                                            array_push($membersOnly,$member->id);
                                        }

                                        $query      = array(
                                            'title'         => $grouptitle,
                                            'description'   => $groupdescription,
                                            'responsibleId' => $respuser->body->response->id,
                                            'participants'  => $membersOnly,
                                            'private'       => $groupisprivate,
                                            'status'        => 0,
                                            'notify'        => true
                                        );
                                        $body       = \Unirest\Request\Body::json($query);
                                        $respupdate = \Unirest\Request::put($this->only_url.'/project/'.$onlygroup->id,$this->headers,$body);
                                    }
                                }
                            }

                            // Sinon c'est qu'il a été supprimé via only : il faut donc le regénérer
                            else {
                                $tocreate=true;
                            }
                        }

                        // Sinon il faut le créer dans only
                        else {
                            $tocreate=true;
                        }

                        // Création 
                        if($tocreate) {
                            $this->mydebug("Création Group = ".$group->getLabel());
                            $query      = array(
                                'title'         => $grouptitle,
                                'description'   => $groupdescription,
                                'responsibleId' => $respuser->body->response->id,
                                'private'       => $groupisprivate,
                                'notify'        => true
                            );
                            $body       = \Unirest\Request\Body::json($query);
                            $respsubmit = \Unirest\Request::post($this->only_url.'/project/withSecurity',$this->headers,$body);
                            if(!$this->koresponse($respsubmit)) {
                                $group->setIdonlyoffice($respsubmit->body->response->id);
                                $this->em->persist($group);
                                $this->em->flush();                                    
                            }                  
                        }
                    }
                }
            }

            // Si non groupe de travail mais avec un id Only, on supprime le groupe only
            elseif($group->getIdonlyoffice()) {
                $this->mydebug("Groupe lié à only mais qui n'est plus un groupe de travail");
                $this->delGroup($group);
            }
        }

        return true;
    }

    public function delGroup(Group $group) {
        // Si groupe associé à un groupe only
        if($group->getIdonlyoffice()) {
            $grouptitle=$group->getLabel();
            $groupdescription=$group->getDescription();
            $groupowner=$group->getOwner();
            $groupisprivate=true;

            // Si pas de propriétaire de projet on le rattache à admin
            if(!$groupowner)
                $groupowner=$this->em->getRepository("CadolesCoreBundle:User")->findOneBy(["username"=>"admin"]);

            if($groupowner&&$this->authOnly()) {
                // On recherche le propriétaire du groupe dans only
                $respuser   = \Unirest\Request::get($this->only_url.'/people/'.$groupowner->getUsername(),$this->headers);
                if(!$this->koresponse($respuser)) {
                    $respgroup = \Unirest\Request::get($this->only_url.'/project/'.$group->getIdonlyoffice(),$this->headers);
                    if(!$this->koresponse($respgroup)) {
                        $this->mydebug("Fermer le groupe ".$group->getLabel()." ".$group->getIdonlyoffice());

                        $membersOnly=[];
                        $respmember = \Unirest\Request::get($this->only_url.'/project/'.$group->getIdonlyoffice().'/team',$this->headers);
                        if(!$this->koresponse($respmember)) {
                            foreach($respmember->body->response as $member) {
                                array_push($membersOnly,$member->id);
                            }

                            // On ferme le projet
                            $query      = array(
                                'title'         => $grouptitle,
                                'description'   => $groupdescription,
                                'responsibleId' => $respuser->body->response->id,
                                'participants'  => $membersOnly,
                                'private'       => $groupisprivate,
                                'status'        => 1,
                                'notify'        => true
                            );
                            $body       = \Unirest\Request\Body::json($query);
                            $respupdate = \Unirest\Request::put($this->only_url.'/project/'.$group->getIdonlyoffice(),$this->headers,$body);
                        }
                    }
                }
            }
        }

        return true;
    }

//==================================================================================================================================================================    
//== Function GroupUser=============================================================================================================================================
//==================================================================================================================================================================

public function delUserGroup(UserGroup $usergroup) {
    // Si groupe lié à only
    if($usergroup->getGroup()->getIdonlyoffice()) {
        if($this->authOnly()) {
            $respuser = \Unirest\Request::get($this->only_url.'/people/'.$usergroup->getUser()->getUsername(),$this->headers);
            if(!$this->koresponse($respuser)) {
                $query      = array('userId' => $respuser->body->response->id);
                $body       = \Unirest\Request\Body::json($query);
                $respsubmit = \Unirest\Request::delete($this->only_url.'/project/'.$usergroup->getGroup()->getIdonlyoffice().'/team',$this->headers,$body);
            }
        }
    }
}

public function addUserGroup(UserGroup $usergroup) {
    // Si groupe lié à only
    if($usergroup->getGroup()->getIdonlyoffice()) {
        if($this->authOnly()) {
            $respuser = \Unirest\Request::get($this->only_url.'/people/'.$usergroup->getUser()->getUsername(),$this->headers);
            if(!$this->koresponse($respuser)) {
                $query      = array('userId' => $respuser->body->response->id);
                $body       = \Unirest\Request\Body::json($query);
                $respsubmit = \Unirest\Request::post($this->only_url.'/project/'.$usergroup->getGroup()->getIdonlyoffice().'/team',$this->headers,$body);
            }
        }
    }
}




private function authOnly() {
    // Only Office est-il dans le domaine 
    if(stripos($this->only_url,"/")===0)
        $this->only_url="https://".$this->container->getParameter("weburl").$this->only_url;
    $indomaine = (stripos($this->only_url,$this->container->getParameter("weburl"))!==false);

    // Si hors domaine on utilise le proxy si proxy il y a 
    if(!$indomaine) {
        $PROXYactivate = $this->em->getRepository("CadolesCoreBundle:Config")->find("PROXYactivate")->getValue();
        if($PROXYactivate) {
            $PROXYserver    = $this->em->getRepository("CadolesCoreBundle:Config")->find("PROXYserver")->getValue();
            $PROXYport      = $this->em->getRepository("CadolesCoreBundle:Config")->find("PROXYport")->getValue();                    
            \Unirest\Request::proxy($PROXYserver, $PROXYport, CURLPROXY_HTTP, true);
        }
    }

    \Unirest\Request::verifyPeer(false);
    \Unirest\Request::verifyHost(false);
    \Unirest\Request::timeout(5);
    $this->headers  = ['Host' => $this->only_host, 'Accept' => 'application/json','Content-Type'=>'application/json','Retry-After'=>'5'];
    $query          = array('userName' => $this->only_user, 'password' => $this->only_password);
    $body           = \Unirest\Request\Body::json($query);

    $response   = \Unirest\Request::post($this->only_url.'/authentication',$this->headers,$body);
    if($this->koresponse($response)) return false;
    $token=$response->body->response->token;
    $this->headers["Authorization"]=$token;    
    return true;
}

private function koresponse($response) {
    if($response->code>=Response::HTTP_BAD_REQUEST) {
        $this->mydebug("ERREUR ".$response->code);
        if(property_exists($response,"body") && property_exists($response->body,"error")) $this->mydebug("ERREUR ".$response->body->error->message);;
        return true;
    }

    return false;
} 

private function mydebug($texte) {
    if($this->debug) error_log($texte);
}

}

